/************************************************************************
 *                                                                      *
 *   Ant Renamer 1.x                                                    *
 *   (C) 2000-2002 Antoine Potten                                       *
 *   antoine@buypin.com - http://www.buypin.com                         *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************/

//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "options.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TOptionsWin *OptionsWin;

void __fastcall TOptionsWin::ChangeLanguage(TIniFile *ini)
{
     if(ini!=NULL) {
          Caption=ini->ReadString("Options","WindowTitle","Options");
          B_Cancel->Caption=ini->ReadString("Options","Cancel","Cancel");
          B_OK->Caption=ini->ReadString("Options","OK","OK");
          CB_AlwaysColor->Caption=ini->ReadString("Options","CB_AlwaysColor","Always show color");
          CB_ClearList->Caption=ini->ReadString("Options","CB_ClearList","Clear file list after successful renaming process");
          CB_FlatButtons->Caption=ini->ReadString("Options","CB_FlatButtons","Flat buttons");
          CB_Labels->Caption=ini->ReadString("Options","CB_Labels","Show buttons labels");
          L_Language->Caption=ini->ReadString("Options","L_Language","Program language :");
          L_LineGeneral->Caption=ini->ReadString("Options","LineGeneral","General");
          L_LineToolbar->Caption=ini->ReadString("Options","LineToolbar","Toolbar");
     }
}

void __fastcall TOptionsWin::SaveOptions(void)
{
     TIniFile *ini;
     ini = new TIniFile(ChangeFileExt(Application->ExeName,".ini"));
     ini->WriteBool("General","ClearList",CB_ClearList->Checked);
     ini->WriteBool("Toolbar","AlwaysColor",CB_AlwaysColor->Checked);
     ini->WriteBool("Toolbar","Labels",CB_Labels->Checked);
     ini->WriteBool("Toolbar","FlatButtons",CB_FlatButtons->Checked);
     ini->WriteString("General","Language",C_Language->Items->Strings[C_Language->ItemIndex]);
     delete ini;
}

void __fastcall TOptionsWin::LoadOptions(void)
{
     TIniFile *ini;
     ini = new TIniFile(ChangeFileExt(Application->ExeName,".ini"));
     CB_ClearList->Checked=ini->ReadBool("General","ClearList",false);
     CB_AlwaysColor->Checked=ini->ReadBool("Toolbar","AlwaysColor",false);
     CB_Labels->Checked=ini->ReadBool("Toolbar","Labels",true);
     CB_FlatButtons->Checked=ini->ReadBool("Toolbar","FlatButtons",true);
     try {
          C_Language->ItemIndex=C_Language->Items->IndexOf(ini->ReadString("General","Language","[default]"));
     } catch(...) {
          C_Language->ItemIndex=0;
     }
     delete ini;
}

//---------------------------------------------------------------------------
__fastcall TOptionsWin::TOptionsWin(TComponent* Owner)
     : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TOptionsWin::B_OKClick(TObject *Sender)
{
     SaveOptions();
     ModalResult=mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TOptionsWin::FormCreate(TObject *Sender)
{
     TSearchRec SearchRecord;
     int RemaindFiles;
     SetCurrentDir(ExtractFilePath(Application->ExeName));
     for(RemaindFiles=FindFirst("*.lng",faAnyFile,SearchRecord);
              RemaindFiles==0;RemaindFiles=FindNext(SearchRecord)) {
          C_Language->Items->Add(ChangeFileExt(SearchRecord.Name,""));
     }
     LoadOptions();
     FindClose(SearchRecord);
}
//---------------------------------------------------------------------------


void __fastcall TOptionsWin::FormShow(TObject *Sender)
{
     LoadOptions();
}
//---------------------------------------------------------------------------


