/************************************************************************
 *                                                                      *
 *   Ant Renamer 1.x                                                    *
 *   (C) 2000-2002 Antoine Potten                                       *
 *   antoine@buypin.com - http://www.buypin.com                         *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************/

//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "objects.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

//------------------------------------------------------------------------------

TRenFile::TRenFile(AnsiString strFilePath) : TObject()
{
     strName = ExtractFileName(strFilePath);
     strFolder = ExtractFilePath(strFilePath);
     strOldName = "";
}

//------------------------------------------------------------------------------

bool __fastcall TRenFile::Rename(AnsiString strNewName)
{
     bool result;
     strOldName = strName;
     result = RenameFile(strFolder + strName, strFolder + strNewName);
     if(result) {
          strName = strNewName;
     } else {
          strOldName = "";
     }
     return result;
}

//------------------------------------------------------------------------------

bool __fastcall TRenFile::Revert()
{
     bool result = true;
     if(strOldName.Length() > 0) {
          result = RenameFile(strFolder + strName, strFolder + strOldName);
          if(result) {
               strName = strOldName;
               strOldName = "";
          }
     }
     return result;
}

//------------------------------------------------------------------------------

AnsiString __fastcall TRenFile::FileFolder()
{
     return strFolder;
}

//------------------------------------------------------------------------------

AnsiString __fastcall TRenFile::FilePath()
{
     return strFolder+strName;
}

//------------------------------------------------------------------------------

AnsiString __fastcall TRenFile::FormatedFilePath()
{
     return strFolder+DELIMITER_CHAR+strName;
}

//------------------------------------------------------------------------------

AnsiString __fastcall TRenFile::FileName()
{
     return strName;
}

//------------------------------------------------------------------------------

AnsiString __fastcall TRenFile::FileExt()
{
     return ExtractFileExt(strName);
}

//------------------------------------------------------------------------------


