/************************************************************************
 *                                                                      *
 *   Ant Renamer 1.x                                                    *
 *   (C) 2000-2002 Antoine Potten                                       *
 *   antoine@buypin.com - http://www.buypin.com                         *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************/

//---------------------------------------------------------------------------

#ifndef mainH
#define mainH

//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ActnList.hpp>
#include <ComCtrls.hpp>
#include <ToolWin.hpp>
#include <ImgList.hpp>
#include <ExtCtrls.hpp>
#include <FileCtrl.hpp>
#include <Buttons.hpp>
#include <Dialogs.hpp>
#include "CGAUGES.h"
#include "CSPIN.h"
#include <Menus.hpp>
#include <vcl\inifiles.hpp>
#include <Graphics.hpp>
#include "objects.h"
#include "LMDCustomScrollBox.hpp"
#include "LMDListBox.hpp"
#include "BUDragDrop.hpp"
#include "BUOpenDialog.hpp"
//---------------------------------------------------------------------------
#define CHANGE_EXT 0
#define STR_REPL 1
#define STR_INSERT 2
#define CHAR_DEL 3
#define ENUMERATION 4
#define MP3ID 5
#define DATETIME 6
#define RANDOMNAMES 7
#define CHANGECASE 8
//---------------------------------------------------------------------------
#define ERROR_RENAME 0
#define ERROR_MP3TAG 1
#define ERROR_404    2
#define ERROR_REVERT 3
//---------------------------------------------------------------------------
#define TABSHEET_FILES        0
#define TABSHEET_OPERATION    1
#define TABSHEET_PREVIEW      2
#define TABSHEET_ERRORS       3
//---------------------------------------------------------------------------
class TMainWin : public TForm
{
__published:
     TImageList *IL_Toolbar;
     TImageList *IL_Toolbar_Grey;
     TActionList *Actions;
          TAction *Action_Stop;
          TAction *Action_RemoveDead;
     TAction *Action_MoveUp;
     TAction *Action_MoveDown;
     TAction *Action_MoveTop;
     TAction *Action_MoveBottom;
     TAction *Action_Preview;
          TAction *Action_Exit;
          TAction *Action_About;
          TAction *Action_Options;
          TAction *Action_Add;
          TAction *Action_Remove;
          TAction *Action_AddFolder;
          TAction *Action_AddFolder2;
          TAction *Action_Go;
          TAction *Action_RemoveAll;
          TAction *Action_AddFiles;
          TAction *Action_Replace;
          TAction *Action_Insert;
          TAction *Action_Delete;
          TAction *Action_ChoseAction;
          TAction *Action_Undo;
     TPanel *Panel1;
     TPageControl *PageControl;
          TTabSheet *TabSheetFiles;
          TTabSheet *TabSheetOperation;
          TTabSheet *TabSheetErrors;
          TTabSheet *TabSheetPreview;
     TCGauge *ProgressBar;
     TListBox *LB_Operations;
     TPanel *Panel2;
     TPageControl *OperationPages;
          TTabSheet *Operation1;
          TTabSheet *Operation2;
          TTabSheet *Operation3;
          TTabSheet *Operation4;
          TTabSheet *Operation5;
          TTabSheet *Operation6;
          TTabSheet *Operation7;
     TLabel *L_NoteExt;
     TLabel *L_Source;
     TEdit *E_Source;
     TLabel *L_Dest;
     TEdit *E_Dest;
     TLabel *L_Insert;
     TEdit *E_Insert;
     TRadioButton *RB_Position;
     TRadioButton *RB_After;
     TEdit *E_After;
     TCSpinEdit *E_Position;
     TLabel *L_NumberDelete;
     TCSpinEdit *E_NumberDel;
     TRadioButton *RB_DelPosition;
     TCSpinEdit *E_DelPosition;
     TRadioButton *RB_DelAfter;
     TEdit *E_DelAfter;
     TLabel *L_NoteDel;
     TLabel *L_NoteDel2;
     TLabel *L_Leading;
     TEdit *E_Leading;
     TLabel *L_NumberDigits;
     TCSpinEdit *E_EnumDigits;
     TLabel *L_Increment;
     TCSpinEdit *E_EnumIncr;
     TLabel *L_Ending;
     TEdit *E_Ending;
     TLabel *L_Mask;
     TEdit *E_Mask;
     TLabel *L_Note;
     TLabel *L_ID1;
     TLabel *L_ID2;
     TLabel *L_ID3;
     TLabel *L_ID4;
     TLabel *L_ID5;
     TLabel *L_ID6;
     TCheckBox *CB_KeepOldName;
     TLabel *L_Start;
     TCSpinEdit *E_EnumStart;
     TMemo *E_Log;
     TLabel *L_Percent1;
     TLabel *L_Percent2;
     TPopupMenu *PopupMenuAdd;
     TPopupMenu *PopupMenuRemove;
     TMenuItem *Addfiles1;
     TMenuItem *Addallfilesofafolder1;
     TMenuItem *Addallfilesofafolderandsubfolders1;
     TMenuItem *Removefiles1;
     TMenuItem *Removeallthefiles1;
     TSplitter *Splitter1;
     TTabSheet *Operation0;
     TCheckBox *CB_DateSuffix;
     TLabel *CB_DateSuffix2;
     TLabel *L_Ex_ReplSource;
     TLabel *Label1;
     TLabel *L_Ex_ReplDest;
     TLabel *L_Ex_InsertSource;
     TLabel *Label3;
     TLabel *L_Ex_InsertDest;
     TLabel *L_Ex_DelSource;
     TLabel *Label4;
     TLabel *L_Ex_DelDest;
     TMenuItem *Removedeadfiles1;
     TComboBox *E_NewExt;
     TCheckBox *CB_ReplAllOccurences;
     TCheckBox *CB_InsertAllOccurences;
     TLabel *L_DateMask;
     TEdit *E_DateMask;
     TLabel *L_DateNote;
     TMemo *L_DateMasks;
     TLabel *L_DateSeparator;
     TEdit *E_DateSeparator;
     TLabel *L_TimeSeparator;
     TEdit *E_TimeSeparator;
     TRadioButton *RB_ExtRepl;
     TRadioButton *RB_ExtCreate;
     TCSpinEdit *E_ExtStart;
     TLabel *L_ExtStart;
     TLabel *L_ExtIncr;
     TCSpinEdit *E_ExtIncr;
     TTabSheet *Operation8;
     TLabel *L_Random;
     TLabel *L_ID8;
     TCheckBox *CB_ConvertSymbols;
     TBUDragDrop *DropTarget;
     TBUOpenDialog *OD_Select;
     TTabSheet *Operation9;
     TRadioButton *RB_LowerCase;
     TRadioButton *RB_UpperCase;
     TLabel *L_Case;
     TRadioButton *RB_EachWord;
     TRadioButton *RB_FirstLetter;
     TCheckBox *CB_FirstFollowing;
     TEdit *E_FirstFollowing;
     TLabel *L_ID7;
     TCheckBox *CB_AppendExt;
     TToolBar *Toolbar;
        TToolButton *TBB_Add;
        TToolButton *TBB_Remove;
        TToolButton *ToolButton9;
        TToolButton *TBB_Process;
        TToolButton *TBB_Undo;
        TToolButton *ToolButton4;
        TToolButton *TBB_Options;
        TToolButton *TBB_About;
        TToolButton *ToolButton3;
        TToolButton *TBB_Exit;
     TPopupMenu *PopupMenuFiles;
     TMenuItem *MoveUp1;
     TMenuItem *MoveDown1;
     TMenuItem *N1;
     TMenuItem *MoveatTop1;
     TMenuItem *MoveatBottom1;
     TPopupMenu *PopupMenuPreview;
     TMenuItem *Removedeadfiles2;
     TMenuItem *Refresh1;
     TLMDListBox *LV_Files;
     TLMDListBox *LV_Preview;
     TPanel *PanelPreview;
     TMenuItem *N3;
     void __fastcall Action_ExitExecute(TObject *Sender);
     void __fastcall Action_AboutExecute(TObject *Sender);
     void __fastcall Action_OptionsExecute(TObject *Sender);
     void __fastcall Action_AddExecute(TObject *Sender);
     void __fastcall Action_RemoveExecute(TObject *Sender);
/*     void __fastcall LV_FilesCompare(TObject *Sender, TListItem *Item1,
          TListItem *Item2, int Data, int &Compare);
     void __fastcall LV_FilesColumnClick(TObject *Sender,
          TListColumn *Column);*/
     void __fastcall FormShow(TObject *Sender);
     void __fastcall LB_OperationsClick(TObject *Sender);
     void __fastcall RB_PositionClick(TObject *Sender);
     void __fastcall RB_AfterClick(TObject *Sender);
     void __fastcall RB_DelPositionClick(TObject *Sender);
     void __fastcall RB_DelAfterClick(TObject *Sender);
     void __fastcall Action_GoExecute(TObject *Sender);
     void __fastcall FormCreate(TObject *Sender);
     void __fastcall FormCloseQuery(TObject *Sender, bool &CanClose);
     void __fastcall Action_AddFolderExecute(TObject *Sender);
     void __fastcall Action_AddFolder2Execute(TObject *Sender);
     void __fastcall Action_RemoveAllExecute(TObject *Sender);
     void __fastcall Action_StopExecute(TObject *Sender);
     void __fastcall Action_ReplaceExecute(TObject *Sender);
     void __fastcall Action_InsertExecute(TObject *Sender);
     void __fastcall Action_DeleteExecute(TObject *Sender);
     void __fastcall CB_ReplAllOccurencesClick(TObject *Sender);
     void __fastcall CB_InsertAllOccurencesClick(TObject *Sender);
     void __fastcall Action_ChoseActionExecute(TObject *Sender);
     void __fastcall Action_RemoveDeadExecute(TObject *Sender);
     void __fastcall DropTargetDrop(TObject *Sender, TPoint &Pos,
          TStringList *Value);
        void __fastcall Action_UndoExecute(TObject *Sender);
     void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
     void __fastcall Action_PreviewExecute(TObject *Sender);
     void __fastcall Action_MoveUpExecute(TObject *Sender);
     void __fastcall Action_MoveDownExecute(TObject *Sender);
     void __fastcall Action_MoveTopExecute(TObject *Sender);
     void __fastcall LV_FilesMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
     void __fastcall Action_MoveBottomExecute(TObject *Sender);
     void __fastcall LV_FilesHeaderSectionClick(
          THeaderControl *HeaderControl, THeaderSection *Section);
private:
     void __fastcall ApplyOptions(void);
     void __fastcall SaveOptions(void);
     void __fastcall LoadOptions(void);
     void __fastcall AddError(int iErrorType, AnsiString strSource, AnsiString strDest);
     bool __fastcall MakeMP3Info(AnsiString strSource, AnsiString &strDest, bool bConvert);
     void __fastcall MakeDateTimeInfo(AnsiString strSource, AnsiString &strDest, bool bDupl);
     void __fastcall AddFolder(AnsiString strFolder, bool bSubfolders);
     void __fastcall AddFiles(TStrings *FilesList);
     void __fastcall AddFile(AnsiString FileName);
     void __fastcall ReplaceString(AnsiString strSource, AnsiString &strDest, bool bAllOccurences);
     void __fastcall InsertString(AnsiString strSource, AnsiString &strDest, int iPos, bool bAllOccurences);
     void __fastcall DeleteString(AnsiString strSource, AnsiString &strDest, int iPos);
     void __fastcall Enumeration(AnsiString strSource, AnsiString &strDest, int nDigits, bool bKeep);
     void __fastcall ChangeCase(AnsiString strSource, AnsiString &strDest);
     void __fastcall GetNewName(TRenFile *Source, AnsiString &strDest, int Operation);
     AnsiString __fastcall CreateNewExt();
     AnsiString __fastcall SelectFilename();
     void __fastcall ActiveComponents(bool bEnabled, int iPage);
     void __fastcall ChangeLanguage(AnsiString strFilename);
     bool Col0SortDesc;
     bool Col1SortDesc;
     unsigned long int iEnumPosition;
     bool ClosingProgram;
     bool ErrorOccured;
     bool bStopProcess;
     AnsiString strErrorOccured;
 //    AnsiString strError;
     AnsiString strErrorRenaming;
     AnsiString strErrorMP3TAG;
     AnsiString strError404;
     AnsiString strErrorRevert;
     AnsiString strComplete;
 //    AnsiString strInformation;
     AnsiString strSelectOper;
     AnsiString strSelectFiles;
     AnsiString strSelectFolder;
     AnsiString strStopped;
public:
     __fastcall TMainWin(TComponent* Owner);
};

void __fastcall TLMDLBCompareItemEvent(System::TObject *Sender, const AnsiString s1, const AnsiString s2, Shortint & result);

//---------------------------------------------------------------------------
extern PACKAGE TMainWin *MainWin;
//---------------------------------------------------------------------------
#endif
