/************************************************************************
 *                                                                      *
 *   Ant Renamer 1.x                                                    *
 *   (C) 2000-2002 Antoine Potten                                       *
 *   antoine@buypin.com - http://www.buypin.com                         *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************/

//---------------------------------------------------------------------------

#include <vcl.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#pragma hdrstop

#include "main.h"
#include "options.h"
#include "about.h"
#include "mp3TAG.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "BUDragDrop"
#pragma link "BUOpenDialog"
#pragma link "LMDCustomScrollBox"
#pragma link "LMDListBox"
#pragma link "BUDragDrop"
#pragma link "BUOpenDialog"
#pragma resource "*.dfm"

TMainWin *MainWin;

//---------------------------------------------------------------------------

void __fastcall TMainWin::ChangeLanguage(AnsiString strFilename)
{
     TIniFile *ini;
     ini = new TIniFile(ExtractFilePath(Application->ExeName)+strFilename+".lng");

     /* Messages */
     strErrorOccured=ini->ReadString("Messages","ErrorOccured","There was at least one error in renaming process");
   //  strError=ini->ReadString("Messages","Error","Error");
     strErrorRenaming=ini->ReadString("Messages","ErrorRenaming","Error while renaming %s to %s");
     strErrorMP3TAG=ini->ReadString("Messages","ErrorMP3TAG","Unable to find a valid MP3 ID info in %s");
     strError404=ini->ReadString("Messages","Error404","File not found : %s");
     strErrorRevert=ini->ReadString("Messages","ErrorRevert","Unable to revert to original filename for %s");
     strComplete=ini->ReadString("Messages","Complete","Renaming process complete");
  //   strInformation=ini->ReadString("Messages","Information","Information");
     strSelectOper=ini->ReadString("Messages","SelectOper","Please select an operation in the list");
     strSelectFiles=ini->ReadString("Messages","SelectFiles","Please add at least one file in the list");
     strSelectFolder=ini->ReadString("Messages","SelectFolder","Select the folder that contains the files you want to add");
     strStopped=ini->ReadString("Messages","Stopped","Process stoppped by user");

     /* Actions */
     Action_About->Caption=ini->ReadString("Actions","About","About");
     Action_About->Hint=ini->ReadString("Actions","About_Hint","About ...");
     Action_Add->Caption=ini->ReadString("Actions","Add","Add files");
     Action_Add->Hint=ini->ReadString("Actions","Add_Hint","Add files to the list ...");
     Action_AddFiles->Caption=Action_Add->Caption+" ...";
     Action_AddFolder->Caption=ini->ReadString("Actions","AddFolder","Add all files of a folder ...");
     Action_AddFolder2->Caption=ini->ReadString("Actions","AddFolder2","Add all files of a folder and subfolders ...");
     Action_Exit->Caption=ini->ReadString("Actions","Exit","Exit");
     Action_Exit->Hint=ini->ReadString("Actions","Exit_Hint","Quit program");
     Action_Go->Caption=ini->ReadString("Actions","Go","Process");
     Action_Go->Hint=ini->ReadString("Actions","Go_Hint","Start the renaming operation");
     Action_Options->Caption=ini->ReadString("Actions","Options","Options");
     Action_Options->Hint=ini->ReadString("Actions","Options_Hint","Options ...");
     Action_Remove->Caption=ini->ReadString("Actions","Remove","Remove files");
     Action_Remove->Hint=ini->ReadString("Actions","Remove","Remove selected files");
     Action_RemoveAll->Caption=ini->ReadString("Actions","RemoveAll","Remove all the files");
     Action_RemoveDead->Caption=ini->ReadString("Actions","RemoveDead","Remove dead files");
     Action_Stop->Caption=ini->ReadString("Actions","Stop","Stop");
     Action_Stop->Hint=ini->ReadString("Actions","Stop_Hint","Stop the renaming process");
     Action_Undo->Caption=ini->ReadString("Actions","Undo","Undo");
     Action_Undo->Hint=ini->ReadString("Actions","Undo_Hint","Revert names (only for files that are still in the list)");
     Action_Preview->Caption=ini->ReadString("Actions","Preview","Refresh");
     Action_MoveUp->Caption=ini->ReadString("Actions","MoveUp","Move Up");
     Action_MoveDown->Caption=ini->ReadString("Actions","MoveDown","Move Down");
     Action_MoveTop->Caption=ini->ReadString("Actions","MoveTop","Move at Top");
     Action_MoveBottom->Caption=ini->ReadString("Actions","MoveBottom","Move at Bottom");

     /* MainWindow */
     CB_DateSuffix->Caption=ini->ReadString("MainWindow","CB_DateSuffix","Add a numeric suffix if there is more than one file with the same date and");
     CB_DateSuffix2->Caption=ini->ReadString("MainWindow","CB_DateSuffix2","time information");
     CB_InsertAllOccurences->Caption=ini->ReadString("MainWindow","CB_InsertAllOccurences","After all occurences of the string");
     CB_KeepOldName->Caption=ini->ReadString("MainWindow","CB_KeepOldName","Add old file name after ending string");
     CB_ReplAllOccurences->Caption=ini->ReadString("MainWindow","CB_ReplAllOccurences","Replace all occurences");
     L_DateMask->Caption=ini->ReadString("MainWindow","L_DateMask","Mask :");
     L_DateNote->Caption=ini->ReadString("MainWindow","L_DateNote","Note :");
     L_DateSeparator->Caption=ini->ReadString("MainWindow","L_DateSeparator","Date separator :");
     L_TimeSeparator->Caption=ini->ReadString("MainWindow","L_TimeSeparator","Time separator :");
     L_Source->Caption=ini->ReadString("MainWindow","L_Source","String to replace :");
     L_Dest->Caption=ini->ReadString("MainWindow","L_Dest","Replace by :");
     L_Leading->Caption=ini->ReadString("MainWindow","L_Leading","Leading string :");
     L_Ending->Caption=ini->ReadString("MainWindow","L_Ending","Ending string :");
     L_Mask->Caption=ini->ReadString("MainWindow","L_Mask","Mask :");
     L_Note->Caption=ini->ReadString("MainWindow","L_Note","Note :");
     L_ID1->Caption=ini->ReadString("MainWindow","L_ID1","%1 = Artist");
     L_ID2->Caption=ini->ReadString("MainWindow","L_ID2","%2 = Title");
     L_ID3->Caption=ini->ReadString("MainWindow","L_ID3","%3 = Album");
     L_ID4->Caption=ini->ReadString("MainWindow","L_ID4","%4 = Year");
     L_ID5->Caption=ini->ReadString("MainWindow","L_ID5","%5 = Genre");
     L_ID6->Caption=ini->ReadString("MainWindow","L_ID6","%6 = Comment");
     L_ID7->Caption=ini->ReadString("MainWindow","L_ID7","%7 = Track number (only with ID3v1.1)");
     L_ID8->Caption=ini->ReadString("MainWindow","L_ID8","%8 = Original filename");
     L_Start->Caption=ini->ReadString("MainWindow","L_Start","Start at :");
     L_Increment->Caption=ini->ReadString("MainWindow","L_Increment","Increment by :");
     L_Insert->Caption=ini->ReadString("MainWindow","L_Insert","Insert :");
     L_NoteDel->Caption=ini->ReadString("MainWindow","L_NoteDel","Note : To delete a specified string, chose to replace the string by an empty one");
     L_NoteDel2->Caption=ini->ReadString("MainWindow","L_NoteDel2","");
     L_NoteExt->Caption=ini->ReadString("MainWindow","L_NoteExt","Note : Do not include the point, enter only the new extension");
     L_NumberDelete->Caption=ini->ReadString("MainWindow","L_NumberDelete","Number of characters to delete :");
     L_NumberDigits->Caption=ini->ReadString("MainWindow","L_NumberDigits","Number of digits :");
     L_Percent1->Caption=ini->ReadString("MainWindow","L_Percent1","A % sign followed by another character will remain unchanged");
     L_Percent2->Caption=ini->ReadString("MainWindow","L_Percent2","");
     RB_ExtRepl->Caption=ini->ReadString("MainWindow","L_ReplaceExt","Replace all the extensions by :");
     RB_ExtCreate->Caption=ini->ReadString("MainWindow","L_CreateExt","Create new extensions :");
     L_ExtStart->Caption=ini->ReadString("MainWindow","L_Start","Start at :");
     L_ExtIncr->Caption=ini->ReadString("MainWindow","L_Increment","Increment by :");
     LB_Operations->Items->Strings[0]=ini->ReadString("MainWindow","LB_Operations0","Change extension");
     LB_Operations->Items->Strings[1]=ini->ReadString("MainWindow","LB_Operations1","String replacement");
     LB_Operations->Items->Strings[2]=ini->ReadString("MainWindow","LB_Operations2","String insertion");
     LB_Operations->Items->Strings[3]=ini->ReadString("MainWindow","LB_Operations3","Characters deletion");
     LB_Operations->Items->Strings[4]=ini->ReadString("MainWindow","LB_Operations4","Enumeration");
     LB_Operations->Items->Strings[5]=ini->ReadString("MainWindow","LB_Operations5","Use mp3's ID");
     LB_Operations->Items->Strings[6]=ini->ReadString("MainWindow","LB_Operations6","Use date & time");
     LB_Operations->Items->Strings[7]=ini->ReadString("MainWindow","LB_Operations7","Random names");
     LB_Operations->Items->Strings[8]=ini->ReadString("MainWindow","LB_Operations8","Change case");
     LV_Files->Header->Sections->Items[0]->Text=ini->ReadString("MainWindow","LV_Files0","Folder");
     LV_Files->Header->Sections->Items[1]->Text=ini->ReadString("MainWindow","LV_Files1","Filename");
     LV_Preview->Header->Sections->Items[0]->Text=ini->ReadString("MainWindow","LV_Preview0","Old Name");
     LV_Preview->Header->Sections->Items[1]->Text=ini->ReadString("MainWindow","LV_Preview1","New Name");
     PanelPreview->Caption=ini->ReadString("MainWindow","PanelPreview","Press F5 or click with the right mouse button and select \"Refresh\"");
     OD_Select->Title=ini->ReadString("MainWindow","OD_Select","Select files to add to the list");
     RB_After->Caption=ini->ReadString("MainWindow","RB_After","After the string :");
     RB_Position->Caption=ini->ReadString("MainWindow","RB_Position","At position :");
     RB_DelAfter->Caption=ini->ReadString("MainWindow","RB_DelAfter","After the string :");
     RB_DelPosition->Caption=ini->ReadString("MainWindow","RB_DelPosition","From position :");
     TabSheetFiles->Caption=ini->ReadString("MainWindow","TabSheetFiles","Files");
     TabSheetOperation->Caption=ini->ReadString("MainWindow","TabSheetOperation","Operation");
     TabSheetPreview->Caption=ini->ReadString("MainWindow","TabSheetPreview","Preview");
     TabSheetErrors->Caption=ini->ReadString("MainWindow","TabSheetErrors","Errors");
     L_Random->Caption=ini->ReadString("MainWindow","L_Random","Random names are generated (8-digit numbers)");
     CB_ConvertSymbols->Caption=ini->ReadString("MainWindow","CB_ConvertSymbols","Convert unauthorized characters like : ? * / \\ < >  | \"");
     L_Case->Caption=ini->ReadString("MainWindow","L_Case","Case :");
     RB_LowerCase->Caption=ini->ReadString("MainWindow","RB_Lower","Lower");
     RB_UpperCase->Caption=ini->ReadString("MainWindow","RB_Upper","Upper");
     RB_EachWord->Caption=ini->ReadString("MainWindow","RB_EachWord","Upper for first letter of each word (after a space or a dot)");
     RB_FirstLetter->Caption=ini->ReadString("MainWindow","RB_FirstLetter","Upper for first letter of the file name");
     CB_FirstFollowing->Caption=ini->ReadString("MainWindow","CB_FirstFollowing","Also first letter following :");
     CB_AppendExt->Caption=ini->ReadString("MainWindow","CB_AppendExt","Only append extension to file, do not replace original extension");

     OptionsWin->ChangeLanguage(ini);
     AboutWin->ChangeLanguage(ini);

     delete ini;

     L_DateMasks->Lines->LoadFromFile(ExtractFilePath(Application->ExeName)+strFilename+".txt");
}

void __fastcall TMainWin::ActiveComponents(bool bEnabled, int iPage)
{
     PageControl->ActivePageIndex=iPage;
     PageControl->Enabled=bEnabled;
     Action_Add->Enabled=bEnabled;
     Action_AddFolder->Enabled=bEnabled;
     Action_AddFolder2->Enabled=bEnabled;
     Action_Remove->Enabled=bEnabled;
     Action_RemoveAll->Enabled=bEnabled;
     Action_RemoveDead->Enabled=bEnabled;
     Action_Undo->Enabled=bEnabled;
     DropTarget->AcceptDrag=bEnabled;
}

AnsiString __fastcall TMainWin::SelectFilename()
{
     /* Returns the name of the select file, or if nothing selected the name
        of the first file, or if no file found an empty string */
     if(LV_Files->Items->Count==0) return "";
     int i=LV_Files->ItemIndex;
     if(i < 0) i = 0;
     return ((TRenFile *)LV_Files->Items->Objects[i])->FileName();
}

//---------------------------------------------------------------------------

void __fastcall TMainWin::LoadOptions(void)
{
     TIniFile *ini;
     ini = new TIniFile(ChangeFileExt(Application->ExeName,".ini"));

     RB_ExtRepl->Checked=ini->ReadBool("Fields","RB_ExtRepl",1);
     RB_ExtCreate->Checked=ini->ReadBool("Fields","RB_ExtCreate",0);
     CB_AppendExt->Checked=ini->ReadBool("Fields","CB_AppendExt",0);
     E_ExtStart->Value=ini->ReadInteger("Fields","E_ExtStart",0);
     E_ExtIncr->Value=ini->ReadInteger("Fields","E_ExtIncr",1);
     E_NewExt->Text=ini->ReadString("Fields","E_NewExt","");

     E_Source->Text=ini->ReadString("Fields","E_Source","");
     E_Dest->Text=ini->ReadString("Fields","E_Dest","");
     CB_ReplAllOccurences->Checked=ini->ReadBool("Fields","CB_ReplAllOccurences",0);

     E_Insert->Text=ini->ReadString("Fields","E_Insert","");
     E_After->Text=ini->ReadString("Fields","E_After","");
     RB_Position->Checked=ini->ReadBool("Fields","RB_Position",1);
     RB_After->Checked=ini->ReadBool("Fields","RB_After",0);
     E_Position->Value=ini->ReadInteger("Fields","E_Position",0);

     E_NumberDel->Value=ini->ReadInteger("Fields","E_NumberDel",1);
     E_DelPosition->Value=ini->ReadInteger("Fields","E_DelPosition",0);
     RB_DelPosition->Checked=ini->ReadBool("Fields","RB_DelPosition",1);
     RB_DelAfter->Checked=ini->ReadBool("Fields","RB_DelAfter",0);
     E_DelAfter->Text=ini->ReadString("Fields","E_DelAfter","");

     E_Leading->Text=ini->ReadString("Fields","E_Leading","");
     E_Ending->Text=ini->ReadString("Fields","E_Ending","");
     E_EnumStart->Value=ini->ReadInteger("Fields","E_EnumStart",0);
     E_EnumDigits->Value=ini->ReadInteger("Fields","E_EnumDigits",1);
     E_EnumIncr->Value=ini->ReadInteger("Fields","E_EnumIncr",1);
     CB_KeepOldName->Checked=ini->ReadBool("Fields","CB_KeepOldName",0);

     E_Mask->Text=ini->ReadString("Fields","E_Mask","%1 - %2");
     CB_ConvertSymbols->Checked=ini->ReadBool("Fields","CB_ConvertSymbols",1);

     E_DateMask->Text=ini->ReadString("Fields","E_DateMask","yyyymmdd hhnnss");
     E_DateSeparator->Text=ini->ReadString("Fields","E_DateSeparator","-");
     E_TimeSeparator->Text=ini->ReadString("Fields","E_TimeSeparator",".");
     CB_DateSuffix->Checked=ini->ReadBool("Fields","CB_DateSuffix",0);

     RB_EachWord->Checked=ini->ReadBool("Fields","RB_EachWord",1);
     RB_FirstLetter->Checked=ini->ReadBool("Fields","RB_FirstLetter",0);
     CB_FirstFollowing->Checked=ini->ReadBool("Fields","CB_FirstFollowing",0);
     RB_LowerCase->Checked=ini->ReadBool("Fields","RB_LowerCase",0);
     RB_UpperCase->Checked=ini->ReadBool("Fields","RB_UpperCase",0);
     E_FirstFollowing->Text=ini->ReadString("Fields","E_FirstFollowing"," - ");

     if(ini->ReadBool("MainWin","Maximized",false)==true) WindowState=wsMaximized;
     else {
          Width=ini->ReadInteger("MainWin","Width",600);
          Height=ini->ReadInteger("MainWin","Height",450);
     }

     LV_Files->Header->Sections->Items[0]->Width = ini->ReadInteger("MainWin","LV_Files_Col0",200);
     LV_Files->Header->Sections->Items[1]->Width = ini->ReadInteger("MainWin","LV_Files_Col1",300);
     LV_Preview->Header->Sections->Items[0]->Width = ini->ReadInteger("MainWin","LV_Preview_Col0",200);
     LV_Preview->Header->Sections->Items[1]->Width = ini->ReadInteger("MainWin","LV_Preview_Col1",200);

     delete ini;
}

//---------------------------------------------------------------------------

void __fastcall TMainWin::SaveOptions(void)
{
     TIniFile *ini;
     ini = new TIniFile(ChangeFileExt(Application->ExeName,".ini"));

     if(WindowState==wsMaximized) ini->WriteBool("MainWin","Maximized",true);
     else {
          ini->WriteBool("MainWin","Maximized",false);
          ini->WriteInteger("MainWin","Width",Width);
          ini->WriteInteger("MainWin","Height",Height);
     }

     ini->WriteInteger("MainWin","LV_Files_Col0",LV_Files->Header->Sections->Items[0]->Width);
     ini->WriteInteger("MainWin","LV_Files_Col1",LV_Files->Header->Sections->Items[1]->Width);
     ini->WriteInteger("MainWin","LV_Preview_Col0",LV_Preview->Header->Sections->Items[0]->Width);
     ini->WriteInteger("MainWin","LV_Preview_Col1",LV_Preview->Header->Sections->Items[1]->Width);

     ini->WriteBool("Fields","RB_ExtRepl",RB_ExtRepl->Checked);
     ini->WriteBool("Fields","RB_ExtCreate",RB_ExtCreate->Checked);
     ini->WriteBool("Fields","CB_AppendExt",CB_AppendExt->Checked);
     ini->WriteInteger("Fields","E_ExtStart",E_ExtStart->Value);
     ini->WriteInteger("Fields","E_ExtIncr",E_ExtIncr->Value);
     ini->WriteString("Fields","E_NewExt",E_NewExt->Text);

     ini->WriteString("Fields","E_Source",E_Source->Text);
     ini->WriteString("Fields","E_Dest",E_Dest->Text);
     ini->WriteBool("Fields","CB_ReplAllOccurences",CB_ReplAllOccurences->Checked);

     ini->WriteInteger("Fields","E_Position",E_Position->Value);
     ini->WriteBool("Fields","RB_Position",RB_Position->Checked);
     ini->WriteBool("Fields","RB_After",RB_After->Checked);
     ini->WriteString("Fields","E_After",E_After->Text);
     ini->WriteString("Fields","E_Insert",E_Insert->Text);

     ini->WriteInteger("Fields","E_NumberDel",E_NumberDel->Value);
     ini->WriteInteger("Fields","E_DelPosition",E_DelPosition->Value);
     ini->WriteBool("Fields","RB_DelPosition",RB_DelPosition->Checked);
     ini->WriteBool("Fields","RB_DelAfter",RB_DelAfter->Checked);
     ini->WriteString("Fields","E_DelAfter",E_DelAfter->Text);

     ini->WriteString("Fields","E_Leading",E_Leading->Text);
     ini->WriteString("Fields","E_Ending",E_Ending->Text);
     ini->WriteInteger("Fields","E_EnumStart",E_EnumStart->Value);
     ini->WriteInteger("Fields","E_EnumDigits",E_EnumDigits->Value);
     ini->WriteInteger("Fields","E_EnumIncr",E_EnumIncr->Value);
     ini->WriteBool("Fields","CB_KeepOldName",CB_KeepOldName->Checked);

     ini->WriteString("Fields","E_Mask",E_Mask->Text);
     ini->WriteBool("Fields","CB_ConvertSymbols",CB_ConvertSymbols->Checked);

     ini->WriteString("Fields","E_DateMask",E_DateMask->Text);
     ini->WriteString("Fields","E_DateSeparator",E_DateSeparator->Text);
     ini->WriteString("Fields","E_TimeSeparator",E_TimeSeparator->Text);
     ini->WriteBool("Fields","CB_DateSuffix",CB_DateSuffix->Checked);

     ini->WriteBool("Fields","RB_EachWord",RB_EachWord->Checked);
     ini->WriteBool("Fields","RB_FirstLetter",RB_FirstLetter->Checked);
     ini->WriteBool("Fields","CB_FirstFollowing",CB_FirstFollowing->Checked);
     ini->WriteBool("Fields","RB_LowerCase",RB_LowerCase->Checked);
     ini->WriteBool("Fields","RB_UpperCase",RB_UpperCase->Checked);
     ini->WriteString("Fields","E_FirstFollowing",E_FirstFollowing->Text);

     delete ini;
}

//---------------------------------------------------------------------------

void __fastcall TMainWin::ApplyOptions(void)
{
     /* Updates MainWin components with options set in OptionsWin */
     if(OptionsWin->CB_AlwaysColor->Checked==true)
          Toolbar->Images=IL_Toolbar;
     else Toolbar->Images=IL_Toolbar_Grey;
//     Toolbar->ShowHint=!OptionsWin->CB_Labels->Checked;
     Toolbar->ShowCaptions=OptionsWin->CB_Labels->Checked;
     Toolbar->Flat=OptionsWin->CB_FlatButtons->Checked;
     Toolbar->ButtonHeight=0;
     Toolbar->ButtonWidth=0;
}

//---------------------------------------------------------------------------

void __fastcall TMainWin::AddError(int iErrorType, AnsiString strSource, AnsiString strDest)
{
     /* Prints an error in the "Errors" page (log) */
     AnsiString ErrorMessage;
     switch(iErrorType) {
          case ERROR_RENAME :
               ErrorMessage.sprintf(strErrorRenaming.c_str(),strSource.c_str(),strDest.c_str());
               break;
          case ERROR_MP3TAG :
               ErrorMessage.sprintf(strErrorMP3TAG.c_str(),strSource.c_str());
               break;
          case ERROR_404    :
               ErrorMessage.sprintf(strError404.c_str(),strSource.c_str());
               break;
          case ERROR_REVERT :
               ErrorMessage.sprintf(strErrorRevert.c_str(),strSource.c_str());
     }
     E_Log->Lines->Add(ErrorMessage);
     ErrorOccured=true;
}

//---------------------------------------------------------------------------

AnsiString __fastcall TMainWin::CreateNewExt()
{
     AnsiString strNumber;
     strNumber.sprintf(".%3.3i",iEnumPosition);
     return strNumber;
}

void __fastcall TMainWin::ChangeCase(AnsiString strSource, AnsiString &strDest)
{
     if(RB_UpperCase->Checked==true) {
          strDest=strSource.UpperCase();
          return;
     }
     strDest=strSource.LowerCase();
     if(RB_LowerCase->Checked==true) {
          return;
     }
     char szDest[256];
     strcpy(szDest,(ChangeFileExt(strDest,"")).c_str());
     char *pChar=szDest;
     for(bool bFound=false;bFound==false&&*pChar;pChar++) {
          // set the first letter in uppercase
          if((*pChar)>='a'&&(*pChar)<='z') {
               (*pChar)+='A'-'a';
               bFound=true;
          }
     }
     if(RB_EachWord->Checked==true) {
          pChar=strchr(szDest,' ');
          while(pChar!=NULL) {
               if((*(pChar+1))>='a'&&(*(pChar+1))<='z') (*(pChar+1))+='A'-'a';
               pChar=strchr(pChar+1,' ');
          }
          pChar=strchr(szDest,'.');
          while(pChar!=NULL) {
               if((*(pChar+1))>='a'&&(*(pChar+1))<='z') (*(pChar+1))+='A'-'a';
               pChar=strchr(pChar+1,'.');
          }
     } else if(CB_FirstFollowing->Checked==true) {
          int iLength=E_FirstFollowing->Text.Length();
          pChar=strstr(szDest,E_FirstFollowing->Text.c_str());
          while(pChar!=NULL) {
               if((*(pChar+iLength))>='a'&&(*(pChar+iLength))<='z') (*(pChar+iLength))+='A'-'a';
               pChar=strstr(pChar+iLength,E_FirstFollowing->Text.c_str());
          }
     }
     strDest=szDest+(ExtractFileExt(strSource)).LowerCase();
}

void __fastcall TMainWin::Enumeration(AnsiString strSource, AnsiString &strDest, int nDigits, bool bKeep)
{
     char szNumber[256], szFormat[32];
     sprintf(szFormat,"%%0%i.%ili",nDigits,nDigits);
     sprintf(szNumber,szFormat,iEnumPosition);
     strDest=(E_Leading->Text)+szNumber+(E_Ending->Text);
     if(bKeep==true) {
          strDest+=strSource;
     } else {
          strDest+=ExtractFileExt(strSource);
     }
}

//---------------------------------------------------------------------------

void __fastcall TMainWin::ReplaceString(AnsiString strSource, AnsiString &strDest, bool bAllOccurences)
{
     /* Creates a new file name with a string replaced by another */
     strDest=ChangeFileExt(strSource,"");
     if(bAllOccurences==true)
          strDest=StringReplace(strDest,E_Source->Text,E_Dest->Text,TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
     else strDest=StringReplace(strDest,E_Source->Text,E_Dest->Text,TReplaceFlags()<<rfIgnoreCase);
     strDest+=ExtractFileExt(strSource);
}

//---------------------------------------------------------------------------

void __fastcall TMainWin::InsertString(AnsiString strSource, AnsiString &strDest, int iPos, bool bAllOccurences)
{
     /* Creates a new file name and inserts a string in it */
     strDest=ChangeFileExt(strSource,"");
     if(iPos!=-1) {
          strDest.Insert(E_Insert->Text,iPos+1);
     }
     else {
          if(bAllOccurences==true)
               strDest=StringReplace(strDest,E_After->Text,(E_After->Text)+(E_Insert->Text),TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
          else strDest=StringReplace(strDest,E_After->Text,(E_After->Text)+(E_Insert->Text),TReplaceFlags()<<rfIgnoreCase);
     }
     strDest+=ExtractFileExt(strSource);
}

//---------------------------------------------------------------------------

void __fastcall TMainWin::DeleteString(AnsiString strSource, AnsiString &strDest, int iPos)
{
     /* Creates a new file name and deletes character(s) in the string */
     strDest=ChangeFileExt(strSource,"");
     if(iPos!=-1) {
          strDest.Delete(E_DelPosition->Value+1,E_NumberDel->Value);
     }
     else {
          if(strDest.Pos(E_DelAfter->Text)>0) {
               strDest.Delete(strDest.Pos(E_DelAfter->Text)+(E_DelAfter->Text.Length()),E_NumberDel->Value);
          }
     }
     strDest+=ExtractFileExt(strSource);
}

//---------------------------------------------------------------------------

bool __fastcall TMainWin::MakeMP3Info(AnsiString strSource, AnsiString &strDest, bool bConvert)
{
     /* Extracts mp3 TAG info (ID) and replaces masks in the string to create
        the file name */
     TMP3TAG mp3TAG;
     TMP3TAG2 mp3TAG2;

     memset((void *)&mp3TAG,0,sizeof(mp3TAG));
     memset((void *)&mp3TAG2,0,sizeof(mp3TAG2));

     bool result = false;

     try {
          TFileStream  *fMP3 = new TFileStream(strSource,fmOpenRead);
          if(fMP3==NULL) return result;
          fMP3->Seek(-128,soFromEnd);
          if(fMP3->Read((void *)&mp3TAG,sizeof(mp3TAG))<sizeof(mp3TAG)) {
               delete fMP3;
               return result;
          }
          delete fMP3;
          if(strncmp(mp3TAG.TAG,"TAG",3)) return result;

          memcpy(mp3TAG2.Title,mp3TAG.Title,sizeof(mp3TAG.Title));
          memcpy(mp3TAG2.Author,mp3TAG.Author,sizeof(mp3TAG.Author));
          memcpy(mp3TAG2.Album,mp3TAG.Album,sizeof(mp3TAG.Album));
          memcpy(mp3TAG2.Year,mp3TAG.Year,sizeof(mp3TAG.Year));
          memcpy(mp3TAG2.Comment,mp3TAG.Comment,sizeof(mp3TAG.Comment));

          strDest=E_Mask->Text;
          strDest=StringReplace(strDest,"%1",Trim(mp3TAG2.Author),TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
          strDest=StringReplace(strDest,"%2",Trim(mp3TAG2.Title),TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
          strDest=StringReplace(strDest,"%3",Trim(mp3TAG2.Album),TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
          strDest=StringReplace(strDest,"%4",Trim(mp3TAG2.Year),TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
          strDest=StringReplace(strDest,"%5",TMP3Genres[mp3TAG.Genre],TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
          strDest=StringReplace(strDest,"%6",Trim(mp3TAG2.Comment),TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
          strDest=StringReplace(strDest,"%7",(AnsiString)((int)((unsigned char)mp3TAG.Comment[sizeof(mp3TAG.Comment)-1])),TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
          strDest=StringReplace(strDest,"%8",ExtractFileName(ChangeFileExt(strSource,"")),TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);

          if(bConvert==true) {
               strDest=StringReplace(strDest,"\"","'",TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
               strDest=StringReplace(strDest,"\\","-",TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
               strDest=StringReplace(strDest,":","-",TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
               strDest=StringReplace(strDest,"/","-",TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
               strDest=StringReplace(strDest,"*","-",TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
               strDest=StringReplace(strDest,"<","-",TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
               strDest=StringReplace(strDest,">","-",TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
               strDest=StringReplace(strDest,"|","-",TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
               strDest=StringReplace(strDest,"","-",TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
               strDest=StringReplace(strDest," ?","",TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
               strDest=StringReplace(strDest,"?","",TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
          }

          strDest+=ExtractFileExt(strSource);
          result = true;
     } catch (...) {
          strDest="";
     }
     return result;
}

//---------------------------------------------------------------------------

void __fastcall TMainWin::MakeDateTimeInfo(AnsiString strSource, AnsiString &strDest, bool bDupl)
{
     strDest=StringReplace(FormatDateTime(E_DateMask->Text,FileDateToDateTime(FileAge(strSource))),"f",ExtractFileName(ChangeFileExt(strSource,"")),TReplaceFlags()<<rfIgnoreCase<<rfReplaceAll);
     if(bDupl==true&&FileExists(strDest+ExtractFileExt(strSource))) {
          int i;
          for(i=1;FileExists(strDest+" ("+IntToStr(i)+")"+ExtractFileExt(strSource));i++);
          strDest+=" ("+IntToStr(i)+")";
     }
     strDest+=ExtractFileExt(strSource);
}

//---------------------------------------------------------------------------
__fastcall TMainWin::TMainWin(TComponent* Owner)
     : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainWin::Action_ExitExecute(TObject *Sender)
{
     Close();
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::Action_AboutExecute(TObject *Sender)
{
     /* Shows the about box */
     AboutWin->ShowModal();
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::Action_OptionsExecute(TObject *Sender)
{
     /* Shows the options window */
     int iLanguage=OptionsWin->C_Language->ItemIndex;
     if(OptionsWin->ShowModal()==ID_OK) {
          ApplyOptions();
          if(iLanguage!=OptionsWin->C_Language->ItemIndex) {
               ChangeLanguage(OptionsWin->C_Language->Items->Strings[OptionsWin->C_Language->ItemIndex]);
          }
     }
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::Action_AddExecute(TObject *Sender)
{
     /* Adds files in the list with a standard "open file" dialog */
     if(OD_Select->Execute()==true) {
          PageControl->ActivePageIndex=TABSHEET_FILES;
          AddFiles(OD_Select->Files);
     }
}
//---------------------------------------------------------------------------
void __fastcall TMainWin::AddFolder(AnsiString strFolder, bool bSubfolders)
{
     /* Adds all the files of a folder. If bSubfolders is true, it adds
        recursively the files of the subfolders */
     TSearchRec SearchRecord;
     int RemaindFiles;

     /* If it is a root folder, there is already a '\' */
     if(*(strFolder.AnsiLastChar())!='\\') strFolder+='\\';

     /* Files */
     SetCurrentDir(strFolder);
     for(RemaindFiles=FindFirst("*.*",faAnyFile,SearchRecord);
               RemaindFiles==0;RemaindFiles=FindNext(SearchRecord)) {
          Application->ProcessMessages();
          if(!DirectoryExists(SearchRecord.Name)) {
               AddFile(strFolder+SearchRecord.Name);
          }
     }
     FindClose(SearchRecord);

     /* Folders */
     if(bSubfolders==true) {
          SetCurrentDir(strFolder);
          for(RemaindFiles=FindFirst("*.*",faDirectory,SearchRecord);
                    RemaindFiles==0;RemaindFiles=FindNext(SearchRecord)) {
               Application->ProcessMessages();
               if(SearchRecord.Name!="."&&SearchRecord.Name!=".."&&DirectoryExists(SearchRecord.Name)) {
                    AddFolder(strFolder+SearchRecord.Name,true);
                    SetCurrentDir(strFolder);
               }
          }
     }
     FindClose(SearchRecord);
}
//---------------------------------------------------------------------------
void __fastcall TMainWin::Action_AddFolderExecute(TObject *Sender)
{
     /* Selects a folder for adding files */
     AnsiString strFolder;
     if(SelectDirectory(strSelectFolder,"",strFolder)) {
          PageControl->ActivePageIndex=TABSHEET_FILES;
          AddFolder(strFolder, false);
     }
}
//---------------------------------------------------------------------------
void __fastcall TMainWin::Action_AddFolder2Execute(TObject *Sender)
{
     /* Selects a folder for adding files (with subfolders search) */
     AnsiString strFolder;
     if(SelectDirectory(strSelectFolder,"",strFolder)) {
          PageControl->ActivePageIndex=TABSHEET_FILES;
          AddFolder(strFolder, true);
     }
}
//---------------------------------------------------------------------------
void __fastcall TMainWin::Action_RemoveExecute(TObject *Sender)
{
     /* Removes select file(s) */
     for(int i = LV_Files->Items->Count-1; i >= 0; i--) {
          if(LV_Files->Selected[i]) {
               delete LV_Files->Items->Objects[i];
               LV_Files->Items->Delete(i);
          }
     }
}
//---------------------------------------------------------------------------
void __fastcall TMainWin::FormShow(TObject *Sender)
{
     for(int i=0;i<OperationPages->PageCount;i++) OperationPages->Pages[i]->TabVisible=false;
     LoadOptions();
     ApplyOptions();
     L_DateMasks->Lines->SaveToFile(ExtractFilePath(Application->ExeName)+"[default].txt");
     ChangeLanguage(OptionsWin->C_Language->Items->Strings[OptionsWin->C_Language->ItemIndex]);
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::LB_OperationsClick(TObject *Sender)
{
     /* Changes the page when the user choses an operation in the list */
     OperationPages->ActivePageIndex=LB_Operations->ItemIndex+1;
     Action_ChoseAction->Execute();
}
//---------------------------------------------------------------------------



void __fastcall TMainWin::RB_PositionClick(TObject *Sender)
{
     Action_Insert->Execute();
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::RB_AfterClick(TObject *Sender)
{
     Action_Insert->Execute();
}
//---------------------------------------------------------------------------


void __fastcall TMainWin::RB_DelPositionClick(TObject *Sender)
{
     Action_Delete->Execute();
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::RB_DelAfterClick(TObject *Sender)
{
     Action_Delete->Execute();
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::Action_GoExecute(TObject *Sender)
{
     /* Starts the renaming process */
     TRenFile *Source;
     AnsiString strDest;
     if(LV_Files->Items->Count<1) {
          MessageDlg(strSelectFiles,mtInformation,TMsgDlgButtons() << mbOK, 0);
          ActiveComponents(true, TABSHEET_FILES);
          return;
     }
     if(LB_Operations->ItemIndex==-1) {
          MessageDlg(strSelectOper,mtInformation,TMsgDlgButtons() << mbOK, 0);
          ActiveComponents(true, TABSHEET_OPERATION);
          return;
     }
     ErrorOccured=false;
     bStopProcess=false;
     E_Log->Clear();
     ProgressBar->MaxValue=LV_Files->Items->Count;
     TBB_Process->Action=Action_Stop;
     ActiveComponents(false,TABSHEET_FILES);

     switch(LB_Operations->ItemIndex) {
          case ENUMERATION :
               iEnumPosition=E_EnumStart->Value;
               break;
          case CHANGE_EXT :
               iEnumPosition=E_ExtStart->Value;
               break;
          case DATETIME :
               DateSeparator = E_DateSeparator->Text[1];
               TimeSeparator = E_TimeSeparator->Text[1];
               break;
     }

     /* Rename all the files of the list */
     for(int i=0;i<LV_Files->Items->Count&&bStopProcess==false;i++) {
          Source=(TRenFile *)LV_Files->Items->Objects[i];
          if(!FileExists(Source->FilePath())) {
               /* If a file has been deleted after it was added in the list, it should not
                  be processed */
               AddError(ERROR_404,Source->FilePath(),"");
               continue;
          }

          GetNewName(Source, strDest, LB_Operations->ItemIndex);
               // create the string containing the new file name

          if(!Source->Rename(strDest)) AddError(ERROR_RENAME,Source->FilePath(),strDest);
          else {
               /* If the file was successfully renamed, updates the list */
               LV_Files->Items->Strings[i] = Source->FormatedFilePath();
               switch(LB_Operations->ItemIndex) {
                    case ENUMERATION :
                         iEnumPosition+=E_EnumIncr->Value;
                         break;
                    case CHANGE_EXT :
                         iEnumPosition+=E_ExtIncr->Value;
                         break;
               }
          }
          ProgressBar->Progress++;
          Application->ProcessMessages();
     }
     if(ErrorOccured==true) {
          MessageDlg(strErrorOccured, mtError, TMsgDlgButtons() << mbOK, 0);
          ActiveComponents(true,TABSHEET_ERRORS);
     }
     else {
          if(bStopProcess==true) {
               MessageDlg(strStopped, mtInformation, TMsgDlgButtons() << mbOK, 0);
          } else {
               MessageDlg(strComplete, mtInformation, TMsgDlgButtons() << mbOK, 0);
               if(OptionsWin->CB_ClearList->Checked==true) Action_RemoveAll->Execute();
          }
          ActiveComponents(true,TABSHEET_FILES);
     }
     ProgressBar->Progress=0;
     TBB_Process->Action=Action_Go;
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::GetNewName(TRenFile *Source, AnsiString &strDest, int Operation)
{
     AnsiString strOldExt="";
     switch(Operation) {
          case CHANGE_EXT :
               if(CB_AppendExt->Checked==true) {
                    strOldExt = Source->FileExt();
               }
               if(RB_ExtCreate->Checked==true) {
                    strDest=ChangeFileExt(Source->FileName(),strOldExt+CreateNewExt());
               } else {
                    strDest=ChangeFileExt(Source->FileName(),strOldExt+'.'+(E_NewExt->Text));
               }
               if(strDest[strDest.Length()]=='.') {
                    strDest.Delete(strDest.Length(),1);
               }
               break;
          case STR_REPL   :
               ReplaceString(Source->FileName(),strDest,CB_ReplAllOccurences->Checked);
               break;
          case STR_INSERT :
               InsertString(Source->FileName(),strDest,RB_Position->Checked?E_Position->Value:-1,CB_InsertAllOccurences->Checked);
               break;
          case CHAR_DEL   :
               DeleteString(Source->FileName(),strDest,RB_DelPosition->Checked?E_DelPosition->Value:-1);
               break;
          case ENUMERATION:
               Enumeration(Source->FileName(),strDest,E_EnumDigits->Value,CB_KeepOldName->Checked);
               break;
          case MP3ID      :
               if(!MakeMP3Info(Source->FilePath(),strDest,CB_ConvertSymbols->Checked)) {
                    AddError(ERROR_MP3TAG,Source->FilePath(),strDest);
                    strDest="";
               }
               break;
          case DATETIME   :
               MakeDateTimeInfo(Source->FilePath(),strDest,CB_DateSuffix->Checked);
               break;
          case RANDOMNAMES:
               Randomize();
               do {
                    strDest=AnsiString(random(89999999)+10000000)+Source->FileExt();
               }
               while(FileExists(Source->FileFolder()+strDest));
               break;
          case CHANGECASE:
               ChangeCase(Source->FileName(),strDest);
     }
}

void __fastcall TMainWin::FormCreate(TObject *Sender)
{
     Col0SortDesc = true;
     Col1SortDesc = true;
     LV_Files->OnSSCompareItem = ::TLMDLBCompareItemEvent;
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::FormCloseQuery(TObject *Sender, bool &CanClose)
{
     SaveOptions();
     DeleteFile(ExtractFilePath(Application->ExeName)+"[default].txt");
     CanClose=true;
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::Action_RemoveAllExecute(TObject *Sender)
{
     /* Clears the list */
     for(int i = LV_Files->Items->Count-1; i >= 0; i--) {
          delete LV_Files->Items->Objects[i];
          LV_Files->Items->Delete(i);
     }
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::Action_RemoveDeadExecute(TObject *Sender)
{
     /* Removes from the list all the files that are not found on the disk */
     for(int i = LV_Files->Items->Count-1; i >= 0; i--) {
          if(!FileExists(((TRenFile *)LV_Files->Items->Objects[i])->FilePath())) {
               delete LV_Files->Items->Objects[i];
               LV_Files->Items->Delete(i);
          }
     }
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::Action_StopExecute(TObject *Sender)
{
     bStopProcess=true;
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::Action_UndoExecute(TObject *Sender)
{
     if(LV_Files->Items->Count<1) {
          MessageDlg(strSelectFiles,mtInformation,TMsgDlgButtons() << mbOK, 0);
          return;
     }
     TRenFile *Source;
     ErrorOccured=false;
     bStopProcess=false;
     E_Log->Clear();
     ProgressBar->MaxValue=LV_Files->Items->Count;
     TBB_Process->Action=Action_Stop;
     ActiveComponents(false,TABSHEET_FILES);

     for(int i=0;i<LV_Files->Items->Count&&bStopProcess==false;i++) {
          Source = (TRenFile *)LV_Files->Items->Objects[i];
          if(!Source->Revert()) AddError(ERROR_REVERT,Source->FilePath(),"");
          else {
               /* If the file was successfully renamed, updates the list */
               LV_Files->Items->Strings[i] = Source->FormatedFilePath();
          }
          ProgressBar->Progress++;
          Application->ProcessMessages();
     }

     if(ErrorOccured==true) {
          MessageDlg(strErrorOccured, mtError, TMsgDlgButtons() << mbOK, 0);
          ActiveComponents(true,TABSHEET_ERRORS);
     }
     else {
          if(bStopProcess==true) {
               MessageDlg(strStopped, mtInformation, TMsgDlgButtons() << mbOK, 0);
          } else {
               MessageDlg(strComplete, mtInformation, TMsgDlgButtons() << mbOK, 0);
               if(OptionsWin->CB_ClearList->Checked==true) Action_RemoveAll->Execute();
          }
          ActiveComponents(true,TABSHEET_FILES);
     }
     ProgressBar->Progress=0;
     TBB_Process->Action=Action_Go;
}

//---------------------------------------------------------------------------

void __fastcall TMainWin::Action_ReplaceExecute(TObject *Sender)
{
     /* Updates the example */
     AnsiString strSource=SelectFilename(), strDest;
     if(LV_Files->Items->Count) ReplaceString(strSource,strDest,CB_ReplAllOccurences->Checked);
     L_Ex_ReplSource->Caption=strSource;
     L_Ex_ReplDest->Caption=strDest;
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::Action_InsertExecute(TObject *Sender)
{
     /* Updates the example */
     AnsiString strSource=SelectFilename(), strDest;
     if(LV_Files->Items->Count) InsertString(strSource,strDest,RB_Position->Checked?E_Position->Value:-1,CB_InsertAllOccurences->Checked);
     L_Ex_InsertSource->Caption=strSource;
     L_Ex_InsertDest->Caption=strDest;
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::Action_DeleteExecute(TObject *Sender)
{
     /* Updates the example */
     AnsiString strSource=SelectFilename(), strDest;
     if(LV_Files->Items->Count) DeleteString(strSource,strDest,RB_DelPosition->Checked?E_DelPosition->Value:-1);
     L_Ex_DelSource->Caption=strSource;
     L_Ex_DelDest->Caption=strDest;
}
//---------------------------------------------------------------------------


void __fastcall TMainWin::CB_ReplAllOccurencesClick(TObject *Sender)
{
     Action_Replace->Execute();
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::CB_InsertAllOccurencesClick(TObject *Sender)
{
     Action_Insert->Execute();
}
//---------------------------------------------------------------------------


void __fastcall TMainWin::Action_ChoseActionExecute(TObject *Sender)
{
     /* Updates the example in the right page */
     switch(LB_Operations->ItemIndex) {
          case STR_REPL   :
               Action_Replace->Execute();
               break;
          case STR_INSERT :
               Action_Insert->Execute();
               break;
          case CHAR_DEL   :
               Action_Delete->Execute();
               break;
     }
}
//---------------------------------------------------------------------------



void __fastcall TMainWin::DropTargetDrop(TObject *Sender, TPoint &Pos,
      TStringList *Value)
{
     PageControl->ActivePageIndex=TABSHEET_FILES;
     AddFiles(Value);
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::AddFiles(TStrings *FilesList)
{
     for(int i=0;i<FilesList->Count;i++) {
          if(DirectoryExists(FilesList->Strings[i])) {
               AddFolder(FilesList->Strings[i], true);
          } else {
               AddFile(FilesList->Strings[i]);
          }
     }
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::AddFile(AnsiString FileName)
{
     TRenFile *NewFile;
     NewFile = new TRenFile(FileName);
     LV_Files->Items->AddObject(NewFile->FormatedFilePath(), NewFile);
}



//---------------------------------------------------------------------------
/*
void __fastcall TMainWin::LV_FilesCompare(TObject *Sender,
      TListItem *Item1, TListItem *Item2, int Data, int &Compare)
{
     if (ColumnToSort == 0)
          Compare = CompareText(Item1->Caption,Item2->Caption);
     else
          Compare = CompareText(Item1->SubItems->Strings[0],Item2->SubItems->Strings[0]);
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::LV_FilesColumnClick(TObject *Sender,
      TListColumn *Column)
{
     ColumnToSort = Column->Index;
     ((TCustomListView *)Sender)->AlphaSort();
}*/
//---------------------------------------------------------------------------


void __fastcall TMainWin::FormClose(TObject *Sender, TCloseAction &Action)
{
     Action_RemoveAll->Execute();
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::Action_PreviewExecute(TObject *Sender)
{
     PanelPreview->Visible = false;
     AnsiString strDest;

     TRenFile *Source;
     bStopProcess=false;
     ProgressBar->MaxValue=LV_Files->Items->Count;
     TBB_Process->Action=Action_Stop;
     ActiveComponents(false,TABSHEET_PREVIEW);

     switch(LB_Operations->ItemIndex) {
          case ENUMERATION :
               iEnumPosition=E_EnumStart->Value;
               break;
          case CHANGE_EXT :
               iEnumPosition=E_ExtStart->Value;
               break;
          case DATETIME :
               DateSeparator = E_DateSeparator->Text[1];
               TimeSeparator = E_TimeSeparator->Text[1];
               break;
     }

     for(int i=0;i<LV_Files->Items->Count&&bStopProcess==false;i++) {
          Source = (TRenFile *)LV_Files->Items->Objects[i];
          GetNewName(Source, strDest, LB_Operations->ItemIndex);
          LV_Preview->Items->Strings[i] = Source->FileName() + DELIMITER_CHAR + strDest;
          switch(LB_Operations->ItemIndex) {
               case ENUMERATION :
                    iEnumPosition+=E_EnumIncr->Value;
                    break;
               case CHANGE_EXT :
                    iEnumPosition+=E_ExtIncr->Value;
                    break;
          }
          ProgressBar->Progress++;
          Application->ProcessMessages();
     }

     ActiveComponents(true,TABSHEET_PREVIEW);
     ProgressBar->Progress=0;
     TBB_Process->Action=Action_Go;
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::Action_MoveUpExecute(TObject *Sender)
{
     for(int i = 1; i < LV_Files->Items->Count-1; i++) {
          if(LV_Files->Selected[i]) {
               LV_Files->Items->Move(i,i-1);
               LV_Files->Selected[i-1] = true;
               i--;
          }
     }
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::Action_MoveDownExecute(TObject *Sender)
{
     for(int i = LV_Files->Items->Count-2; i >=0; i--) {
          if(LV_Files->Selected[i]) {
               LV_Files->Items->Move(i,i+1);
               LV_Files->Selected[i+1] = true;
               i++;
          }
     }
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::Action_MoveTopExecute(TObject *Sender)
{
     int end = LV_Files->Items->Count-1;
     int stop = 0;
     for(int i = end; i >= stop; i--) {
          if(LV_Files->Selected[i]) {
               LV_Files->Items->Move(i,0);
               LV_Files->Selected[0] = true;
               i++;
               stop++;
          }
     }
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::Action_MoveBottomExecute(TObject *Sender)
{
     int end = LV_Files->Items->Count-1;
     int stop = LV_Files->Items->Count;
     for(int i = 0; i < stop; i++) {
          if(LV_Files->Selected[i]) {
               LV_Files->Items->Move(i, end);
               LV_Files->Selected[end] = true;
               i--;
               stop--;
          }
     }
}
//---------------------------------------------------------------------------

void __fastcall TMainWin::LV_FilesMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
     if(Button == mbRight) {
          int idx = LV_Files->ItemAtPos(TPoint(X,Y),true);
          if(idx != -1) {
               if(!LV_Files->Selected[idx]) {
                    for(int i = 0; i < LV_Files->Items->Count-1; i++) {
                         LV_Files->Selected[i] = false;
                    }
                    LV_Files->Selected[idx] = true;
               }
          }
     }
}
//---------------------------------------------------------------------------


void __fastcall TMainWin::LV_FilesHeaderSectionClick(
      THeaderControl *HeaderControl, THeaderSection *Section)
{
     int Col = Section->Index;
     int SortOrder[2];
     bool SortDesc;
     switch(Col) {
          case 0:
               SortOrder[0] = 0;
               SortOrder[1] = 1;
               SortDesc = (Col0SortDesc = !Col0SortDesc);
               break;
          case 1:
               SortOrder[0] = 1;
               SortOrder[1] = 0;
               SortDesc = (Col1SortDesc = !Col1SortDesc);
     }
     LV_Files->SortDescending = SortDesc;
     LV_Files->SpecialSort(SortOrder, 2);
}
//---------------------------------------------------------------------------

void __fastcall TLMDLBCompareItemEvent(System::TObject *Sender, const AnsiString s1, const AnsiString s2, Shortint & result)
{
     result = CompareText(s1,s2);
}
