/************************************************************************
 *                                                                      *
 *   Sims Object ID                                                     *
 *   (C) 2000 Antoine Potten                                            * 
 *   thesims@be.tf - http://www.thesims.be.tf                           *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************/

//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "options.h"
#include <vcl\inifiles.hpp>
#include <FileCtrl.hpp>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "cdiroutl"
#pragma resource "*.dfm"
TOptionsWindow *OptionsWindow;
//---------------------------------------------------------------------------

void __fastcall TOptionsWindow::SaveOptions(void)
{
     TIniFile *ini;
     ini = new TIniFile(ChangeFileExt(Application->ExeName, ".ini"));
     ini->WriteString("Options","Folder",E_Folder->Text);
     ini->WriteBool("Options","Backup",CB_Backup->Checked);
     ini->WriteBool("Options","Confirm",CB_Confirm->Checked);
     ini->WriteBool("Options","Incr",CB_Incr->Checked);
     ini->WriteBool("Options","SaveModif",CB_SaveModif->Checked);
     ini->WriteBool("Options","Remind",RB_Remind->Checked);
     delete ini;
}

void __fastcall TOptionsWindow::LoadOptions(void)
{
     TIniFile *ini;
     AnsiString strFolder;
     strFolder=Application->ExeName;
     strFolder.Delete(strFolder.LastDelimiter("\\"),255);
     ini = new TIniFile(ChangeFileExt(Application->ExeName, ".ini"));
     E_Folder->Text=ini->ReadString("Options","Folder",strFolder);
     CB_Backup->Checked=ini->ReadBool("Options","Backup",true);
     CB_Confirm->Checked=ini->ReadBool("Options","Confirm",false);
     CB_Incr->Checked=ini->ReadBool("Options","Incr",true);
     CB_SaveModif->Checked=ini->ReadBool("Options","SaveModif",true);
     RB_Remind->Checked=ini->ReadBool("Options","Remind",true);
     delete ini;
}

//---------------------------------------------------------------------------
__fastcall TOptionsWindow::TOptionsWindow(TComponent* Owner)
     : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TOptionsWindow::B_CancelClick(TObject *Sender)
{
     LoadOptions();
}
//---------------------------------------------------------------------------
void __fastcall TOptionsWindow::B_OKClick(TObject *Sender)
{
     SaveOptions();
}
//---------------------------------------------------------------------------
void __fastcall TOptionsWindow::FormCreate(TObject *Sender)
{
     LoadOptions();
}
//---------------------------------------------------------------------------
void __fastcall TOptionsWindow::BitBtn1Click(TObject *Sender)
{
     RB_Folder->Checked=true;
     AnsiString strDir=E_Folder->Text;
     if(SelectDirectory("Select Default Folder","",strDir))
          E_Folder->Text=strDir;
}
//---------------------------------------------------------------------------

void __fastcall TOptionsWindow::CB_BackupClick(TObject *Sender)
{
     CB_Incr->Enabled=CB_Backup->Checked;     
}
//---------------------------------------------------------------------------


void __fastcall TOptionsWindow::E_FolderClick(TObject *Sender)
{
     RB_Folder->Checked=true;     
}
//---------------------------------------------------------------------------

