/************************************************************************
 *                                                                      *
 *   Sims Object ID                                                     *
 *   (C) 2000 Antoine Potten                                            * 
 *   thesims@be.tf - http://www.thesims.be.tf                           *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************/

//---------------------------------------------------------------------------

#ifndef mainH
#define mainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ImgList.hpp>
#include <ToolWin.hpp>
#include <Dialogs.hpp>
#include <ExtCtrls.hpp>
#include <Graphics.hpp>
//---------------------------------------------------------------------------
struct TOBJD {
     char *pOBJD;
     char *pID[64];
     int iNextID;
};

class TMainWindow : public TForm
{
__published:	// IDE-managed Components
     TCoolBar *CoolBar1;
     TToolBar *ToolBar1;
     TToolButton *TB_Open;
     TImageList *ImageList1;
     TOpenDialog *OD_OpenIFF;
     TToolButton *TB_Save;
     TToolButton *TB_Options;
     TToolButton *ToolButton3;
     TListView *LV_Infos;
     TToolButton *ToolButton1;
     TToolButton *TB_About;
     TListView *LV_OBJD;
     TToolButton *ToolButton2;
     TToolButton *ToolButton4;
     TToolButton *ToolButton5;
     TToolButton *TB_List;
     TToolButton *ToolButton6;
     void __fastcall TB_OpenClick(TObject *Sender);
     void __fastcall TB_OptionsClick(TObject *Sender);
     void __fastcall FormCreate(TObject *Sender);
     void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
     void __fastcall TB_AboutClick(TObject *Sender);
     void __fastcall LV_OBJDDblClick(TObject *Sender);
     void __fastcall TB_SaveClick(TObject *Sender);
     void __fastcall FormResize(TObject *Sender);
     void __fastcall FormCloseQuery(TObject *Sender, bool &CanClose);
     void __fastcall LV_OBJDKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
     void __fastcall FormShow(TObject *Sender);
     void __fastcall TB_ListClick(TObject *Sender);
private:
     int ihFile;
     int iFileLength;
     char *MemFile;
     TOBJD OBJD[64];
     int iNextOBJD;
     AnsiString strFileName;
     bool ChangesMade;
     void __fastcall OpenIFF(AnsiString);
     void __fastcall ChangeOptions(void);
     int __fastcall AnalyseFile(char *, int);
     bool __fastcall SaveFile(int);
     bool __fastcall BackupFile(void);
     char * __fastcall WriteToMemory(int,int);
     int __fastcall FindAllOccurences(char *, char *, int, int);
     void __fastcall ChangeID(void);
     bool __fastcall CheckChanges(void);
public:
     __fastcall TMainWindow(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TMainWindow *MainWindow;
//---------------------------------------------------------------------------
#endif
