/************************************************************************
 *                                                                      *
 *   Sims Object ID                                                     *
 *   (C) 2000 Antoine Potten                                            * 
 *   thesims@be.tf - http://www.thesims.be.tf                           *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************/

//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "main.h"
#include "options.h"
#include "about.h"
#include "change.h"
#include "list.h"
#include <io.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <sys\stat.h>
#include <vcl\inifiles.hpp>

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainWindow *MainWindow;
//---------------------------------------------------------------------------

bool __fastcall TMainWindow::CheckChanges(void)
{
     if(OptionsWindow->CB_SaveModif->Checked==true&&ChangesMade==true) {
          switch(Application->MessageBox("Modifications were made, do you want "
                    "to save them ?","Question",MB_YESNOCANCEL|MB_ICONQUESTION))
          {
               case IDYES : return SaveFile(iFileLength);
               case IDCANCEL : return false;
          }
     }
     return true;
}

void __fastcall TMainWindow::OpenIFF(AnsiString strFileName)
{
     this->strFileName=strFileName;
     TB_Save->Enabled=false;
     ChangesMade=false;
     if(ihFile!=-1) close(ihFile);
     if((ihFile=open(strFileName.c_str(),O_RDONLY|O_BINARY))!=-1) {
          iFileLength=filelength(ihFile);
          TListItem *LI;
          for(int n=LV_Infos->Items->Count;n;n--) LV_Infos->Items->Delete(0);
          LI=LV_Infos->Items->Add();
          LI->Caption="File name :";
          LI->SubItems->Add(strFileName);
          LI=LV_Infos->Items->Add();
          LI->Caption="File size :";
          LI->SubItems->Add(Format("%.0n",ARRAYOFCONST((((float)iFileLength))))+" Bytes");
          if(MemFile!=NULL) delete MemFile;
          MemFile=WriteToMemory(ihFile, iFileLength);
          if(MemFile!=NULL) {
               int nOBJD=AnalyseFile(MemFile, iFileLength);
               if(nOBJD>0) {
                    LI=LV_Infos->Items->Add();
                    LI->Caption="ID count :";
                    LI->SubItems->Add(nOBJD);
                    TB_Save->Enabled=true;
               } else {
                    if(nOBJD==0) {
                         Application->MessageBox(("No ID numbers found in "
                              "the file "+strFileName).c_str(),"Message",
                              MB_OK|MB_ICONINFORMATION);
                    } else {
                         Application->MessageBox(("Unable to analyse the file "
                              +strFileName+" : File format error").c_str(),"Error",
                              MB_OK|MB_ICONSTOP);
                    }
               }
          } else {
               Application->MessageBox(("Unable to read the file "+strFileName).c_str(),
                    "Error",MB_OK|MB_ICONSTOP);
          }
     } else {
          Application->MessageBox(("Unable to open the file "+strFileName).c_str(),
               "Error",MB_OK|MB_ICONSTOP);
     }
}

char * __fastcall TMainWindow::WriteToMemory(int ih, int iLength)
{
     char *p=new char[iLength];
     int iRead;
     if(p==NULL) {
          close(ih);
          return p;
     }
     char *p2=p;
     iRead=read(ih,p,iLength);
     iLength-=iRead;
     p+=iRead;
     while(iRead!=-1&&iRead>0) {
          iRead=read(ih,p,iLength);
          iLength-=iRead;
          p+=iRead;
     }
     close(ih);
     return p2;
}

int __fastcall TMainWindow::AnalyseFile(char *p, int iLength)
{
     for(int n=LV_OBJD->Items->Count;n;n--) LV_OBJD->Items->Delete(0);
     if(iLength<35) return -1;
     if(memcmp(p,"IFF FILE 2.5:TYPE FOLLOWED BY SIZE",35)) return -1;
     int nOBJD;
     iNextOBJD=0;
     TListItem *LI;
     char strHexa[16];
     for(char *p2=p;(p2-p)<iLength;p2++) {
          if(!memcmp(p2,"OBJD",4)) {
               OBJD[iNextOBJD].pOBJD=p2;
               sprintf(strHexa,"%2.2X %2.2X %2.2X %2.2X",
                    (unsigned char)(*(p2+104)),
                    (unsigned char)(*(p2+105)),
                    (unsigned char)(*(p2+106)),
                    (unsigned char)(*(p2+107)));
               LI=LV_OBJD->Items->Add();
               LI->Caption=OBJD[iNextOBJD].pOBJD+12;
               LI->SubItems->Add(strHexa);
               LI->SubItems->Add(FindAllOccurences(p,p2+104,iNextOBJD,iLength));
               iNextOBJD++;
          }
     }
     return iNextOBJD;
}

int __fastcall TMainWindow::FindAllOccurences(char *p, char *pID,
     int CurrOBJD, int iLength)
{
     OBJD[CurrOBJD].iNextID=0;
     for(char *p2=p;(p2-p)<iLength;p2++) {
          if(!memcmp(p2,pID,4)) {
               Application->ProcessMessages();
               OBJD[CurrOBJD].pID[OBJD[CurrOBJD].iNextID]=p2;
               OBJD[CurrOBJD].iNextID++;
          }
     }
     return OBJD[CurrOBJD].iNextID;
}

bool __fastcall TMainWindow::SaveFile(int iLength)
{
     if(OptionsWindow->CB_Backup->Checked==true) {
          if(BackupFile()==false) {
               if(Application->MessageBox("Unable to make a backup copy of the "
                         "file, continue anyway (overwrite file) ?","Question",
                         MB_YESNO|MB_ICONQUESTION)==IDNO) return false;
          }
     }
     int ih, iWrite;
     char *pWrite;
     pWrite=MemFile;
     if((ih=open(strFileName.c_str(),O_WRONLY|O_CREAT|O_TRUNC|O_BINARY,
               S_IREAD|S_IWRITE))==-1) {
          Application->MessageBox("Unable to open the file in write mode",
               "Error",MB_OK|MB_ICONSTOP);
          return false;
     }
     iWrite=write(ih,pWrite,iLength);
     iLength-=iWrite;
     pWrite+=iWrite;
     while(iWrite!=-1&&iLength>0) {
          iWrite=write(ih,pWrite,iLength);
          iLength-=iWrite;
          pWrite+=iWrite;
     }
     if(iWrite==-1) {
          Application->MessageBox("Error while saving, maybe not "
               "enough free disk space","Error",MB_OK|MB_ICONSTOP);
          close(ih);
          return false;
     }
     close(ih);
     ChangesMade=false;
     return true;
}

bool __fastcall TMainWindow::BackupFile(void)
{
          int i;
          char *strExt=".bak";
          for(i=0; i<1000; i++) {
               sprintf(strExt,".%3.3i",i);
               if(FileExists(ChangeFileExt(strFileName,strExt))==false) break;
          }
          if(i>999) return false;
//          remove(ChangeFileExt(strFileName,".bak").c_str());
          return RenameFile(strFileName, ChangeFileExt(strFileName,strExt));
}

void __fastcall TMainWindow::ChangeOptions(void)
{
     OptionsWindow->ShowModal();
}

void __fastcall TMainWindow::ChangeID(void)
{
     if(LV_OBJD->Selected!=NULL) {
          AnsiString strID=LV_OBJD->Selected->SubItems[0].Strings[0];
          if(ChangeWindow->ChangeID(strID)==mrOk) {
               ChangesMade=true;
               strID=ChangeWindow->E_New->Text;
               strID.Insert(" ",7);
               strID.Insert(" ",5);
               strID.Insert(" ",3);
               LV_OBJD->Selected->SubItems[0].Strings[0]=strID;
               if(ChangeWindow->CB_Replace->Checked==true) {
                    for(int i=OBJD[LV_OBJD->Selected->Index].iNextID;i;i--) {
                         sscanf(strID.c_str(),"%X %X %X %X",
                              OBJD[LV_OBJD->Selected->Index].pID[i-1],
                              OBJD[LV_OBJD->Selected->Index].pID[i-1]+1,
                              OBJD[LV_OBJD->Selected->Index].pID[i-1]+2,
                              OBJD[LV_OBJD->Selected->Index].pID[i-1]+3);
                    }
               } else {
                    sscanf(strID.c_str(),"%X %X %X %X",
                         OBJD[LV_OBJD->Selected->Index].pOBJD+104,
                         OBJD[LV_OBJD->Selected->Index].pOBJD+105,
                         OBJD[LV_OBJD->Selected->Index].pOBJD+106,
                         OBJD[LV_OBJD->Selected->Index].pOBJD+107);
               }
          }
     }
}

//---------------------------------------------------------------------------
__fastcall TMainWindow::TMainWindow(TComponent* Owner)
     : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainWindow::TB_OpenClick(TObject *Sender)
{
     if(CheckChanges()==false) return;
     TIniFile *ini;
     ini = new TIniFile(ChangeFileExt(Application->ExeName, ".ini"));
     if(OptionsWindow->RB_Remind->Checked==false)
          OD_OpenIFF->InitialDir=OptionsWindow->E_Folder->Text;
     else OD_OpenIFF->InitialDir=ini->ReadString("Options","LastFolder","");
     if(OD_OpenIFF->Execute()==true) {
          ini->WriteString("Options","LastFolder",
               ExtractFilePath(OD_OpenIFF->FileName));
          OpenIFF(OD_OpenIFF->FileName);
     }
     delete ini;
}
//---------------------------------------------------------------------------
void __fastcall TMainWindow::TB_OptionsClick(TObject *Sender)
{
     ChangeOptions();
}
//---------------------------------------------------------------------------
void __fastcall TMainWindow::FormCreate(TObject *Sender)
{
     ihFile=-1;
     iFileLength=0;
     MemFile=NULL;
     memset(&OBJD,0,sizeof(OBJD));
     iNextOBJD=0;
     strFileName="";
     ChangesMade=false;
     TIniFile *ini;
     ini = new TIniFile(ChangeFileExt(Application->ExeName, ".ini"));
     Width=ini->ReadInteger("Main","WindowWidth",494);
     Height=ini->ReadInteger("Main","WindowHeight",388);
     delete ini;
}
//---------------------------------------------------------------------------
void __fastcall TMainWindow::FormClose(TObject *Sender,
      TCloseAction &Action)
{
     if(ihFile!=-1) close(ihFile);
     if(MemFile!=NULL) {
          delete MemFile;
          MemFile=NULL;
     }
     TIniFile *ini;
     ini = new TIniFile(ChangeFileExt(Application->ExeName, ".ini"));
     ini->WriteInteger("Main","WindowWidth",Width);
     ini->WriteInteger("Main","WindowHeight",Height);
     delete ini;
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::TB_AboutClick(TObject *Sender)
{
     AboutWindow->ShowModal();
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::LV_OBJDDblClick(TObject *Sender)
{
     ChangeID();
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::TB_SaveClick(TObject *Sender)
{
     if(OptionsWindow->CB_Confirm->Checked==true) {
          if(Application->MessageBox("Are you sure you want to save the file ?",
               "Question",MB_YESNO|MB_ICONQUESTION)==IDNO) return;
     }
     SaveFile(iFileLength);
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::FormResize(TObject *Sender)
{
     Application->ProcessMessages();
     LV_Infos->Columns->Items[1]->Width=Width-100;
     LV_OBJD->Columns->Items[0]->Width=Width-200;
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::FormCloseQuery(TObject *Sender,
      bool &CanClose)
{
     CanClose=CheckChanges();     
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::LV_OBJDKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
     if(Key==VK_RETURN) ChangeID();
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::FormShow(TObject *Sender)
{
     if(ParamCount()>0) OpenIFF(ParamStr(1));
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::TB_ListClick(TObject *Sender)
{
     TB_List->Enabled=false;
     ListWindow->Show();
}
//---------------------------------------------------------------------------

