/************************************************************************
 *                                                                      *
 *   Sims Object ID                                                     *
 *   (C) 2000 Antoine Potten                                            * 
 *   thesims@be.tf - http://www.thesims.be.tf                           *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************/

//---------------------------------------------------------------------------

#ifndef listH
#define listH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>
#include <Dialogs.hpp>
#include <stdio.h>
#include <ComCtrls.hpp>
//---------------------------------------------------------------------------
#define TTILEID_FILENAME 36
#define TTILEID_TILENAME 36
#define TTILEID_ID 12
#define TTILEID_BN 2

struct TTileID {
     char Filename[TTILEID_FILENAME];
     char Tilename[TTILEID_TILENAME];
     char ID[TTILEID_ID];
     char bn[TTILEID_BN];
};
int TTileIDcmp(const void *a, const void *b);
//---------------------------------------------------------------------------
class TListWindow : public TForm
{
__published:
     TSaveDialog *SD_List;
     TGroupBox *GroupBox1;
     TEdit *E_Folder;
     TCheckBox *CB_SubFolders;
     TSpeedButton *B_BrowseFolder;
     TGroupBox *GroupBox2;
     TCheckBox *CB_Output;
     TEdit *E_Output;
     TSpeedButton *B_BrowseOutput;
     TSpeedButton *B_OpenOutput;
     TCheckBox *CB_Sort;
     TBitBtn *B_Close;
     TBitBtn *B_Search;
     TGroupBox *GroupBox3;
     TCheckBox *CB_DupOutput;
     TEdit *E_DupOutput;
     TSpeedButton *B_BrowseDupOutput;
     TSpeedButton *B_OpenDupOutput;
     TCheckBox *CB_OpenResults;
     TBitBtn *B_SearchStop;
     TPanel *Panel1;
     TAnimate *Animation;
     TLabel *L_Progress;
     TProgressBar *Progress;
     void __fastcall B_BrowseFolderClick(TObject *Sender);
     void __fastcall FormShow(TObject *Sender);
     void __fastcall B_SearchClick(TObject *Sender);
     void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
     void __fastcall B_CloseClick(TObject *Sender);
     void __fastcall FormCreate(TObject *Sender);
     void __fastcall B_BrowseOutputClick(TObject *Sender);
     void __fastcall B_BrowseDupOutputClick(TObject *Sender);
     void __fastcall B_SearchStopClick(TObject *Sender);
     void __fastcall CB_OutputClick(TObject *Sender);
     void __fastcall B_OpenOutputClick(TObject *Sender);
     void __fastcall B_OpenDupOutputClick(TObject *Sender);
private:
     int ihFile;
     int iFileLength;
     void __fastcall Open1File(AnsiString);
     char * __fastcall WriteToMemory(int, int);
     int __fastcall ListAllID(char *, int, AnsiString);
     char *MemFile;
     bool StopSearch;
     FILE *fpOutput;
     FILE *fpDupOutput;
     AnsiString strfpOutput;
     int nLines;
     void __fastcall SearchInFolder(AnsiString);
     bool __fastcall FilenamesVerification();
     bool __fastcall CreateFiles();
     void __fastcall SearchDupID(bool bSearchDup, bool bSort);
     void __fastcall TListWindow::EnableComponents(bool bEnable);
public:
     __fastcall TListWindow(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TListWindow *ListWindow;
//---------------------------------------------------------------------------
#endif
