/************************************************************************
 *                                                                      *
 *   Sims Object ID                                                     *
 *   (C) 2000 Antoine Potten                                            * 
 *   thesims@be.tf - http://www.thesims.be.tf                           *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************/

//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "list.h"
#include "main.h"
#include <FileCtrl.hpp>
#include <io.h>
#include <fcntl.h>
#include <stdio.h>
#include <sys\stat.h>
#include <vcl\inifiles.hpp>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TListWindow *ListWindow;
//---------------------------------------------------------------------------

void __fastcall TListWindow::Open1File(AnsiString strFileName)
{
     if(ihFile!=-1) close(ihFile);
     if((ihFile=open(strFileName.c_str(),O_RDONLY|O_BINARY))!=-1) {
          iFileLength=filelength(ihFile);
          if(MemFile!=NULL) delete MemFile;
          MemFile=WriteToMemory(ihFile, iFileLength);
          if(MemFile!=NULL) {
               nLines+=ListAllID(MemFile, iFileLength, strFileName);
          }
     }
}

char * __fastcall TListWindow::WriteToMemory(int ih, int iLength)
{
     char *p=new char[iLength];
     int iRead;
     if(p==NULL) {
          close(ih);
          return p;
     }
     char *p2=p;
     iRead=read(ih,p,iLength);
     iLength-=iRead;
     p+=iRead;
     while(iRead!=-1&&iRead>0) {
          iRead=read(ih,p,iLength);
          iLength-=iRead;
          p+=iRead;
     }
     close(ih);
     return p2;
}

int __fastcall TListWindow::ListAllID(char *p, int iLength, AnsiString strFileName)
{
     L_Progress->Caption="Reading "+ExtractFileName(strFileName);
     if(iLength<35) return 0;
     if(memcmp(p,"IFF FILE 2.5:TYPE FOLLOWED BY SIZE",35)) return 0;
     int nOBJD=0;
     char strLine[100];
     for(char *p2=p;(p2-p)<iLength;p2++) {
          if(!memcmp(p2,"OBJD",4)) {
               fprintf(fpOutput,"%-35.35s %-35.35s %2.2X %2.2X %2.2X %2.2X \n",
                    strFileName.c_str(), p2+12,
                    (unsigned char)(*(p2+104)),
                    (unsigned char)(*(p2+105)),
                    (unsigned char)(*(p2+106)),
                    (unsigned char)(*(p2+107)));
               nOBJD++;
          }
     }
     return nOBJD;
}

void __fastcall TListWindow::SearchInFolder(AnsiString strFolder)
{
     AnsiString strFileName;
     TSearchRec SearchRecord;
     int RemaindFiles;
     // Files
     SetCurrentDir(strFolder);
     for(RemaindFiles=FindFirst("*.iff",faAnyFile,SearchRecord);
               RemaindFiles==0;RemaindFiles=FindNext(SearchRecord)) {
          Application->ProcessMessages();
          if(StopSearch==true) {
               FindClose(SearchRecord);
               return;
          }
          Open1File(SearchRecord.Name);
     }
     FindClose(SearchRecord);
     // Folders
     if(CB_SubFolders->Checked==true) {
          SetCurrentDir(strFolder);
          for(RemaindFiles=FindFirst("*.*",faDirectory,SearchRecord);
                    RemaindFiles==0;RemaindFiles=FindNext(SearchRecord)) {
               Application->ProcessMessages();
               if(StopSearch==true) {
                    FindClose(SearchRecord);
                    return;
               }
               if(SearchRecord.Name!="."&&SearchRecord.Name!=".."&&DirectoryExists(SearchRecord.Name)) {
                    SearchInFolder(strFolder+'\\'+SearchRecord.Name);
                    SetCurrentDir(strFolder);
               }
          }
     }
     FindClose(SearchRecord);
}

//---------------------------------------------------------------------------
__fastcall TListWindow::TListWindow(TComponent* Owner)
     : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TListWindow::B_BrowseFolderClick(TObject *Sender)
{
     AnsiString strDir=E_Folder->Text;
     if(SelectDirectory("Select a folder for search","",strDir)) {
          E_Folder->Text=strDir;
     }
}
//---------------------------------------------------------------------------

void __fastcall TListWindow::FormShow(TObject *Sender)
{
     TIniFile *ini;
     ini = new TIniFile(ChangeFileExt(Application->ExeName, ".ini"));
     E_Folder->Text=ini->ReadString("List","Folder",GetCurrentDir());
     CB_SubFolders->Checked=ini->ReadBool("List","Subfolders",true);
     E_Output->Text=ini->ReadString("List","E_Output","c:\\Search Results.txt");
     CB_Output->Checked=ini->ReadBool("List","CB_Output",true);
     CB_Sort->Checked=ini->ReadBool("List","CB_Sort",false);
     E_DupOutput->Text=ini->ReadString("List","E_DupOutput","c:\\Duplicate ID.txt");
     CB_DupOutput->Checked=ini->ReadBool("List","CB_DupOutput",false);
     CB_OpenResults->Checked=ini->ReadBool("List","CB_OpenResults",false);
     delete ini;
}
//---------------------------------------------------------------------------
void __fastcall TListWindow::B_SearchClick(TObject *Sender)
{
     fpOutput=NULL;
     fpDupOutput=NULL;
     nLines=0;
     Progress->Position=0;
     if(FilenamesVerification()==false) return;
     if(CreateFiles()==false) return;
     StopSearch=false;
     EnableComponents(false);

     SearchInFolder(E_Folder->Text);
     if(fpOutput!=NULL) fclose(fpOutput);
     if(StopSearch==false) SearchDupID(CB_DupOutput->Checked,CB_Sort->Checked);

     if(fpDupOutput!=NULL) fclose(fpDupOutput);
     EnableComponents(true);
     if(StopSearch==false) {
          Application->MessageBox("End of search","Information",MB_OK|MB_ICONINFORMATION);
          L_Progress->Caption="End of search";
          if(CB_OpenResults->Checked==true) {
               ShellExecute(0, NULL, "notepad.exe", E_DupOutput->Text.c_str(), NULL, SW_NORMAL);
          }
     } else {
          Application->MessageBox("Search canceled","Information",MB_OK|MB_ICONINFORMATION);
          L_Progress->Caption="Search canceled";
     }
}

bool __fastcall TListWindow::FilenamesVerification()
{
     int f;
     if(CB_Output->Checked==true) {
          if(E_Output->Text=="") {
               Application->MessageBox("Please select a file for output","Error",MB_OK|MB_ICONSTOP);
               return false;
          }
     }
     if(CB_DupOutput->Checked==true) {
          if(E_DupOutput->Text=="") {
               Application->MessageBox("Please select a file for output","Error",MB_OK|MB_ICONSTOP);
               return false;
          }
     }
     if(CB_Output->Checked==true&&CB_DupOutput->Checked==true) {
          if((E_Output->Text)==(E_DupOutput->Text)) {
               Application->MessageBox("Please select a different file for the two outputs","Error",MB_OK|MB_ICONSTOP);
               return false;
          }
     }
     if(CB_Output->Checked==true) {
          if((f=FileCreate(E_Output->Text))==-1) {
               Application->MessageBox(("Cannot create file \""+E_Output->Text+"\"").c_str(),"Error",MB_OK|MB_ICONSTOP);
               return false;
          } else FileClose(f);
     }
     if(CB_DupOutput->Checked==true) {
          if((f=FileCreate(E_DupOutput->Text))==-1) {
               Application->MessageBox(("Cannot create file \""+E_DupOutput->Text+"\"").c_str(),"Error",MB_OK|MB_ICONSTOP);
               return false;
          } else FileClose(f);
     }
     return true;
}
bool __fastcall TListWindow::CreateFiles()
{
     if(CB_Output->Checked==true) {
          strfpOutput=E_Output->Text;
          if((fpOutput=fopen(strfpOutput.c_str(),"wt"))==NULL) {
               Application->MessageBox(("Cannot open file \""+E_Output->Text
                    +"\" for writing").c_str(),"Error",MB_OK|MB_ICONSTOP);
               return false;
          }
     } else {
          strfpOutput=ChangeFileExt(Application->ExeName,".tmp");
          if((fpOutput=fopen(strfpOutput.c_str(),"wt"))==NULL) {
               Application->MessageBox("Cannot create a temporary file","Error",MB_OK|MB_ICONSTOP);
               return false;
          }
     }
     if(CB_DupOutput->Checked==true) {
          if((fpDupOutput=fopen(E_DupOutput->Text.c_str(),"wt"))==NULL) {
               Application->MessageBox(("Cannot open file \""+E_DupOutput->Text
                    +"\" for writing").c_str(),"Error",MB_OK|MB_ICONSTOP);
               return false;
          }
     }
     return true;
}

void __fastcall TListWindow::SearchDupID(bool bSearchDup, bool bSort)
{
     if(bSearchDup==false&&bSort==false) return;
     L_Progress->Caption="Reading temporary file";
     TTileID *TilesList = new TTileID[nLines];
     int iLine, iFile;
     if((iFile=open(strfpOutput.c_str(),O_RDONLY|O_BINARY))==-1) {
          Application->MessageBox("Error with output file / temp file","Error",MB_OK|MB_ICONERROR);
          delete[] TilesList;
          StopSearch=true;
          return;
     }
     Application->ProcessMessages();
     Progress->Position=0;
     Progress->Max=nLines;
     for(iLine=0;iLine<nLines;iLine++) {
          if(read(iFile,(void *)&(TilesList[iLine]),sizeof(struct TTileID))<1) break;
          Progress->Position++;
          Application->ProcessMessages();
     }
     nLines=iLine;
     L_Progress->Caption="Sorting";
     Application->ProcessMessages();
     qsort((void *)TilesList,nLines,sizeof(struct TTileID),TTileIDcmp);
     if(bSort==true) {
          if((iFile=open(strfpOutput.c_str(),O_WRONLY|O_BINARY|O_CREAT|O_TRUNC,S_IREAD|S_IWRITE))==-1) {
               Application->MessageBox("Unable to write sorted file","Error",MB_OK|MB_ICONERROR);
          } else {
               for(iLine=0;iLine<nLines;iLine++) {
                    if(write(iFile,(void *)&(TilesList[iLine]),sizeof(struct TTileID))<1) break;
               }
               close(iFile);
          }
     }
     Application->ProcessMessages();
     if(bSearchDup==true) {
          L_Progress->Caption="Searching Duplicate ID";
          Progress->Position=0;
          Progress->Max=nLines;
          for(iLine=1;iLine<nLines;iLine++) {
               /* start at 1 because the program cannot compare the previous line of the
                  first line (index=0) */
               if(!strncmp(TilesList[iLine].ID,TilesList[iLine-1].ID,TTILEID_ID)) {
                    fwrite((void *)&(TilesList[iLine-1]),sizeof(struct TTileID),1,fpDupOutput);
                    fwrite((void *)&(TilesList[iLine]),sizeof(struct TTileID),1,fpDupOutput);
                    fprintf(fpDupOutput,"\n");
               }
               Progress->Position++;
               Application->ProcessMessages();
          }
     }
     delete[] TilesList;
}

int TTileIDcmp(const void *a, const void *b)
{
     return(strncmp(((struct TTileID *)a)->ID,((struct TTileID *)b)->ID,TTILEID_ID));
}

void __fastcall TListWindow::EnableComponents(bool bEnable)
{
     B_Search->Visible=bEnable;
     B_SearchStop->Visible=!bEnable;
     Animation->Active=!bEnable;
     GroupBox1->Enabled=bEnable;
     GroupBox2->Enabled=bEnable;
     GroupBox3->Enabled=bEnable;
}

//---------------------------------------------------------------------------
void __fastcall TListWindow::FormClose(TObject *Sender,
      TCloseAction &Action)
{
     StopSearch=true;
     Application->ProcessMessages();
     if(B_Search->Visible==false) {
          B_Search->Visible=true;
          B_SearchStop->Visible=false;
          Animation->Active=false;
          if(fpOutput!=NULL) fclose(fpOutput);
          if(fpDupOutput!=NULL) fclose(fpDupOutput);
          if(FileExists(ChangeFileExt(Application->ExeName,".tmp")))
               DeleteFile(ChangeFileExt(Application->ExeName,".tmp"));
     }
     if(MemFile!=NULL) {
          delete MemFile;
          MemFile=NULL;
     }
     Application->ProcessMessages();
     TIniFile *ini;
     ini = new TIniFile(ChangeFileExt(Application->ExeName, ".ini"));
     ini->WriteString("List","Folder",E_Folder->Text);
     ini->WriteBool("List","Subfolders",CB_SubFolders->Checked);
     ini->WriteString("List","E_Output",E_Output->Text);
     ini->WriteBool("List","CB_Output",CB_Output->Checked);
     ini->WriteBool("List","CB_Sort",CB_Sort->Checked);
     ini->WriteString("List","E_DupOutput",E_DupOutput->Text);
     ini->WriteBool("List","CB_DupOutput",CB_DupOutput->Checked);
     ini->WriteBool("List","CB_OpenResults",CB_OpenResults->Checked);
     delete ini;
     MainWindow->TB_List->Enabled=true;
}
//---------------------------------------------------------------------------

void __fastcall TListWindow::B_CloseClick(TObject *Sender)
{
     Close();     
}
//---------------------------------------------------------------------------

void __fastcall TListWindow::FormCreate(TObject *Sender)
{
     ihFile=-1;
     MemFile=NULL;     
}
//---------------------------------------------------------------------------


void __fastcall TListWindow::B_BrowseOutputClick(TObject *Sender)
{
     SD_List->InitialDir=ExtractFilePath(E_Output->Text);
     SD_List->FileName=ExtractFileName(E_Output->Text);
     if(SD_List->Execute()==true) {
          E_Output->Text=SD_List->FileName;
     }
}
//---------------------------------------------------------------------------


void __fastcall TListWindow::B_BrowseDupOutputClick(TObject *Sender)
{
     SD_List->InitialDir=ExtractFilePath(E_DupOutput->Text);
     SD_List->FileName=ExtractFileName(E_DupOutput->Text);
     if(SD_List->Execute()==true) {
          E_DupOutput->Text=SD_List->FileName;
     }
}
//---------------------------------------------------------------------------

void __fastcall TListWindow::B_SearchStopClick(TObject *Sender)
{
     StopSearch=true;
}
//---------------------------------------------------------------------------

void __fastcall TListWindow::CB_OutputClick(TObject *Sender)
{
     B_Search->Enabled=(CB_Output->Checked)||(CB_DupOutput->Checked);     
}
//---------------------------------------------------------------------------




void __fastcall TListWindow::B_OpenOutputClick(TObject *Sender)
{
     ShellExecute(0, NULL, "notepad.exe", E_Output->Text.c_str(), NULL, SW_NORMAL);
}
//---------------------------------------------------------------------------

void __fastcall TListWindow::B_OpenDupOutputClick(TObject *Sender)
{
     ShellExecute(0, NULL, "notepad.exe", E_DupOutput->Text.c_str(), NULL, SW_NORMAL);
}
//---------------------------------------------------------------------------

