/************************************************************************
 *                                                                      *
 *   Sims Object ID                                                     *
 *   (C) 2000 Antoine Potten                                            * 
 *   thesims@be.tf - http://www.thesims.be.tf                           *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************/

//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "change.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CSPIN"
#pragma resource "*.dfm"
TChangeWindow *ChangeWindow;
//---------------------------------------------------------------------------

TModalResult __fastcall TChangeWindow::ChangeID(AnsiString strCurrent)
{
     strCurrent.Delete(12,2);
     strCurrent.Delete(9,1);
     strCurrent.Delete(6,1);
     strCurrent.Delete(3,1);
     E_Current->Text=strCurrent;
     E_New->Text=strCurrent;
     return ShowModal();
}

//---------------------------------------------------------------------------
__fastcall TChangeWindow::TChangeWindow(TComponent* Owner)
     : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TChangeWindow::B_OKClick(TObject *Sender)
{
     E_New->Text=E_New->Text.UpperCase();
     if(E_New->Text.Length()<8) {
          Application->MessageBox("Please enter 8 hexadecimal characters",
               "Error",MB_OK|MB_ICONSTOP);
          return;
     }
     for(int i=E_New->Text.Length();i;i--) {
          if((E_New->Text[i]<'A'||E_New->Text[i]>'F')
                    &&(E_New->Text[i]<'0'||E_New->Text[i]>'9')) {
               Application->MessageBox("Invalid hexadecimal number",
                    "Error",MB_OK|MB_ICONSTOP);
               return;
          }
     }
     ModalResult=mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TChangeWindow::FormShow(TObject *Sender)
{
     E_New->SetFocus();
     E_New->SelectAll();
}
//---------------------------------------------------------------------------

