(************************************************************************
 *                                                                      *
 *   Jeu de Nim                                                         *
 *   (C) 2000 Antoine Potten                                            *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   ObjNim.pas : Gestion du jeu de Nim (plateau, ligne, allumette)     *
 *                                                                      *
 ************************************************************************)

unit ObjNim;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, math;

type
     EtatAllumette=(apparente,otee,selectionnee);
     JoueurType=(humain,pc,pc_bete);
     TaillesTab=array[1..10] of integer;

TAllum=class(TImage)
     private
          Allumetat: EtatAllumette;
          procedure Selectionne;
          procedure Deselectionne;
          function Joue: boolean;
          procedure GUIEtat;
          procedure Initialise;
          procedure Rafraichit;
          procedure Click;override;
     public
          constructor CreateAllum(Owner:TComponent;FormeParam: integer);
          destructor Destroy;override;
end;

TLigne=class(TPanel)
     private
          NbAllum: integer;
          SetAllum:array[1..20] of TAllum;
          procedure Initialise;
          procedure Rafraichit;
          function Joue: boolean;
          procedure Selectionne;
          procedure Deselectionne;
          function Scanne: integer;
     public
          constructor CreateLigne(Owner:TComponent;NbAll:integer;
                                                  FormeParam: integer);
          destructor Destroy;override;
          function GetJoueurActuel: integer;
          procedure PCJoue(IA : JoueurType);overload;
          procedure PCJoue(IA : JoueurType; AllumAOter : integer);overload;
end;

TPlateau=class(tpanel)
     private
          NbLignes:integer;
          JoueurActuel: integer;
          SetLignes:array[1..10] of TLigne;
          LigSel:TLigne;
          procedure Selectionne(Lig: TLigne);
          procedure TrouveSomme(VAR ligneChoisie:integer;
               VAR allumettes:integer);
     public
          NbAllumSel: integer;
          procedure Rafraichit(FormeParam: integer);
          procedure Initialise(FormeParam: integer);
          function Scanne: integer;
          function Joue(JoueurActuelParam: integer):boolean;
          constructor CreatePlateau(Owner:TComponent; NbLignParam: integer;
               FormeParam: integer);
          destructor Destroy;override;
          function GetJoueurActuel: integer;
          function PCJoue(IA : JoueurType) : boolean;
          function Joker: string;
end;

var
     Images: array[1..2] of array[1..2] of TPicture;

implementation

// =============================================================================
// -----------------------------------------------------------------------------
// == Fonctions diverses =======================================================

function SommeNim(tailles: TaillesTab; NbLignes: integer): integer;
var
     i,j: integer;
     colonne, somme: integer;
begin
     somme:=0;
     i:=0;
     while i<(NbLignes*2) do
     begin
          j:=1;
          colonne:=0;
          while j<=NbLignes do
          begin
               colonne:=colonne+(tailles[j] MOD 2);
               tailles[j]:=trunc(tailles[j]/2);
               j:=j+1;
          end;
          somme:=somme+trunc((colonne MOD 2)*intPower(2,i));
          i:=i+1;
     end;
     SommeNim:=somme;
end;

// =============================================================================

procedure Attend;
begin
     Showcursor(false);
     Application.ProcessMessages;
          { Ncessaire pour que l'on voie ce qui se passe (slection
            d'un objet, puis disparition, car pendant le sleep l'application
            ne rpond pas, et ne traite plus les messages tels que le changement
            des images }
     Sleep(500);
     Showcursor(true);
end;

// =============================================================================
// -----------------------------------------------------------------------------
// == TAllum ===================================================================

procedure TAllum.Click;
begin
     case AllumEtat of
          apparente:     Selectionne;
          selectionnee:  Deselectionne;
          // otee:
     end;
end;

// =============================================================================

procedure TAllum.Selectionne;
begin
     (owner as TLigne).Selectionne;
     // (((TLigne *)Owner)->Selectionne) du C++
     AllumEtat:=Selectionnee;
     GUIEtat;
end;

// =============================================================================

procedure TAllum.Deselectionne;
     begin
     if(AllumEtat<>otee) then
     begin
          Allumetat:=Apparente;
          GUIEtat;
     end;
end;

// =============================================================================

function TAllum.Joue: boolean;
begin
     if AllumEtat=Selectionnee then
     begin
          Allumetat:=otee;
          GUIEtat;
          Joue:=true;
     end
     else Joue:=false;
end;

// =============================================================================

procedure TAllum.GUIEtat;
begin
     case AllumEtat of
     apparente:
          begin
               visible:=true;
               Picture:=Images[(Owner as TLigne).GetJoueurActuel][1];
          end;
     otee:
          begin
               visible:=false;
               Picture:=nil;
          end;
     selectionnee:
          begin
               visible:=true;
               Picture:=Images[(Owner as TLigne).GetJoueurActuel][2];
          end;
     end;
end;

// =============================================================================

procedure TAllum.Initialise;
begin
     AllumEtat:=apparente;
     GUIEtat;
end;

// =============================================================================

procedure TAllum.Rafraichit;
begin
     GUIEtat;
end;

// =============================================================================

constructor TAllum.CreateAllum(Owner:TComponent;FormeParam: integer);
begin
     inherited create(owner);
     height:=32;
     width:=32;
     Cursor:=1;
     Transparent:=true;
end;

// =============================================================================

destructor tallum.destroy;
begin
     inherited destroy;
end;

// =============================================================================
// -----------------------------------------------------------------------------
// == TLigne ===================================================================

function TLigne.GetJoueurActuel: integer;
begin
     GetJoueurActuel:=(owner as TPlateau).GetJoueurActuel;
end;

function TLigne.Scanne: integer;
var
     i: integer;
     nRestantes: integer;
begin
     i:=1;
     nRestantes:=0;
     while i<=NbAllum do
     begin
          if SetAllum[i].AllumEtat <> otee then
               nRestantes:=nRestantes+1;
          i:=i+1;
     end;
     Scanne:=nRestantes;
end;

// =============================================================================

procedure TLigne.Selectionne;
begin
     (owner as TPlateau).Selectionne(self);
end;

// =============================================================================

procedure TLigne.Deselectionne;
var
     i: integer;
begin
     i:=1;
     while i<=NbAllum do
     begin
          SetAllum[i].Deselectionne;
          i:=i+1;
     end;
end;

// =============================================================================

procedure Tligne.initialise;
var
     i:integer;
begin
     i:=1;
     while i<=nballum do
     begin
          setallum[i].initialise;
          i:=i+1;
     end;
end;

// =============================================================================

procedure Tligne.Rafraichit;
var
     i:integer;
begin
     i:=1;
     while i<=nballum do
     begin
          setallum[i].Rafraichit;
          i:=i+1;
     end;
end;

// =============================================================================

function Tligne.joue: boolean;
var
     i: integer;
     nJoue: integer;
begin
     i:=1;
     nJoue:=0;
     while i<=nballum do
     begin
          if setallum[i].joue=true then nJoue:=nJoue+1;
          i:=i+1;
     end;
     if nJoue <> 0 then joue:=true
     else joue:=false;
end;

// =============================================================================

constructor TLigne.CreateLigne(Owner:TComponent;nball:integer;FormeParam: integer);
var
     i:integer;
begin
     inherited create(owner);
     i:=1;
     NbAllum:=NbAll;
     while i<=NbAllum do
     begin
          SetAllum[i]:=TAllum.CreateAllum(self,FormeParam);
          SetAllum[i].Left:=10+(42*(i-1));
          SetAllum[i].Top:=5;
          InsertControl(SetAllum[i]);
          i:=i+1;
     end;
     width:=10+42*NbAllum;
     BevelOuter:=bvLowered;
     BevelInner:=bvRaised;
//   BevelOuter:=bvNone;
end;

// =============================================================================

destructor tligne.destroy;
var
     i:integer;
begin
     i:=1;
     while i<=nballum do
     begin
          removecontrol(setallum[i]);
          setallum[i].destroy;
          i:=i+1;
     end;
     inherited destroy;
end;

// =============================================================================

procedure TLigne.PCJoue(IA : JoueurType);
begin
     randomize;
     PCJoue(IA, random(Scanne)+1);
          { +1 car les lignes vont de 1  Scanne, alors que Random donne un
            nombre compris entre 0 et Scanne-1 }
end;

// =============================================================================

procedure TLigne.PCJoue(IA : JoueurType; AllumAOter : integer);
var
     allumettes : integer;
     i : integer;
begin
     i:=1;
     allumettes:=AllumAOter;
     if allumettes <= 0 then begin
          randomize;
          allumettes:=random(Scanne)+1;
     end;
     while i<=allumettes do
     begin
          if SetAllum[i].AllumEtat <> otee then
               SetAllum[i].Selectionne
          else allumettes:=allumettes+1;
          i:=i+1;
     end;
end;

// =============================================================================
// -----------------------------------------------------------------------------
// == TPlateau =================================================================

function TPlateau.Scanne: integer;
var
     i: integer;
     nRestantes: integer;
begin
     i:=1;
     nRestantes:=0;
     while i<=NbLignes do
     begin
//          nRestantes:=nRestantes+SetLignes[i].Scanne;
          if SetLignes[i].Scanne > 0 then nRestantes:=nRestantes+1;
          i:=i+1;
     end;
     Scanne:=nRestantes;
end;

// =============================================================================

procedure tplateau.initialise(FormeParam: integer);
var
     i:integer;
begin
     Rafraichit(FormeParam);
     ligsel:=nil;
     i:=1;
     while i<=nblignes do
     begin
          setlignes[i].initialise;
          i:=i+1;
     end;
end;

// =============================================================================

function tplateau.joue(JoueurActuelParam: integer): boolean;
var
     res: boolean;
begin
     res:=ligsel.joue;
     if res=true then JoueurActuel:=JoueurActuelParam;
     joue:=res;
end;

// =============================================================================

constructor tplateau.createplateau(owner:tcomponent; NbLignParam: integer;
                                                       FormeParam: integer);
var
     i,NbAll,TailleMax:integer;
begin
     inherited create(owner);
     JoueurActuel:=2;
     NbLignes:=NbLignParam;
     TailleMax:=NbLignParam-1;
//     if TailleMax=3 then TailleMax:=TailleMax+1;
     i:=1;
     nball:=1;
     while i<=NbLignes do
     begin
          SetLignes[i]:=TLigne.CreateLigne(self,NbAll,FormeParam);
          SetLignes[i].Top:=50*i;
          SetLignes[i].Left:=25+(50*(TailleMax)-42*(NbAll div 2));
          InsertControl(SetLignes[i]);
          NbAll:=NbAll+2;
          i:=i+1;
     end;
     width:=100*NbLignes;
//     if NbLignes=3 then width:=width+100;
     height:=50*NbLignes+100;
     Top:=28;
     BevelInner:=bvLowered;
     BevelOuter:=bvNone;
     Images[1][1]:=TPicture.Create;
     Images[1][2]:=TPicture.Create;
     Images[2][1]:=TPicture.Create;
     Images[2][2]:=TPicture.Create;
     Initialise(FormeParam);
end;

// =============================================================================

procedure TPlateau.Rafraichit(FormeParam: integer);
var
     i:integer;
     folder: string;
begin
     folder := ExtractFilePath(Application.ExeName);
     case FormeParam of
          1: begin
               Images[2][1].Bitmap.LoadFromFile(folder+'res\cone_bleu.bmp');
               Images[2][2].Bitmap.LoadFromFile(folder+'res\cone_orange.bmp');
               Images[1][1].Bitmap.LoadFromFile(folder+'res\cone_vert.bmp');
               Images[1][2].Bitmap.LoadFromFile(folder+'res\cone_rose.bmp');
          end;
          2: begin
               Images[2][1].Bitmap.LoadFromFile(folder+'res\boule_bleue.bmp');
               Images[2][2].Bitmap.LoadFromFile(folder+'res\boule_rouge.bmp');
               Images[1][1].Bitmap.LoadFromFile(folder+'res\boule_verte.bmp');
               Images[1][2].Bitmap.LoadFromFile(folder+'res\boule_mauve.bmp');
          end;
          3: begin
               Images[2][1].Bitmap.LoadFromFile(folder+'res\cube_1a.bmp');
               Images[2][2].Bitmap.LoadFromFile(folder+'res\cube_1b.bmp');
               Images[1][1].Bitmap.LoadFromFile(folder+'res\cube_2a.bmp');
               Images[1][2].Bitmap.LoadFromFile(folder+'res\cube_2b.bmp');
          end;
          4: begin
               Images[2][1].Bitmap.LoadFromFile(folder+'res\tetra_orange1.bmp');
               Images[2][2].Bitmap.LoadFromFile(folder+'res\tetra_orange2.bmp');
               Images[1][1].Bitmap.LoadFromFile(folder+'res\tetra_vert1.bmp');
               Images[1][2].Bitmap.LoadFromFile(folder+'res\tetra_vert2.bmp');
          end;
          5: begin
               Images[2][1].Bitmap.LoadFromFile(folder+'res\vw_blanche.bmp');
               Images[2][2].Bitmap.LoadFromFile(folder+'res\vw_rouge.bmp');
               Images[1][1].Bitmap.LoadFromFile(folder+'res\vw_jaune.bmp');
               Images[1][2].Bitmap.LoadFromFile(folder+'res\vw_bleue.bmp');
          end;
          6: begin
               Images[2][1].Bitmap.LoadFromFile(folder+'res\disk_bleu1.bmp');
               Images[2][2].Bitmap.LoadFromFile(folder+'res\disk_bleu2.bmp');
               Images[1][1].Bitmap.LoadFromFile(folder+'res\disk_orange1.bmp');
               Images[1][2].Bitmap.LoadFromFile(folder+'res\disk_orange2.bmp');
          end;
     end;
     i:=1;
     while i<=nblignes do
     begin
          setlignes[i].Rafraichit;
          i:=i+1;
     end;
end;

// =============================================================================

destructor TPlateau.Destroy;
var
     i:integer;
begin
     i:=1;
     while i<=nblignes do
     begin
          removecontrol(setlignes[i]);
          setlignes[i].destroy;
          i:=i+1;
     end;
     Images[1][1].Destroy;
     Images[1][2].Destroy;
     Images[2][1].Destroy;
     Images[2][2].Destroy;
     inherited destroy;
end;

// =============================================================================

procedure TPlateau.Selectionne(Lig: TLigne);
begin
     if LigSel=nil then
     begin
          LigSel:=Lig;
          NbAllumSel:=1;
     end
     else
          if LigSel <> Lig then
          begin
               NbAllumSel:=1;
               LigSel.Deselectionne;
               LigSel:=Lig;
//             Accueil.BJouer.Enabled:=false;
          end
          else
          begin
               NbAllumSel:=NbAllumSel+1;
          end;
end;

// =============================================================================

function TPlateau.GetJoueurActuel: integer;
begin
     GetJoueurActuel:=JoueurActuel;
end;

// =============================================================================

function TPlateau.PCJoue(IA : JoueurType) : boolean;
var
     ligneChoisie, allumettes: integer;
begin
     case IA of
          pc : begin
               Attend;
               TrouveSomme(ligneChoisie, allumettes);
               SetLignes[ligneChoisie].PCJoue(IA,allumettes);
               Attend;
               PCJoue:=true;
          end;
          pc_bete : begin
               Attend;
               randomize;
               ligneChoisie:=random(NbLignes);
               ligneChoisie:=ligneChoisie+1;
               while SetLignes[ligneChoisie].Scanne = 0 do
               begin
                    ligneChoisie:=random(NbLignes);
                    ligneChoisie:=ligneChoisie+1;
                    Application.ProcessMessages;
                         { Pour viter que le programme ne soit bloqu si la
                           boucle dure trop longtemps }
               end;
               SetLignes[ligneChoisie].PCJoue(IA);
               Attend;
               PCJoue:=true;
          end;
          else PCJoue:=false;
     end;
end;

// =============================================================================

function TPlateau.Joker: string;
var
     ligneChoisie, allumettes: integer;
begin
     TrouveSomme(ligneChoisie, allumettes);
     if allumettes<=0 then Joker:='Vous pouvez jouer ce que vous voulez ...'
     else Joker:='Slectionnez '+inttostr(allumettes)+' pions sur la ligne '
          +'numro '+inttostr(ligneChoisie);
end;

// =============================================================================

procedure TPlateau.TrouveSomme(VAR ligneChoisie:integer; VAR allumettes:integer);
var
     i, ligneMax: integer;
     tailles: TaillesTab;
begin
     ligneMax:=0;
     ligneChoisie:=1;
     i:=1;
     while i<=NbLignes do
     begin
          tailles[i]:=SetLignes[i].Scanne;
          if tailles[i]>ligneMax then
          begin
               ligneMax:=tailles[i];
               ligneChoisie:=i;
          end;
          i:=i+1;
     end;
     if Scanne = 1 then allumettes:=SetLignes[ligneChoisie].Scanne
     else
     begin
          allumettes:=SommeNim(tailles,NbLignes);
          if allumettes > ligneMax then allumettes:=allumettes-ligneMax;
     end;
end;

// =============================================================================
// -----------------------------------------------------------------------------
// =============================================================================

end.

