(************************************************************************
 *                                                                      *
 *   Jeu de Nim                                                         *
 *   (C) 2000 Antoine Potten                                            *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   Gagnant.pas : Fentre affichant le joueur ayant gagn la partie    *
 *                                                                      *
 ************************************************************************)

unit Gagnant;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Inifiles;

type
  TGagnantWindow = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    B_OK: TSpeedButton;
    L_PartieTerminee: TLabel;
    L_Texte: TLabel;
    Image1: TImage;
    Image2: TImage;
    procedure B_OKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
     strGagne: string;
  public
     procedure Affiche(Joueur: integer; Tours: integer);
     procedure LoadLanguage(ini: TIniFile);
  end;

var
  GagnantWindow: TGagnantWindow;

implementation

{$R *.DFM}

// =============================================================================
// -----------------------------------------------------------------------------
// == GagnantWindow ============================================================

procedure TGagnantWindow.B_OKClick(Sender: TObject);
begin
     close;
end;

// =============================================================================

procedure TGagnantWindow.Affiche(Joueur: integer; Tours: integer);
begin
     L_Texte.Caption:=Format(strGagne, [Joueur, Tours]);
     ShowModal();
end;

procedure TGagnantWindow.LoadLanguage(ini: TIniFile);
begin
     Caption:=ini.ReadString('Gagnant','Caption','Partie Termine');
     L_PartieTerminee.Caption:=ini.ReadString('Gagnant','Titre','Partie termine');
     strGagne:=ini.ReadString('Gagnant','Gagnant','Le Joueur %d a gagn en %d coups !');
end;

// =============================================================================

procedure TGagnantWindow.FormCreate(Sender: TObject);
begin
     Image1.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+'res\coupe.bmp');
     Image2.Picture:=Image1.Picture;
end;

// =============================================================================
// -----------------------------------------------------------------------------
// =============================================================================
end.
