(************************************************************************
 *                                                                      *
 *   Jeu de Nim                                                         *
 *   (C) 2000 Antoine Potten                                            *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   AcceuilNim.pas : Gestion de la fentre et class drive de la     *
 *                    classe 'plateau'                                  *
 *                                                                      *
 ************************************************************************)

unit AccueilNim;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls,objnim, Menus, AboutBox, ToolWin, ComCtrls, ImgList,
  IniFiles;

type

Tplateau1=class(tplateau)
   private
   public
     function Ajoue(JoueurActuel: integer):boolean;
end;

TAccueil = class(TForm)
     ToolBar1: TToolBar;
     B_Nouveau: TToolButton;
     B_Jouer: TToolButton;
     ImageList1: TImageList;
     B_Quitter: TToolButton;
     B_About: TToolButton;
     CoolBar1: TCoolBar;
     BoxNbLignes: TComboBox;
     BoxFormes: TComboBox;
     PopupMenu1: TPopupMenu;
     M_ChangeCouleur: TMenuItem;
     B_Options: TToolButton;
     Joueur11: TMenuItem;
     Joueur21: TMenuItem;
    B_1_humain: TMenuItem;
    B_1_pc: TMenuItem;
    B_1_pc_bete: TMenuItem;
    B_2_humain: TMenuItem;
    B_2_pc: TMenuItem;
    B_2_pc_bete: TMenuItem;
    ImageList2: TImageList;
    Langue1: TMenuItem;
     procedure FormCreate(Sender: TObject);
     procedure M_NouveauClick(Sender: TObject);
     procedure FormClose(Sender: TObject; var Action: TCloseAction);
     procedure B_NouveauClick(Sender: TObject);
     procedure B_JouerClick(Sender: TObject);
     procedure B_QuitterClick(Sender: TObject);
     procedure B_AboutClick(Sender: TObject);
     procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
     procedure BoxFormesChange(Sender: TObject);
     procedure BoxNbLignesChange(Sender: TObject);
     procedure M_ChangeCouleurClick(Sender: TObject);
     procedure B_OptionsClick(Sender: TObject);
    procedure B_1_humainClick(Sender: TObject);
    procedure B_1_pcClick(Sender: TObject);
    procedure B_1_pc_beteClick(Sender: TObject);
    procedure B_2_humainClick(Sender: TObject);
    procedure B_2_pcClick(Sender: TObject);
    procedure B_2_pc_beteClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
   private
     nTour: integer;
     JoueurActuel: integer;
     Joueurs : Array[1..2] of JoueurType;
     FichiersNLG: TStringList;
     strNoSelect: string;
     strTitre: string;
     procedure NouvellePartie();
     procedure ClickJoue;
     procedure FindLanguages;
     procedure LoadLanguage(Sender: TObject);
   public
     procedure ChangeJoueur();
     procedure ChangeJoueurActif(Pour : integer; IA : JoueurType);
end;

const
     TOOLBAR_HEIGHT = 28;

var
     Accueil: TAccueil;
     plateau: tplateau1;

implementation

uses Gagnant;
{$R *.DFM}

// =============================================================================
// -----------------------------------------------------------------------------
// == TPlateau1 ================================================================

function tplateau1.Ajoue(JoueurActuel: integer):boolean;
var
     res: boolean;
     JoueurAct: integer;
begin
     if Accueil.M_ChangeCouleur.Checked=true then
          JoueurAct:=JoueurActuel
     else
          JoueurAct:=2;
     if nballumsel>0 then
          res:=joue(JoueurAct)
     else res:=false;
     ajoue:=res;
end;

// =============================================================================
// -----------------------------------------------------------------------------
// == TAccueil =================================================================

procedure TAccueil.NouvellePartie();
var
     NbLignes: integer;
begin
     NbLignes:=BoxNbLignes.ItemIndex+3;
     nTour:=1;
     if plateau <> nil then begin
          removecontrol(plateau);
          plateau.Destroy;
          Application.ProcessMessages;
     end;
     ClientWidth:=100*NbLignes;
     ClientHeight:=50*NbLignes+100+TOOLBAR_HEIGHT;
     self.Position:=poDesktopCenter;
     plateau:=tplateau1.createplateau(self,NbLignes,BoxFormes.ItemIndex+1);
     insertcontrol(plateau);
     B_Jouer.Enabled:=true;
     JoueurActuel:=2;
     ChangeJoueur;
end;

// =============================================================================

procedure TAccueil.FormCreate(Sender: TObject);
begin
     BoxNbLignes.ItemIndex:=2;
     BoxFormes.ItemIndex:=1;
     Joueurs[1]:=humain;
     Joueurs[2]:=humain;
     Screen.Cursors[1]:=LoadCursorFromFile(PChar(ExtractFilePath(Application.ExeName)+'res\hand.cur'));
     Screen.Cursors[2]:=LoadCursorFromFile(PChar(ExtractFilePath(Application.ExeName)+'res\point.cur'));
     strTitre:=Caption;
     FindLanguages;
     NouvellePartie;
end;

// =============================================================================

procedure TAccueil.M_NouveauClick(Sender: TObject);
begin
     NouvellePartie();
end;

// =============================================================================

procedure TAccueil.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     if Plateau <> nil then Plateau.Destroy;
     FichiersNLG.Destroy;
end;

// =============================================================================

procedure TAccueil.ChangeJoueur();
begin
     case JoueurActuel of
          1: JoueurActuel:=2;
          2: JoueurActuel:=1;
     end;
     self.Caption:=Format(strTitre, [nTour,JoueurActuel]);
     Plateau.Rafraichit(BoxFormes.ItemIndex+1);
     if Plateau.PCJoue(Joueurs[JoueurActuel]) = true then
     begin
          ClickJoue;
     end;
end;

// =============================================================================

procedure TAccueil.B_NouveauClick(Sender: TObject);
begin
     NouvellePartie();
end;

// =============================================================================

procedure TAccueil.B_JouerClick(Sender: TObject);
begin
     ClickJoue;
end;

// =============================================================================

procedure TAccueil.ClickJoue;
begin
     if(Plateau.Ajoue(JoueurActuel)=false) then
     begin
          MessageDlg(strNoSelect, mtWarning,[mbOk], 0);
     end
     else
     begin
          if Plateau.Scanne=0 then
          begin
               GagnantWindow.Affiche(JoueurActuel,nTour);
               B_Jouer.Enabled:=false;
          end
          else
          begin
               nTour:=nTour+1;
               ChangeJoueur;
          end;
     end;
end;

// =============================================================================

procedure TAccueil.B_QuitterClick(Sender: TObject);
begin
     Close;
end;

// =============================================================================

procedure TAccueil.B_AboutClick(Sender: TObject);
begin
     AboutBoxWindow.ShowModal;
end;

// =============================================================================

procedure TAccueil.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
     case Key of
          VK_F5 : B_Jouer.Click;
          VK_F2 : B_Nouveau.Click;
          VK_F1 : begin
               if Shift = [ssShift] then
                    MessageDlg(Plateau.Joker,mtInformation,[mbOK],0)
               else
                    B_About.Click;
          end;
          VK_ESCAPE : begin
               B_1_humain.Click;
               B_2_humain.Click;
          end;
     end;
end;

// =============================================================================

procedure TAccueil.BoxFormesChange(Sender: TObject);
begin
     Plateau.Rafraichit(BoxFormes.ItemIndex+1);
end;

// =============================================================================

procedure TAccueil.BoxNbLignesChange(Sender: TObject);
begin
     NouvellePartie();
end;

// =============================================================================

procedure TAccueil.M_ChangeCouleurClick(Sender: TObject);
begin
     M_ChangeCouleur.Checked:= NOT M_ChangeCouleur.Checked
end;

// =============================================================================

procedure TAccueil.B_OptionsClick(Sender: TObject);
begin
//     B_Options.DropdownMenu.Popup(0,0);
end;

// =============================================================================

procedure TAccueil.B_1_humainClick(Sender: TObject);
begin
     B_1_humain.Checked:=true;
     ChangeJoueurActif(1,humain);
end;

// =============================================================================

procedure TAccueil.B_1_pcClick(Sender: TObject);
begin
     B_1_pc.Checked:=true;
     ChangeJoueurActif(1,pc);
end;

// =============================================================================

procedure TAccueil.B_1_pc_beteClick(Sender: TObject);
begin
     B_1_pc_bete.Checked:=true;
     ChangeJoueurActif(1,pc_bete);
end;

// =============================================================================

procedure TAccueil.B_2_humainClick(Sender: TObject);
begin
     B_2_humain.Checked:=true;
     ChangeJoueurActif(2,humain);
end;

// =============================================================================

procedure TAccueil.B_2_pcClick(Sender: TObject);
begin
     B_2_pc.Checked:=true;
     ChangeJoueurActif(2,pc);
end;

// =============================================================================

procedure TAccueil.B_2_pc_beteClick(Sender: TObject);
begin
     B_2_pc_bete.Checked:=true;
     ChangeJoueurActif(2,pc_bete);
end;


// =============================================================================

procedure TAccueil.ChangeJoueurActif(Pour : integer; IA : JoueurType);
begin
     Joueurs[Pour]:=IA;
     if B_Jouer.Enabled = true then
     begin
          if JoueurActuel = Pour then
          begin
               if Plateau.PCJoue(Joueurs[JoueurActuel]) = true then
               begin
                    ClickJoue;
               end;
          end;
     end;
end;

procedure TAccueil.FindLanguages;
var
     NewItem: TMenuItem;
     Recherche: TSearchRec;
     Fichier: TextFile;
     Ligne: string;
     i, FichierExiste: integer;
begin
     i:=0;
     FichiersNLG:=TStringList.Create;
     FichiersNLG.Sorted:=true;
     FichierExiste:=FindFirst(ExtractFilePath(Application.ExeName)+'?.nlg',faAnyFile,Recherche);
     while FichierExiste=0 do
     begin
          FichiersNLG.Add(Recherche.Name);
          FichierExiste:=FindNext(Recherche);
          i:=i+1;
     end;
     FindClose(Recherche);
     while i>0 do
     begin
          AssignFile(Fichier,FichiersNLG.Strings[i-1]);
          Reset(Fichier);
          Readln(Fichier,ligne);
          closefile(Fichier);
          NewItem:=TMenuItem.Create(self);
          NewItem.Caption:=Ligne;
          NewItem.RadioItem:=true;
          NewItem.Name:='M_NLG'+inttostr(i-1);
          NewItem.OnClick:=LoadLanguage;
          PopupMenu1.Items[3].Insert(0,NewItem);
          i:=i-1;
     end;
end;

procedure TAccueil.LoadLanguage(Sender: TObject);
var
     Fichier: string;
     Ini: TIniFile;
     SelIndex: integer;
begin
     if Sender.classNameIs('TMenuItem') = true then
     begin
          Fichier:=FichiersNLG[strtoint((Sender as TMenuItem).Name[6])];
          (Sender as TMenuItem).Checked:=true;
          Ini:=TIniFile.Create(ChangeFileExt(Application.Exename,'.ini'));
          ini.WriteString('Config','Langue',Fichier);
          Ini.Destroy;
     end
     else
     begin
          Ini:=TIniFile.Create(ChangeFileExt(Application.Exename,'.ini'));
          Fichier:=ini.ReadString('Config','Langue','0.nlg');
          Ini.Destroy;
          PopupMenu1.Items[3].Items[strtoint(ChangeFileExt(ExtractFileName(Fichier),''))].Checked:=true;
     end;
     Ini:=TIniFile.Create(ExtractFilePath(Application.ExeName)+Fichier);
     strTitre:=ini.ReadString('AccueilNim','Caption','Jeu de Nim [Tour %d : Joueur %d]');
     strNoSelect:=ini.ReadString('AccueilNim','NoSelect','Aucun pion slectionn');
     PopupMenu1.Items[0].Caption:=ini.ReadString('AccueilNim','MenuCouleurs','Couleurs diffrentes par joueur');
     PopupMenu1.Items[1].Caption:=ini.ReadString('AccueilNim','MenuJoueur1','Joueur 1');
     PopupMenu1.Items[1].Items[0].Caption:=ini.ReadString('AccueilNim','MenuJoueurHumain','Humain');
     PopupMenu1.Items[1].Items[1].Caption:=ini.ReadString('AccueilNim','MenuJoueurPC','PC');
     PopupMenu1.Items[1].Items[2].Caption:=ini.ReadString('AccueilNim','MenuJoueurPCBete','PC alatoire');
     PopupMenu1.Items[2].Caption:=ini.ReadString('AccueilNim','MenuJoueur2','Joueur 2');
     PopupMenu1.Items[2].Items[0].Caption:=ini.ReadString('AccueilNim','MenuJoueurHumain','Humain');
     PopupMenu1.Items[2].Items[1].Caption:=ini.ReadString('AccueilNim','MenuJoueurPC','PC');
     PopupMenu1.Items[2].Items[2].Caption:=ini.ReadString('AccueilNim','MenuJoueurPCBete','PC alatoire');
     PopupMenu1.Items[3].Caption:=ini.ReadString('AccueilNim','MenuLangue','Langue');
     B_Nouveau.Hint:=ini.ReadString('AccueilNim','B_Nouveau','Nouvelle partie (F2)');
     B_Options.Hint:=ini.ReadString('AccueilNim','B_Options','Options');
     B_Jouer.Hint:=ini.ReadString('AccueilNim','B_Jouer','Jouer (F5)');
     B_About.Hint:=ini.ReadString('AccueilNim','B_About','Informations (F1)');
     B_Quitter.Hint:=ini.ReadString('AccueilNim','B_Quitter','Quitter (ALT+F4)');
     BoxNbLignes.Hint:=ini.ReadString('AccueilNim','BoxNbLignes','Nombre de lignes');
     BoxFormes.Hint:=ini.ReadString('AccueilNim','BoxFormes','Forme des pions');
     SelIndex:=BoxFormes.ItemIndex;
     BoxFormes.Items[0]:=ini.ReadString('AccueilNim','BoxFormes1','Cnes');
     BoxFormes.Items[1]:=ini.ReadString('AccueilNim','BoxFormes2','Balles');
     BoxFormes.Items[2]:=ini.ReadString('AccueilNim','BoxFormes3','Cubes');
     BoxFormes.Items[3]:=ini.ReadString('AccueilNim','BoxFormes4','Tetra');
     BoxFormes.Items[4]:=ini.ReadString('AccueilNim','BoxFormes5','Autos');
     BoxFormes.Items[5]:=ini.ReadString('AccueilNim','BoxFormes6','Floppy');
     BoxFormes.ItemIndex:=SelIndex;
     self.Caption:=Format(strTitre, [nTour,JoueurActuel]);
     GagnantWindow.LoadLanguage(ini);
     AboutBoxWindow.LoadLanguage(ini);
     Ini.Destroy;
end;

// =============================================================================

procedure TAccueil.FormShow(Sender: TObject);
begin
     LoadLanguage(Sender);
end;

// =============================================================================
// -----------------------------------------------------------------------------
// =============================================================================
end.

