(************************************************************************
 *                                                                      *
 *   Jeu de Nim                                                         *
 *   (C) 2000 Antoine Potten                                            *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   AboutBox.pas : Bote de dialogue ' propos de ...'                 *
 *                                                                      *
 ************************************************************************)

unit AboutBox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, ComCtrls, ImgList, Inifiles, ShellApi;

type
  TAboutBoxWindow = class(TForm)
    Panel1: TPanel;
    B_OK: TSpeedButton;
    Panel3: TPanel;
    L_Titre: TLabel;
    Image1: TImage;
    Image2: TImage;
    Panel4: TPanel;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Panel2: TPanel;
    L_Mail: TLabel;
    L_Site: TLabel;
    L_InfMail: TLabel;
    L_InfWeb: TLabel;
    L_InfICQ: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    Panel5: TPanel;
    Panel6: TPanel;
    L_Sources: TLabel;
    ImageList1: TImageList;
    L_Version: TLabel;
    ImageList2: TImageList;
    Image3: TImage;
    L_Dev: TLabel;
    L_Historique: TMemo;
    L_Credits: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure Label3Click(Sender: TObject);
    procedure Label5Click(Sender: TObject);
    procedure B_OKClick(Sender: TObject);
    procedure L_MailMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure L_SiteMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Panel2MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure L_SourcesMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Panel6MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure L_SourcesClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
  public
     procedure LoadLanguage(ini: TIniFile);
  end;

var
  AboutBoxWindow: TAboutBoxWindow;

implementation

{$R *.DFM}

// =============================================================================
// -----------------------------------------------------------------------------
// == AboutBoxWindow ===========================================================

procedure TAboutBoxWindow.Button1Click(Sender: TObject);
begin
     Close;
end;

// =============================================================================

procedure TAboutBoxWindow.Label3Click(Sender: TObject);
begin
     ShellExecute(0, Nil, 'mailto:antp@ibelgique.com', Nil, Nil, SW_NORMAL);
end;

// =============================================================================

procedure TAboutBoxWindow.Label5Click(Sender: TObject);
begin
     ShellExecute(0, Nil, 'http://www.antp.be.tf/software', Nil, Nil, SW_NORMAL);
end;

// =============================================================================

procedure TAboutBoxWindow.B_OKClick(Sender: TObject);
begin
     Close;
end;

// =============================================================================

procedure TAboutBoxWindow.L_MailMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
     L_Mail.Font.Color:=clBlue;
     L_Mail.Font.Style:=[fsUnderline];
end;

// =============================================================================

procedure TAboutBoxWindow.L_SiteMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
     L_Site.Font.Color:=clBlue;
     L_Site.Font.Style:=[fsUnderline];
end;

// =============================================================================

procedure TAboutBoxWindow.Panel2MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
     L_Mail.Font.Color:=clNavy;
     L_Site.Font.Color:=clNavy;
     L_Mail.Font.Style:=[];
     L_Site.Font.Style:=[];
end;

// =============================================================================

procedure TAboutBoxWindow.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     case Key of
          VK_ESCAPE : close;
          VK_RETURN : close;
     end;
end;

// =============================================================================

procedure TAboutBoxWindow.L_SourcesMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
     L_Sources.Font.Color:=clBlue;
     L_Sources.Font.Style:=[fsUnderline];
end;

// =============================================================================

procedure TAboutBoxWindow.Panel6MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
     L_Sources.Font.Color:=clNavy;
     L_Sources.Font.Style:=[];
end;

// =============================================================================

procedure TAboutBoxWindow.L_SourcesClick(Sender: TObject);
begin
     ShellExecute(0, Nil, 'http://dept-info.labri.u-bordeaux.fr/~loeb/nim/', Nil, Nil, SW_NORMAL);
end;

// =============================================================================

procedure TAboutBoxWindow.FormCreate(Sender: TObject);
begin
     L_Mail.Cursor:=2;
     L_Site.Cursor:=2;
     L_Sources.Cursor:=2;
     Image3.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+'res\labri.bmp');
end;

// =============================================================================

procedure TAboutBoxWindow.LoadLanguage(ini: TIniFile);
var
     Fichier: TextFile;
     Ligne: string;
begin
     Caption:=ini.ReadString('AboutBox','Caption','Informations');
     L_Titre.Caption:=ini.ReadString('AboutBox','Titre','Jeu de Nim');
     L_Version.Caption:=ini.ReadString('AboutBox','Version','Version')+' 1.2.0 (16/06/2000)';
     L_Credits.Text:=ini.ReadString('AboutBox','Credits','La stratgie gagnante (intelligence artificielle) est issue du site web du Laboratoire Borderlais d''Informatique (LaBRI), et est disponible  l''adresse suivante :');
     L_Dev.Caption:=ini.ReadString('AboutBox','Dev','Ce pogramme a t dvelopp sous Borland Delphi 4');
     TabSheet1.Caption:=ini.ReadString('AboutBox','TabCreateur','Crateur');
     TabSheet2.Caption:=ini.ReadString('AboutBox','TabHist','Historique');
     TabSheet3.Caption:=ini.ReadString('AboutBox','TabCredits','Crdits');
     L_Historique.Lines.Clear;
     AssignFile(Fichier,ChangeFileExt(ini.FileName,'.nhs'));
     Reset(Fichier);
     Readln(Fichier,ligne);
     while not Eof(Fichier) do
     begin
          L_Historique.Lines.Add(ligne);
          Readln(Fichier,ligne);
     end;
     closefile(Fichier);

end;

// =============================================================================
// -----------------------------------------------------------------------------
// =============================================================================

end.
