.MODEL SMALL        ; Ŀ
.286                ;   Antoine Potten (ANDR414) Groupe 1GE1  
.STACK 100h         ; Ĵ
                    ;      ASM02 :  Le jeu des hexagones    
JUMPS               ; Ĵ
LOCALS              ;        H.E.B. - E.S.I.  1998/1999       
                    ; 

;  ͻ
;͹ Donnes 
;  ͼ

.DATA

        BMP_Nom         DB "asm02.bmp",0
        BMP_Handle      DW ?
        BMP_Palette     DB 1024 DUP(?)   ; Palette du fichier BMP (BGR?)
        BMP_Ligne       DB 320 DUP(?)    ; On lit le fichier ligne par ligne

        RGB_Palette     DB 768 DUP(?)    ; Palette convertie (RGB)

        Nb_Hexa         DW 0    ; Dimension du plateau de jeu
        Gagne           DB 0    ; Contient la couleur du gagnant (0 si
                                ;   personne n'a encore gagn)
        Nouv_Hexa       DB 0    ; Incrment si un nouvel hexagone continue
                                ;   la "chane" partant d'une des frontires
        Joueur          DB 0    ; Joueur 1 = Couleur 1
                                ; Joueur 2 = Couleur 2
        Couleur1        DB 03   ; Bleu
        Couleur2        DB 12   ; Rouge
        Hexa_i          DW 0    ; N de ligne de l'hexagone
        Hexa_j          DW 0    ; N de colonne de l'hexagone
        Hexa_L          DW 0    ; Largeur d' hexagone
        Hexa_H          DW 0    ; Hauteur du ct d'un hexagone
        Hexa_Sx         DW 0    ; Point x du sommet de l'hexagone
        Hexa_Sy         DW 0    ; Point y du sommet de l'hexagone
        Sens_Front      DB 0    ; Sens de dessin de la frontire verticale
        Tableau         DB 20*20 DUP(0)

        Quitter         DB "Appuyez sur une touche...$"
        Copyright       DB "Copyright (C) 1999 Antoine Potten",10,13
                        DB "",10,10,13
                        DB "e-Mail : antoine.potten@skynet.be",10,13
                        DB "Site web : http://users.skynet.be/acp/",10,13
                        DB 10,10,10,13,"$"

;  ͻ
;͹ Programme 
;  ͼ

.CODE

;  Ŀ
;Ĵ Main() 
;  

MAIN PROC

        MOV AX,@DATA
        MOV DS,AX
        CALL PRESENT         ; Page de prsentation
        CALL JEU             ; Jeu des haxagones
        CALL SORTIE          ; Sortie du programme

MAIN ENDP


;  ͻ
;͹ Fonctions 
;  ͼ

;  Ŀ
;Ĵ Present 
;  
;     Entre : #aucune#     Sortie : #aucune#
;     Les registres sont modifis. Cette fonction affiche l'image BMP et
;       laisse  l'utilisateur le choix de la taille de la zone de jeu

PRESENT PROC

        MOV AL,13h
        XOR AH,AH                 ; Mode vido 320x200 (256 couleurs)
        INT 10h

        LEA DX,BMP_Nom            ; Ouverture du fichier BMP
        CALL OUVRIR_FICHIER
        MOV BMP_Handle,AX
                                  ; Le handle est encore dans AX (AX->BX)
        MOV BX,AX                 ; On lit les 54 bytes d'en-tte du fichier
        MOV CX,54                 ;   (dont on a pas besoin), et on les 
        MOV DX,OFFSET BMP_Ligne   ;   place dans une variable qui servira 
        CALL LIRE_FICHIER         ;   recevoir autre chose, plus loins dans
                                  ;   le programme
        MOV CX,1024
        MOV DX,OFFSET BMP_Palette
        CALL LIRE_FICHIER         ; Lecture de la palette

        CALL CHANGE_PALETTE   ; "Dcodage" de la palette
        CALL CHARGE_PALETTE   ; Mise  jour de la palette de couleur active
        CALL AFFICHE_BMP      ; Lecture et affichage de l'image

        CALL PRESENT_SOURIS       ; Gestion de la souris
        CALL EFFACE_IMAGE
        MOV AL,18
        XOR AH,AH      ; On passe en mode graphique 640x480
        INT 10h
        RET

PRESENT ENDP


;  Ŀ
;Ĵ Change_Palette 
;  
;     Entre : BMP_Palette     Sortie : RGB_Palette
;     Les registres sont modifis. Cette fonction convertit la palette du
;       fichier BMP (code en BGR?, place dans BMP_Palette) en une palette
;       standard (code en RGB) et la place dans RGB_Palette.

CHANGE_PALETTE PROC
        
        XOR DI,DI
        XOR SI,SI
        MOV CX,256                 ; Il y a 256 valeurs dans la palette

@@Next: MOV AL,BMP_Palette[SI]
        SHR AL,2                   ; Seuls 6 des 8 bits sont utiliss :
        MOV RGB_Palette[DI+2],AL   ;     
                                   ;                _ _
        MOV AL,BMP_Palette[SI+1]   ;
        SHR AL,2                   ;   ==>    _ _      
        MOV RGB_Palette[DI+1],AL

        MOV AL,BMP_Palette[SI+2]
        SHR AL,2
        MOV RGB_Palette[DI],AL

        ADD DI,3     ; R,G,B   = 3
        ADD SI,4     ; B,G,R,? = 4
        LOOP @@Next

        RET
        
CHANGE_PALETTE ENDP


;  Ŀ
;Ĵ Charge_Palette 
;  
;     Entre : RGB_Palette     Sortie : #aucune#
;     Les registres ne sont pas modifis. Cette fonction change la palette
;       active, en la remplaant par celle contenue dans RGB_Palette.

CHARGE_PALETTE PROC

        PUSH AX
        PUSH BX
        PUSH CX
        PUSH ES
                   ; On doit travailler dans ES (en transfrant DS dans ES),
        MOV AX,DS  ;   et bien sr sauver l'tat d'origine de ES.
        MOV ES,AX
        MOV DX,OFFSET RGB_Palette
        MOV AH,10h
        MOV AL,12h
        XOR BX,BX
        MOV CX,256    ; Chargement des 256 valeurs de la palette
        INT 10h

        POP ES
        POP CX
        POP BX
        POP AX
        RET

CHARGE_PALETTE ENDP


;  Ŀ
;Ĵ Affiche_BMP 
;  
;     Entre : #aucune#     Sortie : #aucune#
;     Les registres sont modifis. Cette fonction affiche l'image dont le
;       handle est dans BMP_Handle et dont la palette a dj t charge.
;     On commence l'affichage par le bas, puisque c'est de cette faon que
;       les fichiers BMP sont cods.

AFFICHE_BMP PROC

        MOV DI,63999         ; 64000 pixels
        MOV AX,0A000h
        MOV ES,AX
        MOV CX,200           ; 200 lignes de 320 pixels

@@NextLine:
        PUSH CX
        MOV SI,319           ; 320 pixels par ligne
        MOV BX,BMP_Handle
        MOV CX,320           ; 320 pixels, sert pour la boucle et en 
        LEA DX,BMP_Ligne     ;   mme temps pour la lecture
        CALL LIRE_FICHIER

@@NextPixel:
        MOV BL,BMP_Ligne[SI]
        MOV ES:[DI],BL
        DEC DI
        DEC SI
        LOOP @@NextPixel

        POP CX
        LOOP @@NextLine

        RET

AFFICHE_BMP ENDP


;  Ŀ
;Ĵ Ouvrir_Fichier 
;  
;     Entre : DS:[DX] = Nom du fichier
;     Sortie : AX = Handle du fichier
;     BX, CX, DX, SI, DI, BP, CS, DS, SS, ES ne sont pas modifis

OUVRIR_FICHIER PROC

        XOR AL,AL
        MOV AH,3Dh
        INT 21h
        RET

OUVRIR_FICHIER ENDP


;  Ŀ
;Ĵ Fermer_Fichier 
;  
;     Entre : DS:[DX] = Nom de la zone mmoire de rception
;              BX = Handle du fichier, CX = Nombre d'octets  lire
;     Sortie : AX = Nombre d'octets lus (0 si EOF)
;     BX, CX, DX, SI, DI, BP, CS, DS, SS, ES ne sont pas modifis

LIRE_FICHIER PROC

        MOV AH,3Fh
        INT 21h
        RET

LIRE_FICHIER ENDP


;  Ŀ
;Ĵ Present_Souris 
;  
;     Entre : #aucune#     Sortie : #aucune#
;     Les registres sont modifis. Cette fonction gre la souris dans la
;       page de prsentation.

PRESENT_SOURIS PROC

        CALL INIT_SOURIS
   @@ReadMouse:
        MOV AX,3
        INT 33h
        CMP BX,0         ; Si on ne clique pas, il ne se passe rien
        JE @@ReadMouse
        CMP DX,190       ; Idem si on n'est pas dans la zone de choix   ;193
        JB @@ReadMouse
        SHR CX,1  ; La souris renvoie sa position par rapport  un cran de
                  ; 640 pixels de large. Comme on travaille ici en 320x200,
                  ; il faut diviser par 2 la coordonne renvoye.
        CALL CHOIX_NUM
        RET

PRESENT_SOURIS ENDP


;  Ŀ
;Ĵ Choix_Num 
;  
;     Entre : CX = Position horizontale de la souris
;     Sortie : Nb_Hexa (DB) contient le n choisi
;     Les registres ne sont pas modifis. Cette fonction sert  savoir la
;       taille de la zone de jeu choisie. Elle compte le nombre de fois
;       qu'il y a 20 pixels entre le bord gauche de l'cran et la position
;       de la souris.

CHOIX_NUM PROC

        PUSH AX
        PUSH CX
        XOR AX,AX

    @@Next:
        SUB CX,20        ; Les carrs de choix font 20 pixels de large
        CMP CX,0
        JL @@Exit
        INC AX
        JMP @@Next

    @@Exit:
        ADD AX,5         ; Le premier carr porte le n 5
        MOV Nb_Hexa,AX

        POP CX
        POP AX
        RET

CHOIX_NUM ENDP


;  Ŀ
;Ĵ Efface_Image 
;  
;     Entre : #aucune#     Sortie : #aucune#
;     Les registres sont modifis. Cette fonction diminue progressivement
;       les valeurs de la palette, afin de faire "s'assombrir" l'cran.

EFFACE_IMAGE PROC

        MOV CX,64                ; On doit dcrmenter maximum 64 fois les
 @@Pal:                          ;   valeurs de la palette
        PUSH CX
        MOV CX,768               ; La palette fait 768 octets
        XOR DI,DI
   @@Ind:
        CMP RGB_Palette[DI],0    ; Si la couleur est dj  zro (= noir),
        JE @@Zero                ;   il ne faut surtout plus y toucher
        DEC RGB_Palette[DI]
        @@Zero:
        INC DI

        PUSH CX
        MOV CX,1024
        @@Temp:        ; Il faut "perdre du temps", sinon on ne voit pas
        LOOP @@Temp    ;   le changement de couleur de l'image (trop rapide
        POP CX         ;   sur un 166 MHz)

    LOOP @@Ind
        CALL CHARGE_PALETTE      ; On dfinit cette nouvelle palette comme
        POP CX                   ;   tant la palette active
  LOOP @@Pal
        RET

EFFACE_IMAGE ENDP


;  Ŀ
;Ĵ Init_Souris 
;  
;     Entre : #aucune#     Sortie : #aucune#
;     Les registres ne sont pas modifis.
;     Cette fonction initialise la souris et affiche le curseur.

INIT_SOURIS PROC

        PUSH AX
        XOR AX,AX   ; Initialisation
        INT 33h
        MOV AX,1    ; Affichage du curseur
        INT 33h
        POP AX
        RET

INIT_SOURIS ENDP


;  Ŀ
;Ĵ Jeu 
;  
;     Entre : #aucune#     Sortie : #aucune#
;     Les registres sont modifis. Cette fonction appelle les diffrentes
;       fonctions permettant de jouer au jeu des hexagones.

JEU PROC

        CALL DESSINE_HEXA
        CALL DESSINE_FRONT
        CALL INIT_SOURIS
        CALL JOUEUR_SUIVANT

  @@Continuer:
        MOV AX,3
        INT 33h
        CMP BX,2         ; On ne quitte pas le programme tant que l'on ne
        JE @@Exit        ;   clique pas avec le bouton droit, ou que l'on
        CMP BX,1         ;   ne choisit pas un hexagone, ou encore tant que 
        JNE @@PasClicG   ;   personne n'a gagn
        CALL SOURIS_TEST_HEXA
        MOV AX,3
     @@Wait:
        INT 33h          ; Cette boucle sert  empcher de colorier plusieurs
        CMP BX,1         ;   hexagones en gardant le bouton de la souris
        JE @@Wait        ;   appuy
     @@PasClicG:
        CMP Gagne,0
        JE @@Continuer
        CALL EFFACE_PERDANT

    @@Exit:
        MOV AX,2         ; On cache le curseur
        INT 33h
        MOV DX,OFFSET Quitter
        MOV AH,09
        INT 21h
        XOR AH,AH
        INT 16h          ; Et on attend qu'une touche soit presse
        RET

JEU ENDP


;  Ŀ
;Ĵ Calc_Hexa 
;  
;     Entre : Nb_Hexa : Nombre d'hexagones par ligne
;              Hexa_i / Hexa_j : Ligne /colonne de l'hexagone
;     Sortie : Hexa_Sx /Hexa_Sy : Sommet de l'hexagone
;              Hexa_L / Hexa_H : Largeur / hauteur de l'hexagone
;     Calcule les dimensions d'un hexagone.
;     Les registres ne sont pas modifis.

CALC_HEXA PROC

        PUSH AX
        PUSH BX
        PUSH DX

        MOV AX,3         ; Calcul de Hexa_L : largeur d' hexagone
        MUL Nb_Hexa
        DEC AX           ;    L = 600/(3*n-1)
        MOV BX,AX
        MOV AX,600
        XOR DX,DX
        DIV BX
        MOV Hexa_L,AX

        MOV AX,Nb_Hexa   ; Calcul de Hexa_H : hauteur du ct d'un hexagone
        INC AX
        MUL Hexa_L       ;    H = (460-L*(n+1))/n
        MOV BX,AX
        MOV AX,460
        SUB AX,BX
        XOR DX,DX
        DIV Nb_Hexa
        MOV Hexa_H,AX

        MOV AX,Hexa_L    ; Calcul de Hexa_Sx : coordonne horizontale du 
        SHL AX,1         ;   sommet de l'hexagone
        MUL Hexa_j
        MOV BX,AX        ;    Sx = 20+L*(n-i)+2*L*j
        MOV AX,Nb_Hexa
        SUB AX,Hexa_i
        MUL Hexa_L
        ADD AX,BX
        ADD AX,20
        MOV Hexa_Sx,AX

        MOV AX,Hexa_H    ; Calcul de Hexa_Sy : coordonne verticale du 
        ADD AX,Hexa_L    ;   sommet de l'hexagone
        MUL Hexa_i
        ADD AX,10        ;    Sy = 10+i*(H+L)
        MOV Hexa_Sy,AX

        POP DX
        POP BX
        POP AX
        RET

CALC_HEXA ENDP


;  Ŀ
;Ĵ Dessine_Hexa 
;  
;     Entre : Variables Hexa_*    Sortie : #aucune#
;     Dessine la grille d'hexagones d'aprs la taille et la position
;     trouve dans les variables L, H, Sx, Sy et la position i/j (ligne/
;     colonne). Les registres sont modifis.

DESSINE_HEXA PROC

@@Ecran:                  ; On affiche chaque ligne
        MOV Hexa_j,0
@@Ligne:                  ; Et sur chaque ligne, on affiche le bon nombre
        CALL CALC_HEXA    ;   d'hexagones
        MOV AL,15         ; Couleur : blanc
        MOV CX,Hexa_Sx
        MOV DX,Hexa_Sy    ; Position de dpart : coordonnes du sommet
        XOR BX,BX
        MOV AH,0Ch        ;
                          ; Tout au long de la fonction, DI sert  compter le
        XOR DI,DI         ;   nombre de pixels affichs
@@OblicHD:        ;  \       
        INC DX
        INC CX
        INC DI
        PUSH DI          ; La fonction 0Ch de l'interruption 10h modifie
        INT 10h          ; les registres DI et SI
        POP DI
        CMP DI,Hexa_L
        JNE @@OblicHD
        XOR DI,DI
@@VertD:          ;  |
        INC DX
        INC DI
        PUSH DI
        INT 10h
        POP DI
        CMP DI,Hexa_H
        JNE @@VertD
        XOR DI,DI
@@OblicBD:        ;  /
        DEC CX
        INC DX
        INC DI
        PUSH DI
        INT 10h
        POP DI
        CMP DI,Hexa_L
        JNE @@OblicBD
        XOR DI,DI
@@OblicBG:        ; \
        DEC CX
        DEC DX
        INC DI
        PUSH DI
        INT 10h
        POP DI
        CMP DI,Hexa_L
        JNE @@OblicBG
        XOR DI,DI
@@VertG:          ; |
        DEC DX
        INC DI
        PUSH DI
        INT 10h
        POP DI
        CMP DI,Hexa_H
        JNE @@VertG
        XOR DI,DI
@@OblicHG:        ; /
        DEC DX
        INC CX
        INC DI
        PUSH DI
        INT 10h
        POP DI
        CMP DI,Hexa_L
        JNE @@OblicHG

        INC Hexa_j       ; Colonne suivante
        MOV CX,Nb_Hexa
        CMP Hexa_j,CX
        JNE @@Ligne
        INC Hexa_i       ; Ligne suivante
        MOV CX,Nb_Hexa
        CMP Hexa_i,CX    ; On ne peut pas comparer deux zones mmoire
        JNE @@Ecran

        RET

DESSINE_HEXA ENDP


;  Ŀ
;Ĵ Dessine_Front 
;  
;     Entre : Taille de la zone de jeu : Nb_Hexa
;     Sortie : #aucune#
;     Dessine les frontires du jeu, d'aprs le nombre d'hexagones choisis.
;     Les registres sont modifis.

DESSINE_FRONT PROC

        MOV Hexa_i,0         ; On commence par le coin suprieur droit
        MOV Hexa_j,0
        CALL CALC_HEXA       ; On calcule le sommet de l'hexagone de ce coin
        MOV AH,0Ch
        MOV AL,Couleur1
        MOV CX,Hexa_Sx
        MOV DX,Hexa_Sy
        DEC DX               ; 1 pixel plus haut que le bord de l'hexagone
        CALL FRONTIERE_H     ; On affiche une frontire horizontale

        MOV BX,Nb_Hexa
        DEC BX               ; Affichage  partir du 1er hexa. de la dernire
        MOV Hexa_i,BX        ;   ligne
        CALL CALC_HEXA
        MOV CX,Hexa_Sx
        MOV DX,Hexa_Sy
        SUB CX,Hexa_L
        ADD DX,Hexa_L
        ADD DX,Hexa_H
        ADD DX,5             ; Correction pour l'paisseur de la frontire
        CALL FRONTIERE_H     ; On affiche une frontire horizontale

        MOV AL,Couleur2
        MOV Hexa_i,0
        CALL CALC_HEXA
        MOV CX,Hexa_Sx
        MOV DX,Hexa_Sy
        DEC CX               ; 1 pixels plus  gauche que le bord de l'hexa.
        CALL FRONTIERE_V     ; On affiche une frontire verticale

        INC Sens_Front       ; La frontire de droite n'est pas la mme
        MOV Hexa_i,0         ;   que celle de gauche
        MOV BX,Nb_Hexa       ; Affichage  partir du dernier hexa. de la
        MOV Hexa_j,BX        ;   1re ligne
        CALL CALC_HEXA
        MOV CX,Hexa_Sx
        MOV DX,Hexa_Sy
        SUB CX,Hexa_L
        ADD DX,Hexa_L
        ADD CX,5             ; Correction pour l'paisseur de la frontire
        CALL FRONTIERE_V     ; On affiche une frontire verticale
        RET

DESSINE_FRONT ENDP


;  Ŀ
;Ĵ Frontire_H. 
;  
;     Entre : Frontire suprieure ou infrieure : Sens_Front
;              Nombre d'hexagones : Nb_Hexa
;              Position x/y de dpart : CX/DX
;     Sortie : #aucune#
;     Dessine une frontire horizontale, d'aprs le nombre d'hexagones
;     choisis et le sens pass en paramtre (par une variable).
;     Les registres sont modifis.

FRONTIERE_H PROC

        XOR BX,BX          ; BX sert de compteur (on a besoin de CX pour
@@FrontH:                  ;   autre chose, et les interruptions ne modifient
        PUSH BX            ;   pas BX)
        PUSH CX
        PUSH DX

        MOV BX,Nb_Hexa
  @@MD:
        PUSH BX
        CALL FRONT_D   ; affiche '\'
        CALL FRONT_M   ; affiche '/'
        POP BX
        DEC BX
        CMP BX,1
        JNE @@MD
        CALL FRONT_D   ; affiche le dernier '\'


        POP DX
        POP CX
        POP BX
        INC BX
        DEC DX
        CMP BX,5         ; paisseur de la frontire
        JNE @@FrontH
        RET

FRONTIERE_H ENDP


;  Ŀ
;Ĵ Frontire_V. 
;  
;     Entre : Nombre d'hexagones : Nb_Hexa
;              Position x/y de dpart : CX/DX
;     Sortie : #aucune#
;     Dessine une frontire verticale d'aprs le nombre d'hexagones
;     choisis. Ici, le ct gauche ou droit n'a pas d'importance, car les
;     deux frontires sont identiques. Les registres sont modifis.

FRONTIERE_V PROC

        XOR BX,BX           ; BX sert ici aussi de compteur
@@FrontV:
        PUSH BX
        PUSH CX
        PUSH DX

        MOV BX,Nb_Hexa
  @@VG:
        PUSH BX
        CMP Sens_Front,1 ; On regarde si c'est la frontire gauche ou droite
        JE @@Droite
        CALL FRONT_G
        CALL FRONT_V
        JMP @@Suite
      @@Droite:
        CALL FRONT_V      ; affiche '|'
        CALL FRONT_G      ; affiche '/'
      @@Suite:
        POP BX
        DEC BX
        CMP BX,0
        JNE @@VG

        POP DX
        POP CX
        POP BX
        INC BX
        DEC CX
        CMP BX,5         ; paisseur de la frontire
        JNE @@FrontV
        RET

FRONTIERE_V ENDP


;  Ŀ
;Ĵ Front_Montante 
;  
;     Entre : Largeur de l'hexagone : Hexa_L
;              Position x/y de dpart : CX/DX
;     Sortie : Position x/y de fin : CX/DX
;     Dessine un morceau de frontire : '/'. Les registres sont modifis.

FRONT_M PROC

        XOR BX,BX
      @@M:
        INT 10h
        INC CX
        DEC DX
        INC BX
        CMP BX,Hexa_L
        JL @@M
        RET

FRONT_M ENDP


;  Ŀ
;Ĵ Front_Descendante 
;  
;     Entre : Largeur de l'hexagone : Hexa_L
;              Position x/y de dpart : CX/DX
;     Sortie : Position x/y de fin : CX/DX
;     Dessine un morceau de frontire : '\'. Les registres sont modifis.

FRONT_D PROC

        XOR BX,BX
      @@D:
        INT 10h
        INC CX
        INC DX
        INC BX
        CMP BX,Hexa_L
        JL @@D
        RET

FRONT_D ENDP

;  Ŀ
;Ĵ Front_Verticale 
;  
;     Entre : Hauteur de l'hexagone : Hexa_H
;              Position x/y de dpart : CX/DX
;     Sortie : Position x/y de fin : CX/DX
;     Dessine un morceau de frontire : '|'. Les registres sont modifis.

FRONT_V PROC

        XOR BX,BX
      @@D:
        INT 10h
        INC DX
        INC BX
        CMP BX,Hexa_H
        JL @@D
        RET

FRONT_V ENDP


;  Ŀ
;Ĵ Front_Gauche 
;  
;     Entre : Largeur de l'hexagone : Hexa_L
;              Position x/y de dpart : CX/DX
;     Sortie : Position x/y de fin : CX/DX
;     Dessine un morceau de frontire : '/'. Les registres sont modifis.
;     Alors que Front_M par d'en-bas  gauche pour remonter, Front_G par
;     d'en haut  droite pour descendre.

FRONT_G PROC

        XOR BX,BX
      @@G:
        INT 10h
        DEC CX
        INC DX
        INC BX
        CMP BX,Hexa_L
        JL @@G
        RET

FRONT_G ENDP


;  Ŀ
;Ĵ Souris_Test_Hexa 
;  
;     Entre : Position x de la souris : CX,  Position y de la souris : DX
;     Sortie : Variable 'Gagne' mise  1 si un des deux jours a gagn
;     Cette fonction dtermine l'hexagone  colorier, et appelle une
;       fonction qui vrifie si un des joueurs a gagn. Les registres
;       sont modifis.

SOURIS_TEST_HEXA PROC

        CALL SOURIS_CALC_IJ   ; On calcule le n d'hexagone sur lequel on
        CALL SOURIS_CORR_IJ   ;   a cliqu
        MOV AX,Nb_Hexa
        CMP Hexa_i,0
        JL @@Exit
        CMP Hexa_i,AX         ; Ces tests servent  viter que l'on puisse
        JGE @@Exit            ;   faire apparatre des hexagones en dehors
        CMP Hexa_j,0          ;   de la zone de jeu
        JL @@Exit
        CMP Hexa_j,AX
        JGE @@Exit

        PUSH DX               ; Il faut sauver la position de la souris
        MOV AX,Hexa_i         ;   qui risque d'tre perdue lors de la 
        MUL Nb_Hexa           ;   multiplication
        ADD AX,Hexa_j
        MOV SI,AX
        POP DX
        CMP Tableau[SI],0     ; On ne peut colorier l'hexagone que s'il
        JNE @@Exit            ;   n'a encore t colori par personne

        MOV AX,2
        INT 33h
        CALL COLORIE_HEXA     ; Pendant le coloriage de l'hexagone, il faut
        MOV AX,1              ;   cacher le cuseur pour viter des problmes
        INT 33h               ;   d'affichage
        CALL TEST_GAGNE       ; On teste si le joueur courant a gagn
        CALL JOUEUR_SUIVANT   ; Un des deux joueurs a jou, c'est au tour de
   @@Exit:                    ;   l'autre
        RET

SOURIS_TEST_HEXA ENDP


;  Ŀ
;Ĵ Souris_Calc_IJ 
;  
;     Entre : Position x/y de la souris : CX/DX
;              Taille de l'hexagone : Hexa_H, Hexa_L
;     Sortie : Numro d'hexagone : Hexa_i, Hexa_j
;     Trouve sur quel hexagone on a cliqu. Les registres sont modifis,
;       sauf CX et DX qui contiennent la position de la souris.

SOURIS_CALC_IJ PROC

        PUSH CX           ; On ne doit pas perdre ces valeurs : elles
        PUSH DX           ;   serviront pour la fonction suivante

        MOV BX,Hexa_H
        ADD BX,Hexa_L
        MOV AX,DX         ;    i = (My-10)/(L+H)
        SUB AX,10
        XOR DX,DX
        DIV BX
        MOV Hexa_i,AX

        MOV BX,Hexa_L
        SHL BX,1
        MOV AX,Nb_Hexa    ;    j = (Mx-20-(n-i-1)*L)/(2*L)
        SUB AX,Hexa_i
        DEC AX
        MUL Hexa_L
        SUB CX,20    ;  CX contient encore la position x de la souris
        SUB CX,AX
        MOV AX,CX
        XOR DX,DX
        DIV BX
        MOV Hexa_j,AX

        POP DX
        POP CX
        RET

SOURIS_CALC_IJ ENDP


;  Ŀ
;Ĵ Souris_Corr_IJ 
;  
;     Entre : Position x/y de la souris : CX/DX
;              Taille de l'hexagone : Hexa_H, Hexa_L
;              Numro d'hexagone : Hexa_i, Hexa_j
;     Sortie : Numro d'hexagone corrig : Hexa_i, Hexa_j
;     Corrige le numro trouv par la fonction 'Souris_Calc_IJ', dans le
;       cas o l'on aurait cliqu dans le carr entourant l'hexagone, mais
;       en dehors de la pointe. Les registres sont modifis.

SOURIS_CORR_IJ PROC

        MOV BX,DX
        SUB BX,10
        MOV AX,Hexa_H
        ADD AX,Hexa_L       ; Dy = My-10-i*(L+H)
        MUL Hexa_i
        SUB BX,AX
        PUSH BX

        SUB CX,20
        MOV AX,Hexa_L
        MUL Hexa_j          ; Dx = Mx-20-(n-i-1)*L-2*j*L
        SHL AX,1
        MOV BX,AX
        MOV AX,Nb_Hexa
        SUB AX,Hexa_i
        DEC AX
        MUL Hexa_L
        SUB CX,AX
        SUB CX,BX   ; La position Dx est dans CX
        POP DX      ; La position Dy est dans DX

        MOV AX,CX
        ADD AX,DX
        CMP AX,Hexa_L     ; Si (Dx+Dy)<L Alors i--, j--
        JGE @@Next1
        DEC Hexa_i
        DEC Hexa_j
      @@Next1:
        MOV AX,CX
        SUB AX,Hexa_L
        CMP AX,DX         ; Si (Dx>L)&&(Dy<Dx-L) Alors i--
        JLE @@Next2
        CMP CX,Hexa_L
        JLE @@Next2
        DEC Hexa_i
      @@Next2:
        RET

SOURIS_CORR_IJ ENDP


;  Ŀ
;Ĵ Colorie_Hexa 
;  
;     Entre : Numro d'hexagone : Hexa_i / Hexa_j, Joueur (Couleur)
;     Sortie : #aucune#
;     Colorie un hexagone d'aprs le n de ligne et de colonne trouv dans
;       les variables Hexa_i et Hexa_j, ainsi que la couleur (le joueur
;       en cours). Les registres sont modifis.

COLORIE_HEXA PROC

        MOV AL,Joueur

        CALL CALC_HEXA
        MOV CX,Hexa_Sx
        MOV DX,Hexa_Sy    ; Position de dpart : coordonnes du sommet
        MOV AH,0Ch        ;
        ADD DX,Hexa_L     ;                     On se place ici   /\
        SUB CX,Hexa_L     ;                                  > /  \
        INC CX            ; Incrmentation pour ne pas           |  |
        PUSH CX           ;   dessiner sur le bord de            |  |
        PUSH DX           ;   l'hexagone                         \  /
                          ;                                       \/
        MOV BX,Hexa_L
        SHL BX,1       ; BL sert de compteur pour la largeur du triangle 
  @@PointeH:           ;   suprieur de l'hexagone
        DEC BX         ;                              /\
        PUSH BX        ;                             /__\
        PUSH CX        ;                              |  |
     @@LignePH:        ;                              |__|
        INT 10h        ;                              \  /
        INC CX         ;                               \/
        DEC BX         ;
        CMP BX,0
     JNE @@LignePH
        DEC DX       ; On remonte d'une ligne
        POP CX
        POP BX
        DEC BX
        INC CX            ; Et on repart un pixel plus loin que pour la ligne
        CMP CX,Hexa_Sx    ;   d'en-dessous (Hexa_Sx correspond au milieu de
  JLE @@PointeH           ;   la largeur, donc on doit arrter quand CX a
        POP DX            ;   la mme valeur x que le sommet)
        POP CX            ;                                      /\
                          ;                                     /__\
        INC DX            ; On commence  dessine le carr :   |  |
        MOV BX,Hexa_L     ;                                    |__|
        SHL BX,1          ;                                     \  /
        DEC BX            ;                                      \/
        MOV DI,Hexa_H     ; BX sert de compteur pour savoir quand on est
        DEC DI            ;   arriv  la fin de la ligne, DI sert  savoir
  @@Carre:                ;   quand on est arriv  la fin du carr
        PUSH BX
        PUSH CX
        PUSH DI
     @@LigneC:
        INT 10h
        INC CX
        DEC BX
        CMP BX,0
     JNE @@LigneC
        INC DX
        POP DI
        POP CX
        POP BX
        DEC DI
        CMP DI,0
  JNE @@Carre

        MOV BX,Hexa_L     ; On dessine la pointe infrieure, avec le mme
        SHL BX,1          ;   systme que la pointe suprieure, mais on 
  @@PointeB:              ;   incrmente le n de ligne au lieu de le
        DEC BX            ;   dcrmenter
        PUSH BX           ;                /\
        PUSH CX           ;               /__\
     @@LignePB:           ;               |  |
        INT 10h           ;               |__|
        INC CX            ;              \  /
        DEC BX            ;               \/
        CMP BX,0
     JNE @@LignePB
        INC DX
        POP CX
        POP BX
        DEC BX
        INC CX
        CMP CX,Hexa_Sx
  JLE @@PointeB
        PUSH AX                ; Il faut inscrire le "propritaire" de
        MOV AX,Hexa_i          ;   l'hexagone dans un tableau, qui reprend
        MUL Nb_Hexa            ;   toute la zone de jeu (pour savoir, par
        ADD AX,Hexa_j          ;   aprs, si l'hexagone est dj coloris ou
        MOV SI,AX              ;   pour dterminer qui a rejoint les deux
        POP AX                 ;   frontires)
        MOV Tableau[SI],AL     ; On crit la couleur de l'hexagone dans le
        RET                    ;   tableau
        
COLORIE_HEXA ENDP


;  Ŀ
;Ĵ Joueur_Suivant 
;  
;     Entre : Joueur prcdent : 'Joueur'
;     Sortie : Nouveau joueur : 'Joueur'
;     Change le joueur actif et affiche un carr de sa couleur dans le coin
;       suprieur droit de l'cran. Les registres sont modifis.

JOUEUR_SUIVANT PROC

        MOV AL,Joueur
        CMP AL,Couleur1
        JNE @@Autre
        MOV AL,Couleur2
        JMP @@Continue      ; On change la couleur du joueur
      @@Autre:              ;   (si Joueur = Couleur 1 alors
        MOV AL,Couleur1     ;   Joueur <- Couleur 2, sinon le contraire)
      @@Continue:
        MOV Joueur,AL
        XOR BX,BX
        MOV AH,0Ch
        MOV DX,30
 @@Carre:
        MOV CX,30
    @@Ligne:
        INT 10h
        INC CX
        CMP CX,70             ; On dessine un petit carr de 40x40
    JNE @@Ligne               ;   pixels de la couleur du joueur actif
        INC DX
        CMP DX,70
 JNE @@Carre
        RET

JOUEUR_SUIVANT ENDP


;  Ŀ
;Ĵ Test_Gagn 
;  
;     Entre : Joueur courant : 'Joueur', Tableau de jeu : 'Tableau'
;     Sortie : Variable 'Gagne' modifie si le joueur a rejoint ses deux
;              frontires.
;     Cette fonction (spare en trois fonctions pour viter une trop longue
;       fonction : Test_Gagn, Test_Vert, Test_Horiz) teste si le joueur
;       courant a gagn la partie (si ses hexagones forment un chemin
;       continu). Les registres sont modifis.

TEST_GAGNE PROC

@@Deb:  MOV AL,Joueur
        CMP AL,Couleur1       ; Ce joueur-l doit relier les frontires
        JE @@Horiz            ;   suprieurs et infrieures
        CALL TEST_VERT
        JMP @@Suite
       @@Horiz:               ; L'autre doit relier les frontires gauches
        CALL TEST_HORIZ       ;   et droites
       @@Suite:
        CMP Nouv_Hexa,0       ; Tant que l'on trouve des nouveaux hexagones
        JNE @@Deb             ;   dans la "chane", on continue  en
        RET                   ;   chercher

TEST_GAGNE ENDP

; Test pour le joueur qui doit rejoindre le haut et le bas de la zone de jeu

TEST_VERT PROC

        MOV AL,Joueur
        MOV AH,Joueur          ; Couleur+1 = Hexagone marqu comme faisant
        INC AH                 ;   partie de la chane

        MOV Nouv_Hexa,0

        MOV CX,Nb_Hexa
        XOR DI,DI
      @@PremCol:
        CMP Tableau[DI],AL
        JNE @@Next
        INC Tableau[DI]        ; On marque tous les hexagones de la premire
        INC Nouv_Hexa          ;   colonne (ceux qui correspondent  la
      @@Next:                  ;   couleur du joueur  qui appartient cette
        ADD DI,Nb_Hexa         ;   frontire)
        LOOP @@PremCol

        CALL TEST_JEU          ; On vrifie le reste de la zone de jeu

        MOV DI,Nb_Hexa
        DEC DI
        MOV CX,Nb_Hexa
    @@Test_Rejoint:
        CMP Tableau[DI],AH
        JNE @@PasRejoint       ; Si un des hexagones de la dernire colonne
        MOV Gagne,AL           ;   est marqu, c'est que le joueur a form
        @@PasRejoint:          ;   une chane continue
        ADD DI,Nb_Hexa
        LOOP @@Test_Rejoint
        
        RET

TEST_VERT ENDP

; Test pour le joueur qui doit rejoindre la gauche et la droite de la
;   zone de jeu

TEST_HORIZ PROC

        MOV AL,Joueur         ; Couleur+1 = Hexagone marqu comme faisant
        MOV AH,Joueur         ;   partie de la chane
        INC AH

        MOV Nouv_Hexa,0

        MOV CX,Nb_Hexa
        XOR DI,DI
      @@PremLign:
        CMP Tableau[DI],AL    ; On marque tous les hexagones de la premire
        JNE @@Next            ;   ligne (ceux qui correspondent  la couleur
        INC Tableau[DI]       ;   du joueur  qui appartient cette frontire)
        INC Nouv_Hexa
      @@Next:
        INC DI
        LOOP @@PremLign

        CALL TEST_JEU         ; On vrifie le reste de la zone de jeu

        PUSH AX
        MOV AX,Nb_Hexa
        DEC AX
        MUL Nb_Hexa
        MOV DI,AX
        POP AX
        MOV CX,Nb_Hexa
    @@Test_Rejoint:
        CMP Tableau[DI],AH    ; Si un des hexagones de la dernire ligne
        JNE @@PasRejoint      ;   est marqu, c'est que le joueur a form
        MOV Gagne,AL          ;   une chane continue
        @@PasRejoint:
        INC DI
        LOOP @@Test_Rejoint

        RET

TEST_HORIZ ENDP


;  Ŀ
;Ĵ Test_Jeu 
;  
;     Entre : Tableau[] : Liste des hexagones et leurs "propritaires"
;              Joueur en cours : AL
;     Sortie : Tableau[] est modifi (les cases correspondant aux hexagones
;              contigus sont incrmentes).
;     La fonction met  jour tout le tableau reprenant la liste des
;       hexagones de la zone de jeu.

TEST_JEU PROC

        XOR DI,DI
@@Jeu:
        CMP Tableau[DI],AL        ; Il ne faut marquer l'hexagone que s'il
        JNE @@Autre               ;   ne la pas encore t, et que s'il
                                  ;   appartient au joueur concern
        MOV BX,DI
        DEC BX            ; Si l'hexagone de gauche est marqu, alors il
        PUSH AX           ;   faut marquer celui-ci
        XOR DX,DX
        MOV AX,DI
        DIV Nb_Hexa           ; Si cet hexagone est sur la premire colonne,
        POP AX                ;   on ne doit pas vrifier ce qu'il y a sur sa
        CMP DX,0              ;   gauche
        JE @@Next1
        CMP Tableau[BX],AH
        JNE @@Next1
        INC Tableau[DI]
        INC Nouv_Hexa
        JMP @@Autre
    @@Next1:

        MOV BX,DI
        INC BX                 ; Hexagone de droite
        PUSH AX
        XOR DX,DX
        MOV AX,DI
        INC AX
        DIV Nb_Hexa            ; Si cet hexagone est sur la dernire colonne,
        POP AX                 ;   il ne faut pas vrifier celui qui est  sa
        CMP DX,0               ;   droite
        JE @@Next2
        CMP Tableau[BX],AH
        JNE @@Next2
        INC Tableau[DI]
        INC Nouv_Hexa
        JMP @@Autre
    @@Next2:

        MOV BX,DI
        SUB BX,Nb_Hexa         ; Hexagone suprieur droit
        CMP BX,0
        JL @@Next3             ; Si l'hexagone est sur la premire ligne, il
        CMP Tableau[BX],AH     ;   ne faut pas faire le test
        JNE @@Next3
        INC Tableau[DI]
        INC Nouv_Hexa
        JMP @@Autre
    @@Next3:

        MOV BX,DI
        SUB BX,Nb_Hexa         ; Hexagone suprieur gauche
        DEC BX
        CMP BX,0
        JL @@Next4             ; Si l'hexagone est sur la premire ligne
        PUSH AX                ;   ou sur la premire colonne, il ne faut
        XOR DX,DX              ;   pas faire de test
        MOV AX,DI
        DIV Nb_Hexa
        POP AX
        CMP DX,0
        JE @@Next4
        CMP Tableau[BX],AH
        JNE @@Next4
        INC Tableau[DI]
        INC Nouv_Hexa
        JMP @@Autre
    @@Next4:

        MOV BX,DI
        ADD BX,Nb_Hexa         ; Hexagone infrieur gauche
        PUSH AX
        MOV AX,Nb_Hexa
        MUL Nb_Hexa            ; Si l'hexagine est sur la dernire ligne,
        MOV DX,AX              ;   il ne faut pas faire de test
        POP AX
        CMP BX,DX
        JGE @@Next5
        CMP Tableau[BX],AH
        JNE @@Next5
        INC Tableau[DI]
        INC Nouv_Hexa
        JMP @@Autre
    @@Next5:

        MOV BX,DI
        ADD BX,Nb_Hexa            ; Hexagone infrieur droit
        INC BX
        PUSH AX
        XOR DX,DX
        MOV AX,Nb_Hexa            ; Si l'hexagone est sur la dernire ligne
        MUL Nb_Hexa               ;   ou la dernire colonne, il ne faut pas
        MOV DX,AX                 ;   faire le test
        POP AX
        CMP BX,DX
        JGE @@Next6
        PUSH AX
        XOR DX,DX
        MOV AX,DI
        INC AX
        DIV Nb_Hexa
        POP AX
        CMP DX,0
        JE @@Next6
        CMP Tableau[BX],AH
        JNE @@Next6
        INC Tableau[DI]
        INC Nouv_Hexa
        JMP @@Autre
    @@Next6:

        @@Autre:
        PUSH AX
        MOV AX,Nb_Hexa
        MUL Nb_Hexa
        MOV DX,AX             ; On passe  l'hexagone suivant, et on continue
        POP AX                ;   la boucle si on n'est pas arriv  la fin
        INC DI                ;   de la zone de jeu
        CMP DI,DX
        JL @@Jeu
        RET

TEST_JEU ENDP


;  Ŀ
;Ĵ Efface_Perdant 
;  
;     Entre : Gagnant : 'Gagne' contient la couleur du gagnant
;     Sortie : #aucune#
;     Tous les hexagones du perdant sont effacs (coloris en noir).
;     Les registres sont modifis.

EFFACE_PERDANT PROC

        MOV AX,2         ; On cache le curseur
        INT 33h
        MOV Joueur,0     ; On colorie avec la couleur 0 (noir)
        MOV Hexa_i,0     ; Premire ligne
        XOR DI,DI

    @@Ligne:
        MOV Hexa_j,0     ; Premire colonne

      @@Colonne:
        MOV AL,Gagne
        CMP Tableau[DI],0
        JE @@Next
        CMP Tableau[DI],AL    ; Il ne faut l'effacer que s'il est de la
        JE @@Next             ;   couleur du perdant (non-vide, marqu ou
        INC AL                ;   non)
        CMP Tableau[DI],AL
        JE @@Next
        @@Colorie:
        PUSH DI
        CALL COLORIE_HEXA
        POP DI
        @@Next:
        INC DI
        INC Hexa_j
        MOV AX,Nb_Hexa       ; On ne peut pas utiliser CMP sans registres
        CMP Hexa_j,AX        ;   (on ne peut pas comparer deux zones mmoire)
      JNE @@Colonne

        INC Hexa_i
        MOV AX,Nb_Hexa
        CMP Hexa_i,AX
    JNE @@Ligne

        MOV AX,1         ; On affiche le curseur
        INT 33h
        MOV AL,Couleur1
        MOV AH,Couleur2
        CMP Gagne,AL
        JE @@Change
        MOV Joueur,AL
        JMP @@Continue       ; Pour afficher le carr de couleur du gagnant,
        @@Change:            ;   on met comme joueur actif la couleur du
        MOV Joueur,AH        ;   perdant, et on appelle la fonction qui 
        @@Continue:          ;   passe  l'autre joueur (et qui affiche en
        CALL JOUEUR_SUIVANT  ;   mme temps le carr de couleur)
        RET

EFFACE_PERDANT ENDP


;  Ŀ
;Ĵ Sortie 
;  

SORTIE PROC

        MOV AL,3
        XOR AH,AH
        INT 10h
        MOV AH,9
        LEA DX,Copyright  ; Affichage d'un petit message
        INT 21h
        MOV AX,4C00h
        INT 21h

SORTIE ENDP

END MAIN
