(************************************************************************
 *                                                                      *
 *   BDV2CSV database converter                                         *
 *   (C) 2002 Antoine Potten                                            *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   Uses MyLittleBase components from http://www.mylittlebase.org      *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************)

program bdv2csv;


{$APPTYPE CONSOLE}

uses
  SysUtils,
  mlb2;

var
  Base: TMlb2;
begin
  Writeln('BDV2CSV database converter.');
  Writeln('(C) 2002 Antoine Potten - www.antp.be/software');
  Writeln('This program was made to easily convert BaseDVDivx databases to CSV files,');
  Writeln('but it can be used to convert any MyLittleBase file.');
  Writeln('');
  if ParamCount < 2 then
  begin
    Writeln('Please specify input and output filename.');
    Writeln('You can also specify a separator character');
    Writeln('(if none is specified, ";" will be used)');
    Writeln('');
    Writeln('e.g.:');
    Writeln('bdv2csv.exe catalog.bdv catalog.csv ;');
  end else
  begin
    try
      Base := TMlb2.Create;
      if Base.LoadFromMLBFile(ParamStr(1)) then
      begin
        if (ParamCount > 2) and (Length(ParamStr(3)) > 0) then
          Base.CSVSeparator := ParamStr(3)[1]
        else
          Base.CSVSeparator := ';';
        Base.SaveToCSVFile(ParamStr(2));
        Writeln('Conversion complete.');
      end else
      begin
        Writeln('Cannot load database.');
      end;
    except
      on E: Exception do
        Writeln('Database conversion error: ' + E.Message);
    end;
  end;
end.
