(************************************************************************
 *                                                                      *
 *   Ant Loupe                                                          *
 *   (C) 2002 Antoine Potten                                            *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************)

unit main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ToolWin, ExtCtrls, ImgList, ActnList, AntJvZoom, XPMan;

type
  TMainForm = class(TForm)
    ImageList1: TImageList;
    ActionList1: TActionList;
    ActionActive: TAction;
    CoolBar1: TCoolBar;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolBar2: TToolBar;
    tb10: TToolButton;
    tb25: TToolButton;
    tb50: TToolButton;
    tb100: TToolButton;
    ToolButton2: TToolButton;
    ActionAbout: TAction;
    ToolButton3: TToolButton;
    ActionOptions: TAction;
    ToolButton4: TToolButton;
    StatusBar: TStatusBar;
    ZoomArea: TAntJvZoom;
    ZoomLevel: TTrackBar;
    XPManifest1: TXPManifest;
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ZoomLevelChange(Sender: TObject);
    procedure ActionActiveExecute(Sender: TObject);
    procedure ActionAboutExecute(Sender: TObject);
    procedure ZoomLevelEnter(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ActionOptionsExecute(Sender: TObject);
    procedure ZoomAreaContentsChanged(Sender: TObject);
    procedure ToolBar2Resize(Sender: TObject);
  private
    OnTop: Boolean;
    procedure SetOnTop(State: Boolean);
  public
  end;

var
  MainForm: TMainForm;

implementation

uses
  Inifiles, fAbout, fOptions;

{$R *.dfm}

procedure TMainForm.FormResize(Sender: TObject);
begin
  ZoomArea.Width := ClientWidth;
  ZoomArea.Height := ClientHeight - StatusBar.Height - CoolBar1.Height;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  ZoomArea.Left := 0;
  ZoomArea.Top := CoolBar1.Height;
  with TMemIniFile.Create(ChangeFileExt(ParamStr(0), '.ini')) do
    try
      ZoomLevel.Position := ReadInteger('Zoom', 'Level', 100);
      ActionActive.Checked := not ReadBool('Zoom', 'Active', True);
      ZoomArea.Delay := ReadInteger('Zoom', 'Delay', 100);
      Width := ReadInteger('MainWindow', 'Width', 400);
      Height := ReadInteger('MainWindow', 'Height', 400);
      Left := ReadInteger('MainWindow', 'Left', Screen.Width - Width);
      Top := ReadInteger('MainWindow', 'Top', 0);
      SetOnTop(ReadBool('MainWindow', 'Always on top', True));
      ZoomArea.Crosshair := ReadBool('Zoom', 'Crosshair', True);
      ZoomArea.CrosshairColor := ReadInteger('Zoom', 'CrosshairColor', clBlack);
      ZoomArea.CrosshairSize := ReadInteger('Zoom', 'CrosshairSize', 20);
    finally
      Free;
    end;
  ActionActive.Execute;
  ZoomLevelChange(Self);
  ToolBar2.ButtonWidth := 25;
end;

procedure TMainForm.ZoomLevelChange(Sender: TObject);
begin
  if Sender is TToolButton then
    ZoomLevel.Position := (Sender as TToolbutton).Tag;
  ZoomArea.ZoomLevel := ZoomLevel.Position;
  StatusBar.Panels.Items[0].Text := IntToStr(ZoomLevel.Position);
end;

procedure TMainForm.ActionActiveExecute(Sender: TObject);
begin
  ActionActive.Checked := not ActionActive.Checked;
  ZoomArea.Active := ActionActive.Checked;
end;

procedure TMainForm.ActionAboutExecute(Sender: TObject);
begin
  with TAboutForm.Create(Application) do
    try
      ImageList1.GetIcon(ActionAbout.ImageIndex, Icon);
      ShowModal;
    finally
      Free;
    end;
end;

procedure TMainForm.ZoomLevelEnter(Sender: TObject);
begin
  FocusControl(nil);
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  with TMemIniFile.Create(ChangeFileExt(ParamStr(0), '.ini')) do
    try
      WriteInteger('Zoom', 'Level', ZoomLevel.Position);
      WriteBool('Zoom', 'Active', ActionActive.Checked);
      WriteInteger('Zoom', 'Delay', ZoomArea.Delay);
      WriteInteger('MainWindow', 'Width', Width);
      WriteInteger('MainWindow', 'Height', Height);
      WriteInteger('MainWindow', 'Left', Left);
      WriteInteger('MainWindow', 'Top', Top);
      WriteBool('MainWindow', 'Always on top', OnTop);
      WriteBool('Zoom', 'Crosshair', ZoomArea.Crosshair);
      WriteInteger('Zoom', 'CrosshairColor', ZoomArea.CrosshairColor);
      WriteInteger('Zoom', 'CrosshairSize', ZoomArea.CrosshairSize);
      UpdateFile;
    finally
      Free;
    end;
  ZoomArea.Active := False;
end;

procedure TMainForm.ActionOptionsExecute(Sender: TObject);
begin
  with TOptionsForm.Create(Application) do
    try
      ImageList1.GetIcon(ActionOptions.ImageIndex, Icon);
      edtDelay.Value := ZoomArea.Delay;
      cbxOnTop.Checked := OnTop;
      cbxCrosshair.Checked := ZoomArea.Crosshair;
      lstCrosshairColor.Selected := ZoomArea.CrosshairColor;
      edtCrosshairSize.Value := ZoomArea.CrosshairSize;
      if ShowModal = mrOk then
      begin
        ZoomArea.Delay := edtDelay.Value;
        SetOnTop(cbxOnTop.Checked);
        ZoomArea.Crosshair := cbxCrosshair.Checked;
        ZoomArea.CrosshairColor := lstCrosshairColor.Selected;
        ZoomArea.CrosshairSize := edtCrosshairSize.Value;
      end;
    finally
      Free;
    end;
end;

procedure TMainForm.SetOnTop(State: Boolean);
begin
  OnTop := State;
  if State then
    SetWindowPos(Handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOACTIVATE or SWP_NOMOVE or SWP_NOSIZE)
  else
    SetWindowPos(Handle, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOACTIVATE or SWP_NOMOVE or SWP_NOSIZE);	
end;

procedure TMainForm.ZoomAreaContentsChanged(Sender: TObject);
begin
  StatusBar.Panels.Items[1].Text := Format('%dx%d', [Mouse.CursorPos.X, Mouse.CursorPos.Y]);
end;

procedure TMainForm.ToolBar2Resize(Sender: TObject);
begin
  if ToolBar2.Width > 120 then
    ZoomLevel.Width := ToolBar2.Width - 110
  else
    ZoomLevel.Width := 10;
end;

end.
