(************************************************************************
 *                                                                      *
 *   (C) 2002-2003 Antoine Potten                                       *
 *   software@antp.be - http://www.antp.be/software                     *
 *   antoine@buypin.com - http://www.buypin.com                         *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************)

unit base;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  StdCtrls, ExtCtrls, ComCtrls,

  AntAutoHintLabel, AntCorelButton;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

type
  TBaseDlg = class(TForm)
    Bevel1: TBevel;
    btn1: TCorelButton;
    btn2: TCorelButton;
    btn3: TCorelButton;
    AntAutoHintLabel1: TAntAutoHintLabel;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
  protected
     procedure LoadOptions; virtual;
     procedure LoadOptions2; virtual;
     procedure SaveOptions; virtual;
  public
  end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

implementation

{$R *.dfm}

{$IFDEF USEJVTRANSLATOR}
uses
  Global;
{$ENDIF}

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TBaseDlg.FormShow(Sender: TObject);
begin
  try
    LoadOptions2;
  finally
    Screen.Cursor := crDefault;
  end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TBaseDlg.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SaveOptions;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TBaseDlg.FormCreate(Sender: TObject);
begin
  inherited;
 {$IFDEF USEJVTRANSLATOR}
  Translator.Translate(Self);
 {$ENDIF}
  LoadOptions;
  if WindowState = wsNormal then
  begin
    Position := poOwnerFormCenter;
  end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TBaseDlg.LoadOptions;
begin
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TBaseDlg.LoadOptions2;
begin
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

procedure TBaseDlg.SaveOptions;
begin
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

end.
