(************************************************************************
 *                                                                      *
 *   2do                                                                *
 *   (C) 2000-2002 Antoine Potten                                       *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 *   This program is quite old and the source code is awful, sorry ;)   *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************)
unit options;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls, ExtCtrls, Inifiles, ImgList, FileCtrl,
  TFlatHintUnit, JvBaseDlg, JvBrowseFolder, JvComponent;

type
  TOptionsWin = class(TForm)
    B_OK: TBitBtn;
    B_Cancel: TBitBtn;
    Label2: TLabel;
    E_Title: TEdit;
    Label1: TLabel;
    E_Folder: TEdit;
    Label3: TLabel;
    Bevel1: TBevel;
    RB_ChangeSide: TRadioButton;
    RB_CreateSpace: TRadioButton;
    Label4: TLabel;
    CB_ShowToolbar: TCheckBox;
    CB_ShowText: TCheckBox;
    CB_Flat: TCheckBox;
    Label5: TLabel;
    Bevel2: TBevel;
    Label6: TLabel;
    Bevel3: TBevel;
    CB_DeleteItem: TCheckBox;
    CB_HotTrack: TCheckBox;
    CB_Autoexpand: TCheckBox;
    CB_Order: TCheckBox;
    Bevel4: TBevel;
    SpeedButton1: TSpeedButton;
    FlatHint1: TFlatHint;
    CB_Wordwrap: TCheckBox;
    Label7: TLabel;
    Bevel5: TBevel;
    CB_ExtraIcons: TCheckBox;
    JvSelectDir: TJvBrowseFolder;
    procedure B_OKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure B_ApplyClick(Sender: TObject);
    procedure CB_ShowToolbarClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
     procedure SauveOptions;
     procedure ChargeOptions;
  public
     function ChangeOptions: Integer;
  end;

var
  OptionsWin: TOptionsWin;

implementation

{$R *.DFM}

procedure TOptionsWin.B_OKClick(Sender: TObject);
begin
     SauveOptions;
     if(DirectoryExists(E_Folder.Text)) then
     begin
          ModalResult:=mrOk;
     end else begin
          if MessageDlg('The folder entered doesn''t exist, do you want to '
               +'create it ?',mtConfirmation, [mbYes,mbNo],0) = mrYes then
          begin
               if(CreateDir(E_Folder.Text)=false) then
               begin
                    MessageDlg('Cannot create folder "'+E_Folder.Text+'"',
                         mtError, [mbOk],0);
               end else begin
                    ModalResult:=mrOk;
               end;
          end;
     end;
end;

procedure TOptionsWin.SauveOptions;
var
     INI : TIniFile;
begin
     INI:=TIniFile.Create(ChangeFileExt(Application.ExeName,'.ini'));
     INI.WriteString('General','Folder',E_Folder.Text);
     INI.WriteString('General','Title',E_Title.Text);
     INI.WriteBool('General','ExtraIcons',CB_ExtraIcons.Checked);
     INI.WriteBool('Toolbar','ShowToolbar',CB_ShowToolbar.Checked);
     INI.WriteBool('Toolbar','ShowText',CB_ShowText.Checked);
     INI.WriteBool('Toolbar','Flat',CB_Flat.Checked);
     INI.WriteBool('Item','ConfirmDeleteItem',CB_DeleteItem.Checked);
     INI.WriteBool('Item','HotTrack',CB_HotTrack.Checked);
     INI.WriteBool('Item','Autoexpand',CB_Autoexpand.Checked);
     INI.WriteBool('Item','Order',CB_Order.Checked);
     INI.Writebool('Edit','Wordwrap',CB_Wordwrap.Checked);
     INI.WriteBool('Edit','TabSpace',RB_CreateSpace.Checked);
     INI.Destroy;
end;

procedure TOptionsWin.ChargeOptions;
var
     INI : TIniFile;
begin
     INI:=TIniFile.Create(ChangeFileExt(Application.ExeName,'.ini'));
     E_Folder.Text:=INI.ReadString('General','Folder',
          ExtractFileDir(Application.ExeName));
     E_Title.Text:=INI.ReadString('General','Title','2do');
     CB_ExtraIcons.Checked:=INI.ReadBool('General','ExtraIcons',true);
     RB_ChangeSide.Checked:= NOT INI.ReadBool('Edit','TabSpace',false);
     CB_Wordwrap.Checked:=INI.ReadBool('Edit','Wordwrap',true);
     CB_ShowToolbar.Checked:=INI.ReadBool('Toolbar','ShowToolbar',true);
     CB_ShowText.Checked:=INI.ReadBool('Toolbar','ShowText',false);
     CB_Flat.Checked:=INI.ReadBool('Toolbar','Flat',true);
     CB_ShowText.Enabled:=CB_ShowToolbar.Checked;
     CB_Flat.Enabled:=CB_ShowToolbar.Checked;
     CB_DeleteItem.Checked:=INI.ReadBool('Item','ConfirmDeleteItem',true);
     CB_HotTrack.Checked:=INI.ReadBool('Item','HotTrack',false);
     CB_Autoexpand.Checked:=INI.ReadBool('Item','Autoexpand',false);
     CB_Order.Checked:=INI.ReadBool('Item','Order',false);
     INI.Destroy;
end;

function TOptionsWin.ChangeOptions: Integer;
begin
     ChargeOptions;
     ChangeOptions:=self.ShowModal;
end;

procedure TOptionsWin.FormCreate(Sender: TObject);
begin
     ChargeOptions;
end;

procedure TOptionsWin.B_ApplyClick(Sender: TObject);
begin
     SauveOptions;
end;

procedure TOptionsWin.CB_ShowToolbarClick(Sender: TObject);
begin
     CB_ShowText.Enabled:=CB_ShowToolbar.Checked;
     CB_Flat.Enabled:=CB_ShowToolbar.Checked;
end;


procedure TOptionsWin.FormShow(Sender: TObject);
begin
     E_Title.SetFocus;
end;

procedure TOptionsWin.SpeedButton1Click(Sender: TObject);
{var
     Dir: AnsiString;}
begin
{     Dir:=E_Folder.Text;
     if SelectDirectory(Dir, [sdAllowCreate, sdPerformCreate, sdPrompt],0) then
          E_Folder.Text := Dir;}
     jvselectdir.directory:=e_folder.text;
     if jvselectdir.Execute then e_folder.Text := jvselectdir.Directory;
end;

end.
