(************************************************************************
 *                                                                      *
 *   2do                                                                *
 *   (C) 2000-2002 Antoine Potten                                       *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 *   This program is quite old and the source code is awful, sorry ;)   *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************)
unit new;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ExtCtrls, ExtDlgs, ComCtrls;

type

  TNewItemWin = class(TForm)
    B_OK: TBitBtn;
    B_Cancel: TBitBtn;
    GroupBox1: TGroupBox;
    E_Name: TEdit;
    RB_Sub: TRadioButton;
    RB_Root: TRadioButton;
    Label1: TLabel;
    Label2: TLabel;
    E_Parent: TEdit;
    procedure B_OKClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure RB_RootClick(Sender: TObject);
    procedure RB_SubClick(Sender: TObject);
  private
     OldName: AnsiString;
     Path: AnsiString;
     Parentitem: string;
  public
     function ShowWin(FilePath: AnsiString; Name: AnsiString;
          parentitemparam: string): integer;
  end;

var
  NewItemWin: TNewItemWin;

implementation

{$R *.DFM}

function TNewItemWin.ShowWin(FilePath: AnsiString; Name: AnsiString;
          parentitemparam: string): integer;
begin
     parentitem:=parentitemparam;
     if(parentitem='') then
     begin
          RB_Sub.Enabled:=false;
          RB_Root.Checked:=true;
     end else begin
          RB_Sub.Enabled:=true;
          RB_Sub.Checked:=true;
     end;
     if(Name='') then
     begin
          Caption:='New Item / Subitem';
          RB_Root.Enabled:=true;
     end else begin
          Caption:='Change Item / Subitem properties';
          RB_Root.Enabled:=false;
          RB_Sub.Enabled:=false;
     end;
     E_Parent.Text:=parentitem;
     OldName:=Name;
     E_Name.Text:=Name;
     Path:=FilePath;
     ShowWin:=ShowModal;
end;

procedure TNewItemWin.B_OKClick(Sender: TObject);
var
     FileHandle: integer;
begin
     if(E_Name.Text='') then
     begin
          MessageDlg('Please enter a name',mtWarning,[mbOk],0)
     end else begin
          if FileExists(Path+'\'+E_Name.Text+'.2do') then
          begin
               MessageDlg('An item with this name already exists. Two '
                    +'items cannot have the same name',mtWarning,[mbOk],0)
          end else begin
               if(OldName='') then
               begin
                    FileHandle:=FileCreate(Path+'\'+E_Name.Text+'.2do');
                    if(FileHandle = -1) then
                         MessageDlg('The item name must be a valid file name, '
                         +'so it cannot contain \ / : * ? " < > |',
                         mtWarning,[mbOk],0)
                    else begin
                         FileClose(FileHandle);
                         if(RB_Root.Checked=true) then ModalResult:=mrOk
                         else ModalResult:=mrYes;
                    end;
               end else begin
                    SetCurrentDir(Path);
                    if RenameFile(OldName+'.2do',E_Name.Text+'.2do')=false then
                         MessageDlg('Cannot rename this item. Its name must be '
                              +'a valid file name, so it cannot contain \ / : '
                              +'* ? " < > |',
                         mtWarning,[mbOk],0)
                    else begin
                         if(RB_Root.Checked=true) then ModalResult:=mrOk
                         else ModalResult:=mrYes;
                    end;

               end;
          end;
     end;
     E_Name.SetFocus;
     E_Name.SelectAll;
end;

procedure TNewItemWin.FormShow(Sender: TObject);
begin
     E_Name.SetFocus;
     E_Name.SelectAll;
end;

procedure TNewItemWin.RB_RootClick(Sender: TObject);
begin
     E_Parent.text:='';
end;

procedure TNewItemWin.RB_SubClick(Sender: TObject);
begin
     E_Parent.text:=Parentitem;
end;

end.
