(************************************************************************
 *                                                                      *
 *   2do                                                                *
 *   (C) 2000-2002 Antoine Potten                                       *
 *   software@antp.be - http://www.antp.be/software                     *
 *                                                                      *
 *   This program is quite old and the source code is awful, sorry ;)   *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************)
unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ExtCtrls, ComCtrls, Buttons, ToolWin, StdCtrls, ImgList, Inifiles,
  ActnList, JvTrayIcon, JvFormButton, TFlatHintUnit, JvComponent;

// =============================================================================

type
  TMainWin = class(TForm)
    TreeView1: TTreeView;
    Splitter1: TSplitter;
    ImageList1: TImageList;
    ImageList2: TImageList;
    M_Contents: TMemo;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    PopupMenu1: TPopupMenu;
    M_NewItem: TMenuItem;
    M_ItemProperties: TMenuItem;
    M_DeleteItem: TMenuItem;
    MenuItem5: TMenuItem;
    M_Options: TMenuItem;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    M_Hide: TMenuItem;
    JvTrayIcon: TJvTrayIcon;
    JvFormButton1: TJvFormButton;
    ToolButton2: TToolButton;
    ToolButton11: TToolButton;
    ActionList1: TActionList;
    ActionNewItem: TAction;
    ActionItemProperties: TAction;
    ActionDeleteItem: TAction;
    ActionSaveItem: TAction;
    FlatHint1: TFlatHint;
    ActionOptions: TAction;
    ActionAbout: TAction;
    ActionAlwaysOnTop: TAction;
    ActionHide: TAction;
    ActionExit: TAction;
    Alwaysontop1: TMenuItem;
    JvFormButton2: TJvFormButton;
    ToolButton12: TToolButton;
    ActionUndo: TAction;
    procedure M_AboutClick(Sender: TObject);
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TreeView1Deletion(Sender: TObject; Node: TTreeNode);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure M_ContentsEnter(Sender: TObject);
    procedure TreeView1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure TreeView1EndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure ActionNewItemExecute(Sender: TObject);
    procedure ActionItemPropertiesExecute(Sender: TObject);
    procedure ActionDeleteItemExecute(Sender: TObject);
    procedure ActionSaveItemExecute(Sender: TObject);
    procedure ActionAlwaysOnTopExecute(Sender: TObject);
    procedure ActionHideExecute(Sender: TObject);
    procedure ActionOptionsExecute(Sender: TObject);
    procedure ActionAboutExecute(Sender: TObject);
    procedure ActionExitExecute(Sender: TObject);
    procedure JvFormButton2Click(Sender: TObject);
    procedure ActionUndoExecute(Sender: TObject);
    procedure TreeView1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure JvTrayIconDblClick(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
     Path: AnsiString;
     PreviousItem: AnsiString;
     Modified: Boolean;
     Closing: Boolean;
     procedure AddNewItem(parentitem: string);
     procedure ItemProperties;
     procedure DeleteItem;
     procedure ChangeOptions;
     procedure SaveTree;
     procedure LoadNewItem;
     procedure SaveOldItem;
     procedure ApplyOptions;
     procedure ItemChanged(bState: boolean);
     procedure ChangeItem;
  public
  end;

var
  MainWin: TMainWin;

implementation

uses new, options, about;

{$R *.DFM}

// =============================================================================

procedure TMainWin.ChangeItem;
begin
     SaveOldItem;
     M_Contents.Clear;
     if(TreeView1.Selected = nil) then
     begin
          M_Contents.Enabled:=false;
          M_Contents.Color:=clBtnFace;
     end else begin
          M_Contents.Enabled:=true;
          M_Contents.Color:=clWindow;
          LoadNewItem;
     end;
end;

procedure TMainWin.ItemChanged(bState: boolean);
begin
     ActionSaveItem.enabled:=bState;
     actionundo.enabled:=bstate;
     modified:=bstate;
end;

procedure TMainWin.AddNewItem(parentitem: string);
var
     newnode : TTreeNode;
     parentNode: TTreeNode;
     NewItemWinResult: TModalResult;
begin
     NewItemWinResult:=NewItemWin.ShowWin(Path,'',parentitem);
     if((NewItemWinResult = mrOk) OR (NewItemWinResult = mrYes)) then
     begin
          if NewItemWinResult = mrOk then parentItem:='';
          if parentitem='' then
          begin
               newnode:=TTreeNode.Create(treeview1.items);
//                    newnode.ImageIndex:=ImageList1.Add(NewItemWin.Image1.Picture.Bitmap,nil);
               newnode.ImageIndex:=0;
               TreeView1.Items.Add(newnode,NewItemWin.E_Name.Text);
               newnode.Destroy;
          end else begin
               parentNode:=TreeView1.Selected;
               if parentNode <> nil then
               begin
                    newnode:=TreeView1.Items.AddChild(parentNode,NewItemWin.E_Name.Text);
//                         newnode.ImageIndex:=ImageList1.Add(NewItemWin.Image1.Picture.Bitmap,nil);
                    newnode.ImageIndex:=0;
                    parentNode.Expand(false);
               end;
          end;
     end;
     SaveTree;

     TreeView1.Refresh;
     Application.ProcessMessages;
end;

procedure TMainWin.ItemProperties;
var
     parentitem:string;
begin
     if(TreeView1.Selected = nil) then
     begin
          MessageDlg('No item selected',mtError,[mbOK],0);
     end else begin
          if(TreeView1.Selected.Parent = nil) then parentitem:=''
          else parentitem:=TreeView1.Selected.Parent.Text;
          if(NewItemWin.ShowWin(Path,TreeView1.Selected.Text,parentitem) <> mrCancel) then
          begin
//               TreeView1.Selected.ImageIndex:=ImageList1.Add(NewItemWin.Image1.Picture.Bitmap,nil);
               TreeView1.Selected.Text:=NewItemWin.E_Name.Text;
               PreviousItem:=TreeView1.Selected.Text;
               Application.ProcessMessages;
               SaveTree;
          end;
     end;
     TreeView1.Refresh;
     Application.ProcessMessages;
end;

procedure TMainWin.DeleteItem;
var
     Item2Delete: TTreeNode;
     CanDelete: boolean;
begin
     Item2Delete:=TreeView1.Selected;
     CanDelete:=false;
     if(TreeView1.Selected = nil) then
     begin
          MessageDlg('No item selected',mtError,[mbOK],0);
     end else begin
          if(OptionsWin.CB_DeleteItem.Checked=true) then
          begin
               if(MessageDlg('This will delete the item "'+Item2Delete.Text
                    +'" and all its subitems',mtConfirmation,
                    [mbOk,mbCancel],0)=mrOk) then CanDelete:=true;
          end else CanDelete:=true;
          if CanDelete=true then
          begin
               PreviousItem:='';
               Item2Delete.Delete;
               SaveTree;
          end;
     end;
     TreeView1.Refresh;
     Application.ProcessMessages;
end;

procedure TMainWin.ChangeOptions;
begin
     if (OptionsWin.ChangeOptions = mrOK) then ApplyOptions;
end;

procedure TMainWin.SaveTree;
begin
     TreeView1.SaveToFile(Path+'\[tree]');
end;

procedure TMainWin.SaveOldItem;
begin
     if((PreviousItem <> '') AND (Modified=true)) then
     begin
          if(FileExists(Path+'\'+PreviousItem+'.2do')) then
          begin
               M_Contents.Lines.SaveToFile(Path+'\'+PreviousItem+'.2do');
          end else begin
               if MessageDlg('Cannot find the file corresponding to this item, '
               +'do you want to save it anyway (there may be problems later '
               +'with this item) ?',mtConfirmation,[mbYes,mbNo],0) = mrYes then
               M_Contents.Lines.SaveToFile(Path+'\'+PreviousItem+'.2do');
          end;
     end;
end;

procedure TMainWin.LoadNewItem;
begin
     PreviousItem:=TreeView1.Selected.Text;
     if(FileExists(Path+'\'+PreviousItem+'.2do')) then
     begin
          M_Contents.Lines.LoadFromFile(Path+'\'+PreviousItem+'.2do');
     end else begin
          if MessageDlg('Cannot find the file corresponding to this item. Do you want to recreate it ?',
               mtError,[mbYes, mbNo],0) = mrYes then
                    M_Contents.Lines.SaveToFile(Path+'\'+PreviousItem+'.2do');
          begin
          end;
     end;
     ItemChanged(false);
end;

procedure TMainWin.ApplyOptions;
begin
     Path := OptionsWin.E_Folder.Text;
     Toolbar1.Visible := OptionsWin.CB_ShowToolbar.Checked;
     Toolbar1.ShowHint := NOT OptionsWin.CB_ShowText.Checked;
     Toolbar1.ShowCaptions := OptionsWin.CB_ShowText.Checked;
     Toolbar1.Flat := OptionsWin.CB_Flat.Checked;
     Toolbar1.ButtonHeight:=0;
     Toolbar1.ButtonWidth:=0;
     Caption:=OptionsWin.E_Title.Text;
     Application.Title:=Caption;
     JvTrayIcon.Hint:=Caption;
     JvFormButton1.Visible:=OptionsWin.CB_ExtraIcons.Checked;
     JvFormButton2.Visible:=OptionsWin.CB_ExtraIcons.Checked;
     TreeView1.HotTrack:=OptionsWin.CB_HotTrack.Checked;
     TreeView1.AutoExpand:=OptionsWin.CB_Autoexpand.Checked;
     if(OptionsWin.CB_Order.Checked) then TreeView1.SortType:=stText else TreeView1.SortType:=stNone;
     M_Contents.WantTabs:=OptionsWin.RB_CreateSpace.Checked;
     if OptionsWin.CB_Wordwrap.Checked then
     begin
          M_Contents.WordWrap:=true;
          M_Contents.ScrollBars:=ssVertical;
     end else begin
          M_Contents.WordWrap:=false;
          M_Contents.ScrollBars:=ssBoth;
     end;
     TreeView1.Refresh;
end;

// =============================================================================

procedure TMainWin.M_AboutClick(Sender: TObject);
begin
end;

// =============================================================================
procedure TMainWin.TreeView1Change(Sender: TObject; Node: TTreeNode);
begin
     ChangeItem;
end;

procedure TMainWin.FormShow(Sender: TObject);
begin
     ApplyOptions;
     if FileExists(Path+'\[tree]') then
     begin
          TreeView1.LoadFromFile(Path+'\[tree]');
     end else if FileExists(Path+'\tree.2do') then
     begin
          TreeView1.LoadFromFile(Path+'\tree.2do');
     end;
     TreeView1.Refresh;
     Application.ProcessMessages;
end;

procedure TMainWin.FormCreate(Sender: TObject);
var
     INI : TIniFile;
begin
     INI:=TIniFile.Create(ChangeFileExt(Application.ExeName,'.ini'));
     Width:=INI.ReadInteger('MainWindow','Width',600);
     Height:=INI.ReadInteger('MainWindow','Height',400);
     INI.Destroy;
     PreviousItem:='';
     Path:='';
     ItemChanged(false);
     Closing:=false;
end;

procedure TMainWin.TreeView1Deletion(Sender: TObject; Node: TTreeNode);
begin
     if Closing=false then DeleteFile(Path+'\'+Node.Text+'.2do');
end;

procedure TMainWin.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
     INI : TIniFile;
begin
     if WindowState = wsNormal then
     begin
          INI:=TIniFile.Create(ChangeFileExt(Application.ExeName,'.ini'));
          INI.WriteInteger('MainWindow','Width',Width);
          INI.WriteInteger('MainWindow','Height',Height);
          INI.Destroy;
     end;
     SaveTree;
     SaveOldItem;
     Closing:=true;
     CanClose:=true;
end;

procedure TMainWin.M_ContentsEnter(Sender: TObject);
begin
     ItemChanged(true);
end;

procedure TMainWin.TreeView1DragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
     Accept:=true;
end;

procedure TMainWin.TreeView1EndDrag(Sender, Target: TObject; X,
  Y: Integer);
begin
     if((Sender <> nil) AND (Target <> nil)) then
     begin
          if(Target.ClassNameIs('TTreeView') AND Sender.ClassNameIs('TTreeView')) then
          begin
               if((Target as TTreeView).GetNodeAt(X,Y) <> nil) then
               begin
                    (Sender as TTreeView).Selected.MoveTo(
                         (Target as TTreeView).GetNodeAt(X,Y),naInsert);
                    SaveTree;
               end else begin
                    (Sender as TTreeView).Selected.MoveTo((Sender as TTreeView).Selected,naAdd);
               end;
          end;
     end;
end;

procedure TMainWin.ActionNewItemExecute(Sender: TObject);
var
     parentitem: string;
begin
     if TreeView1.Selected = nil then parentitem:= ''
     else parentitem:=TreeView1.Selected.Text;
     AddNewItem(parentitem);
end;

procedure TMainWin.ActionItemPropertiesExecute(Sender: TObject);
begin
     ItemProperties;
end;

procedure TMainWin.ActionDeleteItemExecute(Sender: TObject);
begin
     DeleteItem;
end;

procedure TMainWin.ActionSaveItemExecute(Sender: TObject);
begin
     SaveOldItem;
end;

procedure TMainWin.ActionAlwaysOnTopExecute(Sender: TObject);
begin
     Closing:=true;
     if ToolButton2.Down then
     begin
          JvFormButton1.Visible:=false;
          JvFormButton2.Visible:=false;
          FormStyle:=fsStayontop;
     end else begin
          FormStyle:=fsNormal;
          JvFormButton1.Visible:=OptionsWin.CB_ExtraIcons.Checked;
          JvFormButton2.Visible:=OptionsWin.CB_ExtraIcons.Checked;
     end;
     Closing:=false;
end;

procedure TMainWin.ActionHideExecute(Sender: TObject);
begin
     Closing:=true;
     JvTrayIcon.Active:=true;
     Visible:=false;
end;

procedure TMainWin.ActionOptionsExecute(Sender: TObject);
begin
     ChangeOptions;
end;

procedure TMainWin.ActionAboutExecute(Sender: TObject);
begin
     AboutWin.ShowModal;
end;

procedure TMainWin.ActionExitExecute(Sender: TObject);
begin
     Close
end;

procedure TMainWin.JvFormButton2Click(Sender: TObject);
begin
     ToolButton2.Down := not ToolButton2.Down;
     ActionAlwaysOnTop.Execute;
end;

procedure TMainWin.ActionUndoExecute(Sender: TObject);
begin
     LoadNewItem;
end;

procedure TMainWin.TreeView1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     if Button = mbRight then
     begin
          ChangeItem;
          Treeview1.Selected:=Treeview1.GetNodeAt(x,y);
     end else begin
          if treeview1.GetNodeAt(x,y) = nil then
          begin
               ChangeItem;
               Treeview1.Selected:=nil;
          end;
     end;
end;
procedure TMainWin.JvTrayIconDblClick(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     Visible:=true;
     JvTrayIcon.Active:=false;
     Closing:=false;
end;

end.

