{-------------------------------------------------------------------------------

The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is "NameSpace.pas" released at June 12nd, 2007.

The Initial Developer of the Original Code is

  Priyatna
  Website: http://www.priyatna.org
  Email: me@priyatna.org
  Copyright (c) 2007-2008 Priyatna
  All Rights Reserved.

Contributor(s): -

Description: Name space handler for embedded webbrowser.

Known Issues: -

Last Modified: 2008-07-24

-------------------------------------------------------------------------------}

unit NameSpace;

interface

uses
  Classes, Windows, Forms, Axctrls, SysUtils, ComObj, ActiveX, UrlMon, ComServ;

const
  NameSpaceProtocol = 'movie';

type
  TNameSpaceProc = procedure (Sender: TObject; Url: WideString;
    Stream: TMemoryStream; var Size: LongInt; var Found: Boolean) of object;

  procedure RegisterNameSpace(Handler: TNameSpaceProc);
  procedure UnregisterNameSpace;

implementation

const
  Class_MovieNameSpace: TGUID = '{54E8CF35-93E6-490E-AB05-D0F925067FDD}';

type
  TMovieNameSpace = class(TComObject, IInternetProtocol)
  private
    FStream: TMemoryStream;
    ReleaseStream: Boolean;
    Written, TotalSize: Integer;
    ProtSink: IInternetProtocolSink;
    DataStream: IStream;
  protected
    // IInternetProtocol Methods
    function Start(szUrl: PWideChar; OIProtSink: IInternetProtocolSink;
      OIBindInfo: IInternetBindInfo; grfPI, dwReserved: DWORD): HResult; stdcall;
    function Continue(const ProtocolData: TProtocolData): HResult; stdcall;
    function Abort(hrReason: HResult; dwOptions: DWORD): HResult; stdcall;
    function Terminate(dwOptions: DWORD): HResult; stdcall;
    function Suspend: HResult; stdcall;
    function Resume: HResult; stdcall;
    function Read(pv: Pointer; cb: ULONG; out cbRead: ULONG): HResult; stdcall;
    function Seek(dlibMove: LARGE_INTEGER; dwOrigin: DWORD;
      out libNewPosition: ULARGE_INTEGER): HResult; stdcall;
    function LockRequest(dwOptions: DWORD): HResult; stdcall;
    function UnlockRequest: HResult; stdcall;
  public
    procedure Initialize; override;
    destructor Destroy; override;
  end;

var
  HttpFactory: IClassFactory;
  InternetSession: IInternetSession;
  ProtocolHandler: TNameSpaceProc = nil;

procedure RegisterNameSpace(Handler: TNameSpaceProc);
begin
  ProtocolHandler := Handler;
  CoGetClassObject(Class_MovieNameSpace, CLSCTX_SERVER, nil, IClassFactory, HttpFactory);
  CoInternetGetSession(0, InternetSession, 0);
  InternetSession.RegisterNameSpace(HttpFactory, Class_MovieNameSpace, NameSpaceProtocol, 0, nil, 0);
end;

procedure UnregisterNameSpace;
begin
  InternetSession.UnregisterNameSpace(HttpFactory, NameSpaceProtocol);
end;

{ TMovieNameSpace }

procedure TMovieNameSpace.Initialize;
begin
  inherited Initialize;
  FStream := TMemoryStream.Create;
end;

destructor TMovieNameSpace.Destroy;
begin
  FStream.Free;
  inherited Destroy;
end;

function TMovieNameSpace.Start(szUrl: PWideChar; OIProtSink: IInternetProtocolSink;
  OIBindInfo: IInternetBindInfo; grfPI, dwReserved: DWORD): HResult; stdcall;
var
  Dummy: Int64;
  Size: Integer;
  Found: Boolean;
begin
  ReleaseStream := False;
  FStream.Clear;
  Size := 0;
  Found := False;
  if Assigned(ProtocolHandler)
    then ProtocolHandler(Self, szUrl, FStream, Size, Found);
  if Found then
  begin
    ProtSink := OIProtSink;
    Written := 0;
    FStream.Position := 0;
    CreateStreamOnHGlobal(0, True, DataStream);
    TOleStream.Create(DataStream).CopyFrom(FStream, FStream.Size);
    DataStream.Seek(0, STREAM_SEEK_SET, Dummy);
    TotalSize := FStream.Size;
    ReleaseStream := True;
    ProtSink.ReportData(BSCF_FIRSTDATANOTIFICATION or BSCF_LASTDATANOTIFICATION
      or BSCF_DATAFULLYAVAILABLE, TotalSize, TotalSize);
    ProtSink.ReportResult(S_OK, S_OK, nil);
    Result := S_OK;
  end else
    Result := INET_E_OBJECT_NOT_FOUND;
end;

function TMovieNameSpace.Read(pv: Pointer; cb: ULONG; out cbRead: ULONG): HResult;
begin
  DataStream.Read(pv, cb, @cbRead);
  Inc(Written, cbread);
  if (Written = TotalSize) then
    Result := S_FALSE
  else
    Result := HResult(E_PENDING);
end;

function TMovieNameSpace.Terminate(dwOptions: DWORD): HResult; stdcall;
begin
  if ReleaseStream then
  begin
    DataStream._Release;
    Protsink._Release;
  end;
  Result := S_OK;
end;

function TMovieNameSpace.LockRequest(dwOptions: DWORD): HResult; stdcall;
begin
  Result := S_OK;
end;

function TMovieNameSpace.UnlockRequest: HResult;
begin
  Result := S_OK;
end;

function TMovieNameSpace.Continue(const ProtocolData: TProtocolData): HResult;
begin
  Result := S_OK;
end;

function TMovieNameSpace.Abort(hrReason: HResult; dwOptions: DWORD): HResult; stdcall;
begin
  Result := E_NOTIMPL;
end;

function TMovieNameSpace.Suspend: HResult; stdcall;
begin
  Result := E_NOTIMPL;
end;

function TMovieNameSpace.Resume: HResult; stdcall;
begin
  Result := E_NOTIMPL;
end;

function TMovieNameSpace.Seek(dlibMove: LARGE_INTEGER; dwOrigin: DWORD;
  out libNewPosition: ULARGE_INTEGER): HResult;
begin
  Result := E_NOTIMPL;
end;

initialization

  TComObjectFactory.Create(ComServer, TMovieNameSpace, Class_MovieNameSpace,
    'Movie Namespace', 'Movie Namespace', ciMultiInstance, tmApartment);

end.

