(************************************************************************
 *                                                                      *
 *   Ant Movie Catalog 4.x                                              *
 *   (C) 2000-2011 Antoine Potten, Mickal Vanneufville                 *
 *   http://www.antp.be/software                                        *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This file can be used freely in any program, even if it is not     *
 *   opensource or if it is commercial. It can be used only to provide  *
 *   compatibility with Ant Movie Catalog files, for importation for    *
 *   example. A mention to the origin of this code and eventually       *
 *   a link to Ant Movie Catalog website somewhere in the about box,    *
 *   help file or documentation would be appreciated.                   *
 *   Like for the GPL-licensed files, this file is distributed WITHOUT  *
 *   ANY WARRANTY.                                                      *
 *                                                                      *
 *   To compile fields.pas and movieclass.pas in any project,           *
 *   you have to define "DLLMode" either in project options or          *
 *   directly in these two files.                                       *
 *                                                                      *
 *   Alternatively, this can be used under GPL license:                 *
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************)

unit fields;

interface

uses
  Sysutils, Classes, Graphics;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

const
  fieldLow             =  0;

  fieldNumber          =  0;
  fieldChecked         =  1;
  fieldMedia           =  2;
  fieldMediaType       =  3;
  fieldSource          =  4;
  fieldDate            =  5;
  fieldBorrower        =  6;
  fieldRating          =  7;
  fieldOriginalTitle   =  8;
  fieldTranslatedTitle =  9;
  fieldFormattedTitle  = 10;
  fieldDirector        = 11;
  fieldProducer        = 12;
  fieldCountry         = 13;
  fieldCategory        = 14;
  fieldYear            = 15;
  fieldLength          = 16;
  fieldActors          = 17;
  fieldURL             = 18;
  fieldDescription     = 19;
  fieldComments        = 20;
  fieldVideoFormat     = 21;
  fieldVideoBitrate    = 22;
  fieldAudioFormat     = 23;
  fieldAudioBitrate    = 24;
  fieldResolution      = 25;
  fieldFrameRate       = 26;
  fieldLanguages       = 27;
  fieldSubtitles       = 28;
  fieldSize            = 29;
  fieldDisks           = 30;
  fieldColorTag        = 31;

  fieldCount           = 32;

  fieldPicture         = 99;
  
  customFieldLow       = 100;
  customFieldMax       = 255; // should be enough...

type
  TMovieField = fieldLow..customFieldMax-1;
  TMovieFields = set of TMovieField;

const
  AllFields: TMovieFields = [fieldLow..FieldCount-1];
  AllCustomFields: TMovieFields = [customFieldLow..customFieldMax-1];
  VirtualFields: TMovieFields = [fieldFormattedTitle];
  OrigonFields: TMovieFields = [fieldNumber, fieldMedia, fieldMediaType, fieldSource,
    fieldDate, fieldBorrower, fieldRating, fieldOriginalTitle, fieldTranslatedTitle,
    fieldDirector, fieldProducer, fieldCountry, fieldCategory, fieldYear, fieldLength,
    fieldActors, fieldURL, fieldDescription, fieldComments, fieldVideoFormat, fieldVideoBitrate,
    fieldAudioFormat, fieldAudioBitrate, fieldResolution, fieldFrameRate, fieldLanguages,
    fieldSubtitles, fieldSize, fieldDisks];
var
  GroupByFields: TMovieFields;
  GroupByFieldsMulti: TMovieFields;
  GroupByFieldsMultiDefaultRmP: TMovieFields;
  SortByFields: TMovieFields;

const
  strTagFields: array [fieldLow..fieldCount-1] of string = (
    'Number',
    'Checked',
    'MediaLabel',
    'MediaType',
    'Source',
    'Date',
    'Borrower',
    'Rating',
    'OriginalTitle',
    'TranslatedTitle',
    'FormattedTitle',
    'Director',
    'Producer',
    'Country',
    'Category',
    'Year',
    'Length',
    'Actors',
    'URL',
    'Description',
    'Comments',
    'VideoFormat',
    'VideoBitrate',
    'AudioFormat',
    'AudioBitrate',
    'Resolution',
    'Framerate',
    'Languages',
    'Subtitles',
    'Size',
    'Disks',
    'ColorTag'
  );

const
  strTagFieldPicture = 'Picture';

{$IFNDEF DLLMode}
var
  strFields: TStrings;
  strFieldPicture: string;

const
  strTagSqlFields: array [0..fieldCount-1] of string = (
    'NUM',
    'CHECKED',
    'MEDIA',
    'MEDIATYPE',
    'SOURCE',
    'DATEADD',
    'BORROWER',
    'RATING',
    'ORIGINALTITLE',
    'TRANSLATEDTITLE',
    'FORMATTEDTITLE',
    'DIRECTOR',
    'PRODUCER',
    'COUNTRY',
    'CATEGORY',
    'YEAR',
    'LENGTH',
    'ACTORS',
    'URL',
    'DESCRIPTION',
    'COMMENTS',
    'VIDEOFORMAT',
    'VIDEOBITRATE',
    'AUDIOFORMAT',
    'AUDIOBITRATE',
    'RESOLUTION',
    'FRAMERATE',
    'LANGUAGES',
    'SUBTITLES',
    'FILESIZE',
    'DISKS',
    'COLORTAG'
  );

const
  strSqlFieldPicture = 'PICTURENAME';
{$ENDIF}

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

implementation

{$IFNDEF DLLMode}
  uses Global;
{$ENDIF}

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

initialization
  GroupByFields := AllFields;// - [fieldURL, fieldDescription, fieldComments];
  GroupByFieldsMulti := [fieldMediaType, fieldSource,
    fieldDirector, fieldProducer, fieldCountry, fieldCategory, fieldActors,
    fieldVideoFormat, fieldAudioFormat, fieldLanguages, fieldSubtitles];
  GroupByFieldsMultiDefaultRmP := [fieldActors];
  SortByFields := AllFields;
end.




