{-------------------------------------------------------------------------------

The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is "UnitSettings.pas" released at June 12nd, 2007.

The Initial Developer of the Original Code is

  Priyatna
  Website: http://www.priyatna.org
  Email: me@priyatna.org
  Copyright (c) 2007-2008 Priyatna
  All Rights Reserved.

Contributor(s):
  - Alexander Herz <aherz.kazan@arcor.de>, search feature and improvements.

Description: Settings form.

Known Issues: -

Last Modified: 2008-07-24

-------------------------------------------------------------------------------}

unit UnitSettings;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Buttons, Menus, jpeg, ExtCtrls, ShellAPI,
  Spin, NiceGrid, Math;

type
  TFormSettings = class(TForm)
    PageControl1: TPageControl;
    TabGeneral: TTabSheet;
    TabTemplate: TTabSheet;
    BtnOk: TButton;
    BtnCancel: TButton;
    TabSheet2: TTabSheet;
    BtnApply: TButton;
    MemoTemplate: TMemo;
    Label4: TLabel;
    BtnInsert: TSpeedButton;
    PopupMenu1: TPopupMenu;
    Panel1: TPanel;
    Image1: TImage;
    Label7: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label8: TLabel;
    Shape1: TShape;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    TabSecurity: TTabSheet;
    Label1: TLabel;
    ComboSchemes: TComboBox;
    Label5: TLabel;
    ComboDate: TComboBox;
    Label6: TLabel;
    EditDateSample: TEdit;
    CheckFullScreen: TCheckBox;
    CheckShowTopImages: TCheckBox;
    CheckAutoscroll: TCheckBox;
    Label15: TLabel;
    SpinMaxImageWidth: TSpinEdit;
    Label17: TLabel;
    SpinMaxImageHeight: TSpinEdit;
    Label16: TLabel;
    CheckPassword: TCheckBox;
    Label2: TLabel;
    EditPassword1: TEdit;
    Label3: TLabel;
    EditPassword2: TEdit;
    CheckBtnOpen: TCheckBox;
    CheckBtnEdit: TCheckBox;
    CheckBtnPlay: TCheckBox;
    CheckBtnSettings: TCheckBox;
    Label18: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    OpenDialog1: TOpenDialog;
    Label21: TLabel;
    ComboTitle: TComboBox;
    TabListTemplate: TTabSheet;
    Label22: TLabel;
    MemoListTemplate: TMemo;
    BtnInsert2: TSpeedButton;
    TabUserVars: TTabSheet;
    Bevel4: TBevel;
    Label19: TLabel;
    EditExternalPlayer: TEdit;
    ComboVideoField: TComboBox;
    Label20: TLabel;
    SpeedButton1: TSpeedButton;
    Label23: TLabel;
    CheckSearch: TCheckBox;
    Button1: TButton;
    Memo1: TMemo;
    Label14: TLabel;
    GridUserVars: TNiceGrid;
    ComboLanguages: TComboBox;
    Label25: TLabel;
    procedure FormShow(Sender: TObject);
    procedure BtnApplyClick(Sender: TObject);
    procedure BtnOkClick(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure CheckPasswordClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BtnInsertClick(Sender: TObject);
    procedure ComboDateChange(Sender: TObject);
    procedure Label10MouseEnter(Sender: TObject);
    procedure Label10MouseLeave(Sender: TObject);
    procedure Label10Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure BtnInsert2Click(Sender: TObject);
  private
    { Private declarations }
    procedure MenuClick(Sender: TObject);
  public
    { Public declarations }
    procedure UpdateLanguage;
  end;

var
  FormSettings: TFormSettings;

implementation

{$R *.dfm}

uses
  UnitMain, IniFiles;

procedure TFormSettings.FormCreate(Sender: TObject);

  procedure AddTemplateMenu(Title, Code: string);
  var
    m: TMenuItem;
  begin
    m := TMenuItem.Create(Self);
    m.Caption := Title;
    m.Hint := Code;
    m.OnClick := MenuClick;
    PopupMenu1.Items.Add(m);
  end;

begin
  AddTemplateMenu('Actors', '$ACTORS');
  AddTemplateMenu('Audio Bitrate', '$AUDIOBITRATE');
  AddTemplateMenu('Audio Format', '$AUDIOFORMAT');
  AddTemplateMenu('Borrower', '$BORROWER');
  AddTemplateMenu('Category', '$CATEGORY');
  AddTemplateMenu('Checked', '$CHECKED');
  AddTemplateMenu('Comments', '$COMMENTS');
  AddTemplateMenu('Country', '$COUNTRY');
  AddTemplateMenu('Date', '$DATE');
  AddTemplateMenu('Description', '$DESCRIPTION');
  AddTemplateMenu('Director', '$DIRECTOR');
  AddTemplateMenu('Disks', '$DISKS');
  AddTemplateMenu('Frame Rate', '$FRAMERATE');
  AddTemplateMenu('Language', '$LANGUAGES');
  AddTemplateMenu('Length (Minutes)', '$LENGTH');
  AddTemplateMenu('Media Type', '$MEDIATYPE');
  AddTemplateMenu('Media', '$MEDIA');
  AddTemplateMenu('Number', '$NUMBER');
  AddTemplateMenu('Picture', '$PICTURE');
  AddTemplateMenu('Small Picture', '$SMALLPICTURE');
  AddTemplateMenu('Producer', '$PRODUCER');
  AddTemplateMenu('Rating (Image)', '$RATINGIMG');
  AddTemplateMenu('Rating', '$RATING');
  AddTemplateMenu('Resolution', '$RESOLUTION');
  AddTemplateMenu('Size (MB)', '$SIZE');
  AddTemplateMenu('Source', '$SOURCE');
  AddTemplateMenu('Subtitles', '$SUBTITLES');
  AddTemplateMenu('Title', '$TITLE');
  AddTemplateMenu('Title (Original)', '$ORIGINALTITLE');
  AddTemplateMenu('Title (Translated)', '$TRANSLATEDTITLE');
  AddTemplateMenu('URL', '$URL');
  AddTemplateMenu('Video Bitrate', '$BITRATE');
  AddTemplateMenu('Video Format', '$VIDEOFORMAT');
  AddTemplateMenu('Video Path', '$VIDEOPATH');
  AddTemplateMenu('Year', '$YEAR');
  AddTemplateMenu('Link (in Template List)', '$LINK');
end;

procedure TFormSettings.FormShow(Sender: TObject);
var
  Ini: TIniFile;
  x: Integer;
  StrName, StrValue: string;
  sr: TSearchRec;
  t: TStringList;

begin

  ComboSchemes.Items.Clear;
  Ini := TIniFile.Create(ExtractFilePath(Application.ExeName) + 'Schemes.ini');
  try
    Ini.ReadSections(ComboSchemes.Items);
  finally
    Ini.Free;
  end;
  ComboSchemes.ItemIndex := ComboSchemes.Items.IndexOf(FormMain.ConfColorScheme);

  ComboLanguages.Items.Clear;
  if (FindFirst(ExtractFilePath(Application.ExeName) + '*.lng', faAnyFile, sr) = 0) then
  begin
    t := TStringList.Create;
    try
      repeat
        if (sr.Name = '.') or (sr.Name = '..')
          then Continue;
        t.Add(ChangeFileExt(sr.Name, ''));
      until (FindNext(sr) <> 0);
      t.Sort;
      ComboLanguages.Items.Assign(t);
    finally
      t.Free;
    end;
  end;
  FindClose(sr);
  if (ComboLanguages.Items.Count = 0)
    then ComboLanguages.Items.Add('English');
  ComboLanguages.ItemIndex := ComboLanguages.Items.IndexOf(FormMain.ConfLanguage);

  ComboTitle.ItemIndex := FormMain.ConfTitleType;
  CheckFullScreen.Checked := FormMain.ConfFullScreen;
  CheckShowTopImages.Checked := FormMain.ConfShowTopImages;
  CheckAutoscroll.Checked := FormMain.ConfAutoscroll;
  SpinMaxImageWidth.Value := FormMain.ConfMaxImageWidth;
  SpinMaxImageHeight.Value := FormMain.ConfMaxImageHeight;
  ComboDate.Text := FormMain.ConfDateFormat;
  EditExternalPlayer.Text := FormMain.ConfExternalPlayer;
  ComboVideoField.Text := FormMain.ConfVideoPathField;
  CheckPassword.Checked := FormMain.ConfProtected;
  EditPassword1.Text := FormMain.ConfPassword;
  EditPassword2.Text := FormMain.ConfPassword;
  CheckBtnOpen.Checked := FormMain.ConfShowOpenButton;
  CheckBtnEdit.Checked := FormMain.ConfShowEditButton;
  CheckBtnSettings.Checked := FormMain.ConfShowSettingsButton;
  CheckBtnPlay.Checked := FormMain.ConfShowPlayButton;
  CheckSearch.Checked := FormMain.ConfShowSearch;

  CheckPasswordClick(nil);
  ComboDateChange(nil);

  MemoTemplate.Lines.Assign(FormMain.ConfTemplate);
  MemoListTemplate.Lines.Assign(FormMain.ConfListTemplate);

  GridUserVars.Clear;
  GridUserVars.RowCount := Max(1, FormMain.ConfUserVars.Count);
  for x := 0 to FormMain.ConfUserVars.Count-1 do
  begin
    StrName := FormMain.ConfUserVars.Names[x];
    StrValue := FormMain.ConfUserVars.Values[StrName];
    GridUserVars.Cells[0, x] := StringReplace(StrName, '&equal;', '=', [rfReplaceAll]);
    GridUserVars.Cells[1, x] := StringReplace(StrValue, '&equal;', '=', [rfReplaceAll]);
  end;

end;

procedure TFormSettings.BtnApplyClick(Sender: TObject);
var
  x: Integer;
  StrName, StrValue: string;
begin
  FormMain.ConfTitleType := ComboTitle.ItemIndex;
  FormMain.ConfColorScheme := ComboSchemes.Text;
  FormMain.ConfLanguage := ComboLanguages.Text;
  FormMain.ConfFullScreen := CheckFullScreen.Checked;
  FormMain.ConfShowTopImages := CheckShowTopImages.Checked;
  FormMain.ConfAutoscroll := CheckAutoscroll.Checked;
  FormMain.ConfMaxImageWidth := SpinMaxImageWidth.Value;
  FormMain.ConfMaxImageHeight := SpinMaxImageHeight.Value;
  FormMain.ConfDateFormat := ComboDate.Text;
  FormMain.ConfExternalPlayer := EditExternalPlayer.Text;
  FormMain.ConfVideoPathField := ComboVideoField.Text;
  FormMain.ConfProtected := CheckPassword.Checked;
  FormMain.ConfPassword := EditPassword1.Text;
  FormMain.ConfShowOpenButton := CheckBtnOpen.Checked;
  FormMain.ConfShowEditButton := CheckBtnEdit.Checked;
  FormMain.ConfShowSettingsButton := CheckBtnSettings.Checked;
  FormMain.ConfShowPlayButton := CheckBtnPlay.Checked;
  FormMain.ConfShowSearch := CheckSearch.Checked;
  FormMain.ConfTemplate.Assign(MemoTemplate.Lines);
  FormMain.ConfListTemplate.Assign(MemoListTemplate.Lines);

  FormMain.ConfUserVars.Clear;
  for x := 0 to GridUserVars.RowCount-1 do
  begin
    StrName := StringReplace(GridUserVars.Cells[0, x], '=', '&equal;', [rfReplaceAll]);
    StrValue := StringReplace(GridUserVars.Cells[1, x], '=', '&equal;', [rfReplaceAll]);
    if (StrName <> '')
      then FormMain.ConfUserVars.Values[StrName] := StrValue;
  end;

  FormMain.ApplyConfig;
  BringToFront;
end;

procedure TFormSettings.BtnOkClick(Sender: TObject);
begin
  if CheckPassword.Checked and (EditPassword1.Text <> EditPassword2.Text) then
  begin
    MessageDlg('Passwords mismatch.', mtError, [mbOk], 0);
    EditPassword1.SetFocus;
    Exit;
  end;
  BtnApply.Click;
  FormMain.SaveConfig;
  Close;
end;

procedure TFormSettings.BtnCancelClick(Sender: TObject);
begin
  Close;
end;

procedure TFormSettings.CheckPasswordClick(Sender: TObject);
begin
  EditPassword1.Enabled := CheckPassword.Checked;
  EditPassword2.Enabled := CheckPassword.Checked;
  Label2.Enabled := CheckPassword.Checked;
  Label3.Enabled := CheckPassword.Checked;
end;

procedure TFormSettings.MenuClick(Sender: TObject);
begin
  if (PopupMenu1.Tag = 0)
    then MemoTemplate.SelText := (Sender as TMenuItem).Hint
    else MemoListTemplate.SelText := (Sender as TMenuItem).Hint;
end;

procedure TFormSettings.BtnInsertClick(Sender: TObject);
var
  Pt: TPoint;
begin
  Pt := BtnInsert.ClientToScreen(Point(0, BtnInsert.Height));
  PopupMenu1.Tag := 0;
  PopupMenu1.Popup(Pt.X, Pt.Y);
end;

procedure TFormSettings.BtnInsert2Click(Sender: TObject);
var
  Pt: TPoint;
begin
  Pt := BtnInsert.ClientToScreen(Point(0, BtnInsert.Height));
  PopupMenu1.Tag := 1;
  PopupMenu1.Popup(Pt.X, Pt.Y);
end;

procedure TFormSettings.ComboDateChange(Sender: TObject);
begin
  EditDateSample.Text := FormatDateTime(ComboDate.Text, Now);
end;

procedure TFormSettings.Label10MouseEnter(Sender: TObject);
begin
  (Sender as TLabel).Font.Color := clRed;
end;

procedure TFormSettings.Label10MouseLeave(Sender: TObject);
begin
  (Sender as TLabel).Font.Color := clGreen;
end;

procedure TFormSettings.SpeedButton1Click(Sender: TObject);
begin
  OpenDialog1.FileName := EditExternalPlayer.Text;
  if OpenDialog1.Execute
    then EditExternalPlayer.Text := OpenDialog1.FileName;
end;

procedure TFormSettings.Label10Click(Sender: TObject);
begin
  case (Sender as TComponent).Tag of
    0: ShellExecute(0, 'open', 'http://www.priyatna.org/', nil, nil, SW_SHOW);
    1: ShellExecute(0, 'open', 'mailto:me@priyatna.org', nil, nil, SW_SHOW);
  end;
end;

procedure TFormSettings.UpdateLanguage;
begin
  //
end;

end.
