{-------------------------------------------------------------------------------

The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is "UnitPassword.pas" released at June 12nd, 2007.

The Initial Developer of the Original Code is

  Priyatna
  Website: http://www.priyatna.org
  Email: me@priyatna.org
  Copyright (c) 2007-2008 Priyatna
  All Rights Reserved.

Contributor(s): -

Description: Password form.

Known Issues: -

Last Modified: 2008-07-24

-------------------------------------------------------------------------------}

unit UnitPassword;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TFormPassword = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    BtnOk: TButton;
    BtnCancel: TButton;
    Timer1: TTimer;
    procedure FormShow(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure BtnOkClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
    Done: Boolean;
  end;

var
  FormPassword: TFormPassword;

implementation

{$R *.dfm}

uses
  TransUtils;

procedure TFormPassword.FormShow(Sender: TObject);
begin
  Caption := _('Password Required');
  Label1.Caption := _('Enter Password');
  BtnOk.Caption := _('&OK');
  BtnCancel.Caption := _('&Cancel');
  Done := False;
  Edit1.Text := '';
  Edit1.SetFocus;
  Timer1.Enabled := True;
end;

procedure TFormPassword.Timer1Timer(Sender: TObject);
begin
  BtnCancel.Click;
end;

procedure TFormPassword.BtnCancelClick(Sender: TObject);
begin
  Done := False;
  Close;
end;

procedure TFormPassword.BtnOkClick(Sender: TObject);
begin
  Done := True;
  Close;
end;

procedure TFormPassword.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Timer1.Enabled := False;
end;

procedure TFormPassword.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
  if (Key = #13)
    then BtnOk.Click;
end;

end.
