{-------------------------------------------------------------------------------

The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is "UnitSettings.pas" released at June 12nd, 2007.

The Initial Developer of the Original Code is

  Priyatna
  Website: http://www.priyatna.org
  Email: me@priyatna.org
  Copyright (c) 2007-2008 Priyatna
  All Rights Reserved.

Contributor(s):
  - Alexander Herz <aherz.kazan@arcor.de>, search feature and improvements.
  - Mickal Vanneufville <mickael.vanneufville@gmail.com> bugs fix and improvements.

Description: Settings form.

Known Issues: -

Last Modified: 2014-04-19 by Mickal Vanneufville

-------------------------------------------------------------------------------}

unit UnitSettings;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Buttons, Menus, jpeg, ExtCtrls, ShellAPI,
  Spin, NiceGrid, Math;

type
  TFormSettings = class(TForm)
    PageControl1: TPageControl;
    TabGeneral: TTabSheet;
    TabTemplate: TTabSheet;
    BtnOk: TButton;
    BtnCancel: TButton;
    TabSheet2: TTabSheet;
    BtnApply: TButton;
    MemoTemplate: TMemo;
    Label4: TLabel;
    BtnInsert: TSpeedButton;
    PopupMenu1: TPopupMenu;
    Panel1: TPanel;
    Image1: TImage;
    Label7: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label8: TLabel;
    Shape1: TShape;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    TabSecurity: TTabSheet;
    Label1: TLabel;
    ComboSchemes: TComboBox;
    Label5: TLabel;
    ComboDate: TComboBox;
    Label6: TLabel;
    EditDateSample: TEdit;
    CheckFullScreen: TCheckBox;
    CheckShowTopImages: TCheckBox;
    CheckAutoscroll: TCheckBox;
    Label15: TLabel;
    SpinMaxImageWidth: TSpinEdit;
    Label17: TLabel;
    SpinMaxImageHeight: TSpinEdit;
    Label16: TLabel;
    CheckPassword: TCheckBox;
    Label2: TLabel;
    EditPassword1: TEdit;
    Label3: TLabel;
    EditPassword2: TEdit;
    CheckBtnOpen: TCheckBox;
    CheckBtnEdit: TCheckBox;
    CheckBtnPlay: TCheckBox;
    CheckBtnSettings: TCheckBox;
    Label18: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    OpenDialog1: TOpenDialog;
    Label21: TLabel;
    ComboTitle: TComboBox;
    TabListTemplate: TTabSheet;
    Label22: TLabel;
    MemoListTemplate: TMemo;
    BtnInsert2: TSpeedButton;
    TabUserVars: TTabSheet;
    Bevel4: TBevel;
    Label19: TLabel;
    EditExternalPlayer: TEdit;
    ComboVideoField: TComboBox;
    Label20: TLabel;
    SpeedButton1: TSpeedButton;
    Label23: TLabel;
    CheckSearch: TCheckBox;
    Button1: TButton;
    Memo1: TMemo;
    Label14: TLabel;
    GridUserVars: TNiceGrid;
    ComboLanguages: TComboBox;
    Label25: TLabel;
    Label24: TLabel;
    SpinMaxExtraImageWidth: TSpinEdit;
    Label26: TLabel;
    SpinMaxExtraImageHeight: TSpinEdit;
    Label27: TLabel;
    procedure FormShow(Sender: TObject);
    procedure BtnApplyClick(Sender: TObject);
    procedure BtnOkClick(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure CheckPasswordClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BtnInsertClick(Sender: TObject);
    procedure ComboDateChange(Sender: TObject);
    procedure Label10MouseEnter(Sender: TObject);
    procedure Label10MouseLeave(Sender: TObject);
    procedure Label10Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure BtnInsert2Click(Sender: TObject);
  private
    { Private declarations }
    procedure FillComboVideoField();
    procedure FillPopupMenu1();
    procedure MenuClick(Sender: TObject);
  public
    { Public declarations }
    procedure UpdateLanguage;
  end;

const
  HTMLColorTag: array [0..12] of string = ('#FFFFFF', '#ED1C24', '#FF7F27',
    '#FFF200', '#B5E61D', '#22B14C', '#1CEEEE', '#40B0FF', '#A080FF',
    '#FF60E0', '#D00EE0', '#B98657', '#999999');

var
  FormSettings: TFormSettings;

implementation

{$R *.dfm}

uses
  UnitMain, IniFiles, MovieClass;

procedure TFormSettings.FillComboVideoField();
var
  i: Integer;

  procedure AddVideoField(Title: string);
  begin
    ComboVideoField.AddItem(Title, nil);
  end;
begin
  ComboVideoField.Clear;
  ComboVideoField.Items.BeginUpdate;
  AddVideoField('FilePath');
  AddVideoField('URL');
  AddVideoField('Source');
  AddVideoField('Media');
  AddVideoField('MediaType');
  AddVideoField('Borrower');
  AddVideoField('OriginalTitle');
  AddVideoField('TranslatedTitle');
  AddVideoField('Director');
  AddVideoField('Producer');
  AddVideoField('Writer');
  AddVideoField('Composer');
  AddVideoField('Actors');
  AddVideoField('Country');
  AddVideoField('Category');
  AddVideoField('Certification');
  AddVideoField('Description');
  AddVideoField('Comments');
  AddVideoField('VideoFormat');
  AddVideoField('AudioFormat');
  AddVideoField('Resolution');
  AddVideoField('Framerate');
  AddVideoField('Languages');
  AddVideoField('Subtitles');
  AddVideoField('Size');
  if FormMain.List <> nil then
    with FormMain.List.CustomFieldsProperties do
      for i := 0 to Count-1 do
        if (Objects[i].FieldType = ftString) or (Objects[i].FieldType = ftUrl) or
          (Objects[i].FieldType = ftList) or (Objects[i].FieldType = ftText) then
        begin
          AddVideoField(Objects[i].FieldTag);
        end;
  ComboVideoField.Items.EndUpdate;
end;

procedure TFormSettings.FillPopupMenu1();
var
  i: Integer;
  MovieFieldsMenu, CustomFieldsMenu, ExtraFieldsMenu : TMenuItem;
  function AddSubMenu(Menu: TPopupMenu; Title: string): TMenuItem;
  var
    m: TMenuItem;
  begin
    m := TMenuItem.Create(Self);
    m.Caption := Title;
    Menu.Items.Add(m);
    Result := m;
  end;
  procedure AddTemplateMenu(Menu: TMenuItem; Title, Code: string);
  var
    m: TMenuItem;
  begin
    m := TMenuItem.Create(Self);
    m.Caption := Title;
    m.Hint := Code;
    m.OnClick := MenuClick;
    Menu.Add(m);
  end;
begin
  PopupMenu1.Items.Clear;
  MovieFieldsMenu := AddSubMenu(PopupMenu1, 'Movie fields');
  CustomFieldsMenu := AddSubMenu(PopupMenu1, 'Custom fields');
  ExtraFieldsMenu := AddSubMenu(PopupMenu1, 'Extra fields');

  // Movie Fields
  AddTemplateMenu(MovieFieldsMenu, 'Link (in Template List)', '$LINK');
  AddTemplateMenu(MovieFieldsMenu, 'Record number (in Template List)', '$RECNR');
  AddTemplateMenu(MovieFieldsMenu, 'Actors', '$ACTORS');
  AddTemplateMenu(MovieFieldsMenu, 'Audio Bitrate', '$AUDIOBITRATE');
  AddTemplateMenu(MovieFieldsMenu, 'Audio Format', '$AUDIOFORMAT');
  AddTemplateMenu(MovieFieldsMenu, 'Borrower', '$BORROWER');
  AddTemplateMenu(MovieFieldsMenu, 'Category', '$CATEGORY');
  AddTemplateMenu(MovieFieldsMenu, 'Certification', '$CERTIFICATION');
  AddTemplateMenu(MovieFieldsMenu, 'Checked', '$CHECKED');
  AddTemplateMenu(MovieFieldsMenu, 'Color Tag (HTML)', '$COLORHTML');
  AddTemplateMenu(MovieFieldsMenu, 'Color Tag', '$COLORTAG');
  AddTemplateMenu(MovieFieldsMenu, 'Comments', '$COMMENTS');
  AddTemplateMenu(MovieFieldsMenu, 'Composer', '$COMPOSER');
  AddTemplateMenu(MovieFieldsMenu, 'Country', '$COUNTRY');
  AddTemplateMenu(MovieFieldsMenu, 'Date', '$DATE');
  AddTemplateMenu(MovieFieldsMenu, 'Date Watched', '$DATEWATCHED');
  AddTemplateMenu(MovieFieldsMenu, 'Description', '$DESCRIPTION');
  AddTemplateMenu(MovieFieldsMenu, 'Director', '$DIRECTOR');
  AddTemplateMenu(MovieFieldsMenu, 'Disks', '$DISKS');
  AddTemplateMenu(MovieFieldsMenu, 'File Path', '$FILEPATH');
  AddTemplateMenu(MovieFieldsMenu, 'Frame Rate', '$FRAMERATE');
  AddTemplateMenu(MovieFieldsMenu, 'Language', '$LANGUAGES');
  AddTemplateMenu(MovieFieldsMenu, 'Length (Minutes)', '$LENGTH');
  AddTemplateMenu(MovieFieldsMenu, 'Media Type', '$MEDIATYPE');
  AddTemplateMenu(MovieFieldsMenu, 'Media', '$MEDIA');
  AddTemplateMenu(MovieFieldsMenu, 'Number', '$NUMBER');
  AddTemplateMenu(MovieFieldsMenu, 'Picture', '$PICTURE');
  AddTemplateMenu(MovieFieldsMenu, 'Large Picture', '$LARGEPICTURE');
  AddTemplateMenu(MovieFieldsMenu, 'Medium Picture', '$MEDIUMPICTURE');
  AddTemplateMenu(MovieFieldsMenu, 'Small Picture', '$SMALLPICTURE');
  AddTemplateMenu(MovieFieldsMenu, 'Tiny Picture', '$TINYPICTURE');
  AddTemplateMenu(MovieFieldsMenu, 'Producer', '$PRODUCER');
  AddTemplateMenu(MovieFieldsMenu, 'Rating (Image)', '$RATINGIMG');
  AddTemplateMenu(MovieFieldsMenu, 'Rating', '$RATING');
  AddTemplateMenu(MovieFieldsMenu, 'Resolution', '$RESOLUTION');
  AddTemplateMenu(MovieFieldsMenu, 'Size (MB)', '$SIZE');
  AddTemplateMenu(MovieFieldsMenu, 'Source', '$SOURCE');
  AddTemplateMenu(MovieFieldsMenu, 'Subtitles', '$SUBTITLES');
  AddTemplateMenu(MovieFieldsMenu, 'Title', '$TITLE');
  AddTemplateMenu(MovieFieldsMenu, 'Title (Original)', '$ORIGINALTITLE');
  AddTemplateMenu(MovieFieldsMenu, 'Title (Translated)', '$TRANSLATEDTITLE');
  AddTemplateMenu(MovieFieldsMenu, 'URL', '$URL');
  AddTemplateMenu(MovieFieldsMenu, 'User Rating (Image)', '$USERRATINGIMG');
  AddTemplateMenu(MovieFieldsMenu, 'User Rating', '$USERRATING');
  AddTemplateMenu(MovieFieldsMenu, 'Video Bitrate', '$BITRATE');
  AddTemplateMenu(MovieFieldsMenu, 'Video Format', '$VIDEOFORMAT');
  AddTemplateMenu(MovieFieldsMenu, 'Video Path', '$VIDEOPATH');
  AddTemplateMenu(MovieFieldsMenu, 'Writer', '$WRITER');
  AddTemplateMenu(MovieFieldsMenu, 'Year', '$YEAR');

  // Custom fields
  if FormMain.List <> nil then
    with FormMain.List.CustomFieldsProperties do
    begin
      CustomFieldsMenu.Enabled := Count > 0;
      for i := 0 to Count-1 do
        AddTemplateMenu(CustomFieldsMenu, Objects[i].FieldName, '$CF_' + UpperCase(Objects[i].FieldTag));
    end;

  // Extra fields
  AddTemplateMenu(ExtraFieldsMenu, 'Begin list', '$EXTRA_BEGIN(CATEGORY [optional], CHECKED [optional], START [optional], END [optional])');
  AddTemplateMenu(ExtraFieldsMenu, 'End list', '$EXTRA_END');
  AddTemplateMenu(ExtraFieldsMenu, 'Record number (in List)', '$EXTRA_RECNR');
  AddTemplateMenu(ExtraFieldsMenu, 'Number', '$EXTRA_NUMBER(TAG [optional if you list extras])');
  AddTemplateMenu(ExtraFieldsMenu, 'Checked', '$EXTRA_CHECKED(TAG [optional if you list extras])');
  AddTemplateMenu(ExtraFieldsMenu, 'Tag', '$EXTRA_TAG(TAG [optional if you list extras])');
  AddTemplateMenu(ExtraFieldsMenu, 'Title', '$EXTRA_TITLE(TAG [optional if you list extras])');
  AddTemplateMenu(ExtraFieldsMenu, 'Category', '$EXTRA_CATEGORY(TAG [optional if you list extras])');
  AddTemplateMenu(ExtraFieldsMenu, 'URL', '$EXTRA_URL(TAG [optional if you list extras])');
  AddTemplateMenu(ExtraFieldsMenu, 'Description', '$EXTRA_DESCRIPTION(TAG [optional if you list extras])');
  AddTemplateMenu(ExtraFieldsMenu, 'Comments', '$EXTRA_COMMENTS(TAG [optional if you list extras])');
  AddTemplateMenu(ExtraFieldsMenu, 'Created by', '$EXTRA_CREATEDBY(TAG [optional if you list extras])');
  AddTemplateMenu(ExtraFieldsMenu, 'Picture', '$EXTRA_PICTURE(TAG [optional if you list extras])');
  AddTemplateMenu(ExtraFieldsMenu, 'Large Picture', '$EXTRA_LARGEPICTURE(TAG [optional if you list extras])');
  AddTemplateMenu(ExtraFieldsMenu, 'Medium Picture', '$EXTRA_MEDIUMPICTURE(TAG [optional if you list extras])');
  AddTemplateMenu(ExtraFieldsMenu, 'Small Picture', '$EXTRA_SMALLPICTURE(TAG [optional if you list extras])');
  AddTemplateMenu(ExtraFieldsMenu, 'Tiny Picture', '$EXTRA_TINYPICTURE(TAG [optional if you list extras])');
end;

procedure TFormSettings.FormCreate(Sender: TObject);
begin
  //
end;

procedure TFormSettings.FormShow(Sender: TObject);
var
  Ini: TIniFile;
  x: Integer;
  StrName, StrValue: string;
  sr: TSearchRec;
  t: TStringList;
begin
  FillComboVideoField;
  FillPopupMenu1;
  ComboSchemes.Items.Clear;
  Ini := TIniFile.Create(ExtractFilePath(Application.ExeName) + 'Schemes.ini');
  try
    Ini.ReadSections(ComboSchemes.Items);
  finally
    Ini.Free;
  end;
  ComboSchemes.ItemIndex := ComboSchemes.Items.IndexOf(FormMain.ConfColorScheme);

  ComboLanguages.Items.Clear;
  if (FindFirst(ExtractFilePath(Application.ExeName) + '*.lng', faAnyFile, sr) = 0) then
  begin
    t := TStringList.Create;
    try
      repeat
        if (sr.Name = '.') or (sr.Name = '..')
          then Continue;
        t.Add(ChangeFileExt(sr.Name, ''));
      until (FindNext(sr) <> 0);
      t.Sort;
      ComboLanguages.Items.Assign(t);
    finally
      t.Free;
    end;
  end;
  FindClose(sr);
  if (ComboLanguages.Items.Count = 0)
    then ComboLanguages.Items.Add('English');
  ComboLanguages.ItemIndex := ComboLanguages.Items.IndexOf(FormMain.ConfLanguage);

  ComboTitle.ItemIndex := FormMain.ConfTitleType;
  CheckFullScreen.Checked := FormMain.ConfFullScreen;
  CheckShowTopImages.Checked := FormMain.ConfShowTopImages;
  CheckAutoscroll.Checked := FormMain.ConfAutoscroll;
  SpinMaxImageWidth.Value := FormMain.ConfMaxImageWidth;
  SpinMaxImageHeight.Value := FormMain.ConfMaxImageHeight;
  SpinMaxExtraImageWidth.Value := FormMain.ConfMaxExtraImageWidth;
  SpinMaxExtraImageHeight.Value := FormMain.ConfMaxExtraImageHeight;
  ComboDate.Text := FormMain.ConfDateFormat;
  EditExternalPlayer.Text := FormMain.ConfExternalPlayer;
  ComboVideoField.Text := FormMain.ConfVideoPathField;
  CheckPassword.Checked := FormMain.ConfProtected;
  EditPassword1.Text := FormMain.ConfPassword;
  EditPassword2.Text := FormMain.ConfPassword;
  CheckBtnOpen.Checked := FormMain.ConfShowOpenButton;
  CheckBtnEdit.Checked := FormMain.ConfShowEditButton;
  CheckBtnSettings.Checked := FormMain.ConfShowSettingsButton;
  CheckBtnPlay.Checked := FormMain.ConfShowPlayButton;
  CheckSearch.Checked := FormMain.ConfShowSearch;

  CheckPasswordClick(nil);
  ComboDateChange(nil);

  MemoTemplate.Lines.Assign(FormMain.ConfTemplate);
  MemoListTemplate.Lines.Assign(FormMain.ConfListTemplate);

  GridUserVars.Clear;
  GridUserVars.RowCount := Max(1, FormMain.ConfUserVars.Count);
  for x := 0 to FormMain.ConfUserVars.Count-1 do
  begin
    StrName := FormMain.ConfUserVars.Names[x];
    StrValue := FormMain.ConfUserVars.Values[StrName];
    GridUserVars.Cells[0, x] := StringReplace(StrName, '&equal;', '=', [rfReplaceAll]);
    GridUserVars.Cells[1, x] := StringReplace(StrValue, '&equal;', '=', [rfReplaceAll]);
  end;
end;

procedure TFormSettings.BtnApplyClick(Sender: TObject);
var
  x: Integer;
  StrName, StrValue: string;
begin
  FormMain.ConfTitleType := ComboTitle.ItemIndex;
  FormMain.ConfColorScheme := ComboSchemes.Text;
  FormMain.ConfLanguage := ComboLanguages.Text;
  FormMain.ConfFullScreen := CheckFullScreen.Checked;
  FormMain.ConfShowTopImages := CheckShowTopImages.Checked;
  FormMain.ConfAutoscroll := CheckAutoscroll.Checked;
  FormMain.ConfMaxImageWidth := SpinMaxImageWidth.Value;
  FormMain.ConfMaxImageHeight := SpinMaxImageHeight.Value;
  FormMain.ConfMaxExtraImageWidth := SpinMaxExtraImageWidth.Value;
  FormMain.ConfMaxExtraImageHeight := SpinMaxExtraImageHeight.Value;
  FormMain.ConfDateFormat := ComboDate.Text;
  FormMain.ConfExternalPlayer := EditExternalPlayer.Text;
  FormMain.ConfVideoPathField := ComboVideoField.Text;
  FormMain.ConfProtected := CheckPassword.Checked;
  FormMain.ConfPassword := EditPassword1.Text;
  FormMain.ConfShowOpenButton := CheckBtnOpen.Checked;
  FormMain.ConfShowEditButton := CheckBtnEdit.Checked;
  FormMain.ConfShowSettingsButton := CheckBtnSettings.Checked;
  FormMain.ConfShowPlayButton := CheckBtnPlay.Checked;
  FormMain.ConfShowSearch := CheckSearch.Checked;
  FormMain.ConfTemplate.Assign(MemoTemplate.Lines);
  FormMain.ConfListTemplate.Assign(MemoListTemplate.Lines);

  FormMain.ConfUserVars.Clear;
  for x := 0 to GridUserVars.RowCount-1 do
  begin
    StrName := StringReplace(GridUserVars.Cells[0, x], '=', '&equal;', [rfReplaceAll]);
    StrValue := StringReplace(GridUserVars.Cells[1, x], '=', '&equal;', [rfReplaceAll]);
    if (StrName <> '')
      then FormMain.ConfUserVars.Values[StrName] := StrValue;
  end;

  FormMain.ApplyConfig;
  BringToFront;
end;

procedure TFormSettings.BtnOkClick(Sender: TObject);
begin
  if CheckPassword.Checked and (EditPassword1.Text <> EditPassword2.Text) then
  begin
    MessageDlg('Passwords mismatch.', mtError, [mbOk], 0);
    EditPassword1.SetFocus;
    Exit;
  end;
  BtnApply.Click;
  FormMain.SaveConfig;
  Close;
end;

procedure TFormSettings.BtnCancelClick(Sender: TObject);
begin
  Close;
end;

procedure TFormSettings.CheckPasswordClick(Sender: TObject);
begin
  EditPassword1.Enabled := CheckPassword.Checked;
  EditPassword2.Enabled := CheckPassword.Checked;
  Label2.Enabled := CheckPassword.Checked;
  Label3.Enabled := CheckPassword.Checked;
end;

procedure TFormSettings.MenuClick(Sender: TObject);
begin
  if (PopupMenu1.Tag = 0)
    then MemoTemplate.SelText := (Sender as TMenuItem).Hint
    else MemoListTemplate.SelText := (Sender as TMenuItem).Hint;
end;

procedure TFormSettings.BtnInsertClick(Sender: TObject);
var
  Pt: TPoint;
begin
  Pt := BtnInsert.ClientToScreen(Point(0, BtnInsert.Height));
  PopupMenu1.Tag := 0;
  PopupMenu1.Popup(Pt.X, Pt.Y);
end;

procedure TFormSettings.BtnInsert2Click(Sender: TObject);
var
  Pt: TPoint;
begin
  Pt := BtnInsert.ClientToScreen(Point(0, BtnInsert.Height));
  PopupMenu1.Tag := 1;
  PopupMenu1.Popup(Pt.X, Pt.Y);
end;

procedure TFormSettings.ComboDateChange(Sender: TObject);
begin
  EditDateSample.Text := FormatDateTime(ComboDate.Text, Now);
end;

procedure TFormSettings.Label10MouseEnter(Sender: TObject);
begin
  (Sender as TLabel).Font.Color := clRed;
end;

procedure TFormSettings.Label10MouseLeave(Sender: TObject);
begin
  (Sender as TLabel).Font.Color := clGreen;
end;

procedure TFormSettings.SpeedButton1Click(Sender: TObject);
begin
  OpenDialog1.FileName := EditExternalPlayer.Text;
  if OpenDialog1.Execute
    then EditExternalPlayer.Text := OpenDialog1.FileName;
end;

procedure TFormSettings.Label10Click(Sender: TObject);
begin
  case (Sender as TComponent).Tag of
    0: ShellExecute(0, 'open', 'http://www.priyatna.org/', nil, nil, SW_SHOW);
    1: ShellExecute(0, 'open', 'mailto:me@priyatna.org', nil, nil, SW_SHOW);
  end;
end;

procedure TFormSettings.UpdateLanguage;
begin
  //
end;

end.
