{-------------------------------------------------------------------------------

The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is "UnitOpen.pas" released at June 12nd, 2007.

The Initial Developer of the Original Code is

  Priyatna
  Website: http://www.priyatna.org
  Email: me@priyatna.org
  Copyright (c) 2007-2008 Priyatna
  All Rights Reserved.

Contributor(s): -

Description: Open movie form.

Known Issues: -

Last Modified: 2008-07-24

-------------------------------------------------------------------------------}

unit UnitOpen;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons;

type
  TFormOpen = class(TForm)
    EditFileName: TEdit;
    BtnDialog: TSpeedButton;
    CheckAutoOpen: TCheckBox;
    Bevel1: TBevel;
    BtnOk: TButton;
    BtnCancel: TButton;
    OpenDialog1: TOpenDialog;
    procedure FormShow(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure BtnOkClick(Sender: TObject);
    procedure BtnDialogClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Done: Boolean;
  end;

var
  FormOpen: TFormOpen;

implementation

{$R *.dfm}

uses
  TransUtils;

procedure TFormOpen.FormShow(Sender: TObject);
begin
  Caption := _('Open Movie Catalog');
  CheckAutoOpen.Caption := _('Open this file on every program start');
  BtnOk.Caption := _('&OK');
  BtnCancel.Caption := _('&Cancel');
  Done := False;
end;

procedure TFormOpen.BtnCancelClick(Sender: TObject);
begin
  Close;
end;

procedure TFormOpen.BtnOkClick(Sender: TObject);
begin
  Done := True;
  Close;
end;

procedure TFormOpen.BtnDialogClick(Sender: TObject);
begin
  if OpenDialog1.Execute
    then EditFileName.Text := OpenDialog1.FileName;
end;

end.
